/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.pipe;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.PipelineAssembler;
import com.sun.xml.ws.api.pipe.PipelineAssemblerFactory;
import com.sun.xml.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubelineAssembler;
import com.sun.xml.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.util.pipe.StandaloneTubeAssembler;
import java.util.logging.Logger;

public abstract class TubelineAssemblerFactory {
    private static final Logger logger = Logger.getLogger(TubelineAssemblerFactory.class.getName());

    public abstract TubelineAssembler doCreate(BindingID var1);

    public static TubelineAssembler create(ClassLoader classLoader, BindingID bindingId) {
        for (TubelineAssemblerFactory factory : ServiceFinder.find(TubelineAssemblerFactory.class, classLoader)) {
            TubelineAssembler assembler = factory.doCreate(bindingId);
            if (assembler == null) continue;
            logger.fine(factory.getClass() + " successfully created " + assembler);
            return assembler;
        }
        PipelineAssembler assembler = PipelineAssemblerFactory.create(classLoader, bindingId);
        if (assembler != null) {
            return new TubelineAssemblerAdapter(assembler);
        }
        return new StandaloneTubeAssembler();
    }

    private static class TubelineAssemblerAdapter
    implements TubelineAssembler {
        private PipelineAssembler assembler;

        TubelineAssemblerAdapter(PipelineAssembler assembler) {
            this.assembler = assembler;
        }

        @NotNull
        public Tube createClient(@NotNull ClientTubeAssemblerContext context) {
            ClientPipeAssemblerContext ctxt = new ClientPipeAssemblerContext(context.getAddress(), context.getWsdlModel(), context.getService(), context.getBinding(), context.getContainer());
            return PipeAdapter.adapt(this.assembler.createClient(ctxt));
        }

        @NotNull
        public Tube createServer(@NotNull ServerTubeAssemblerContext context) {
            ServerPipeAssemblerContext ctxt = new ServerPipeAssemblerContext(context.getSEIModel(), context.getWsdlModel(), context.getEndpoint(), context.getTerminalPipe(), context.isSynchronous());
            return PipeAdapter.adapt(this.assembler.createServer(ctxt));
        }
    }
}

