/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.pipe;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.transport.http.client.HttpTransportPipe;
import com.sun.xml.ws.util.ServiceFinder;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;

public abstract class TransportPipeFactory {
    private static final Logger logger = Logger.getLogger(TransportPipeFactory.class.getName());

    public abstract Pipe doCreate(@NotNull ClientPipeAssemblerContext var1);

    public static Pipe create(@Nullable ClassLoader classLoader, @NotNull ClientPipeAssemblerContext context) {
        for (TransportPipeFactory factory : ServiceFinder.find(TransportPipeFactory.class, classLoader)) {
            Pipe pipe = factory.doCreate(context);
            if (pipe == null) continue;
            logger.fine(factory.getClass() + " successfully created " + pipe);
            return pipe;
        }
        String scheme = context.getAddress().getURI().getScheme();
        if (scheme != null && (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https"))) {
            return new HttpTransportPipe(context.getBinding());
        }
        throw new WebServiceException("Unsupported endpoint address: " + context.getAddress());
    }
}

