/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.pipe;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.client.dispatch.DataSourceDispatch;
import com.sun.xml.ws.client.dispatch.DispatchImpl;
import com.sun.xml.ws.client.dispatch.JAXBDispatch;
import com.sun.xml.ws.client.dispatch.SOAPMessageDispatch;
import com.sun.xml.ws.client.dispatch.SourceDispatch;
import com.sun.xml.ws.client.sei.SEIStub;
import com.sun.xml.ws.model.SOAPSEIModel;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Stubs {
    private Stubs() {
    }

    public static Dispatch<SOAPMessage> createSAAJDispatch(QName portName, WSService owner, WSBinding binding, Service.Mode mode, Pipe next) {
        DispatchImpl.checkValidSOAPMessageDispatch(binding, mode);
        return new SOAPMessageDispatch(portName, SOAPMessage.class, mode, (WSServiceDelegate)owner, next, (BindingImpl)binding);
    }

    public static Dispatch<DataSource> createDataSourceDispatch(QName portName, WSService owner, WSBinding binding, Service.Mode mode, Pipe next) {
        DispatchImpl.checkValidDataSourceDispatch(binding, mode);
        return new DataSourceDispatch(portName, DataSource.class, mode, (WSServiceDelegate)owner, next, (BindingImpl)binding);
    }

    public static Dispatch<Source> createSourceDispatch(QName portName, WSService owner, WSBinding binding, Service.Mode mode, Pipe next) {
        return new SourceDispatch(portName, Source.class, mode, (WSServiceDelegate)owner, next, (BindingImpl)binding);
    }

    public static <T> Dispatch<T> createDispatch(QName portName, WSService owner, WSBinding binding, Class<T> clazz, Service.Mode mode, Pipe next) {
        if (clazz == SOAPMessage.class) {
            return Stubs.createSAAJDispatch(portName, owner, binding, mode, next);
        }
        if (clazz == Source.class) {
            return Stubs.createSourceDispatch(portName, owner, binding, mode, next);
        }
        if (clazz == DataSource.class) {
            return Stubs.createDataSourceDispatch(portName, owner, binding, mode, next);
        }
        throw new WebServiceException("Unknown class type " + clazz.getName());
    }

    public static Dispatch<Object> createJAXBDispatch(QName portName, WSService owner, WSBinding binding, JAXBContext jaxbContext, Service.Mode mode, Pipe next) {
        return new JAXBDispatch(portName, jaxbContext, mode, (WSServiceDelegate)owner, next, (BindingImpl)binding);
    }

    public <T> T createPortProxy(WSService service, WSBinding binding, SEIModel model, Class<T> portInterface, Pipe next) {
        SEIStub ps = new SEIStub(service, (BindingImpl)binding, (SOAPSEIModel)model, next);
        return portInterface.cast(Proxy.newProxyInstance(portInterface.getClassLoader(), new Class[]{portInterface, BindingProvider.class}, (InvocationHandler)ps));
    }
}

