/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.pipe;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.addressing.WsaServerPipe;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.server.ServerPipelineHook;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.handler.ServerLogicalHandlerPipe;
import com.sun.xml.ws.handler.ServerSOAPHandlerPipe;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.protocol.soap.ServerMUPipe;
import javax.xml.ws.soap.SOAPBinding;

public final class ServerPipeAssemblerContext {
    private final SEIModel seiModel;
    private final WSDLPort wsdlModel;
    private final WSEndpoint endpoint;
    private final WSBinding binding;
    private final Pipe terminal;
    private final boolean isSynchronous;

    public ServerPipeAssemblerContext(@Nullable SEIModel seiModel, @Nullable WSDLPort wsdlModel, @NotNull WSEndpoint endpoint, @NotNull Pipe terminal, boolean isSynchronous) {
        this.seiModel = seiModel;
        this.wsdlModel = wsdlModel;
        this.endpoint = endpoint;
        this.terminal = terminal;
        this.binding = endpoint.getBinding();
        this.isSynchronous = isSynchronous;
    }

    @Nullable
    public SEIModel getSEIModel() {
        return this.seiModel;
    }

    @Nullable
    public WSDLPort getWsdlModel() {
        return this.wsdlModel;
    }

    @NotNull
    public WSEndpoint getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public Pipe createServerMUPipe(@NotNull Pipe next) {
        if (this.binding instanceof SOAPBinding) {
            return new ServerMUPipe(this.binding, next);
        }
        return next;
    }

    @NotNull
    public Pipe createMonitoringPipe(@NotNull Pipe next) {
        ServerPipelineHook hook = this.endpoint.getContainer().getSPI(ServerPipelineHook.class);
        if (hook != null) {
            return hook.createMonitoringPipe(this, next);
        }
        return next;
    }

    @NotNull
    public Pipe createSecurityPipe(@NotNull Pipe next) {
        ServerPipelineHook hook = this.endpoint.getContainer().getSPI(ServerPipelineHook.class);
        if (hook != null) {
            return hook.createSecurityPipe(this, next);
        }
        return next;
    }

    @NotNull
    public Pipe createHandlerPipe(@NotNull Pipe next) {
        if (!this.binding.getHandlerChain().isEmpty()) {
            ServerLogicalHandlerPipe cousin = new ServerLogicalHandlerPipe(this.binding, this.wsdlModel, next);
            next = cousin;
            if (this.binding instanceof SOAPBinding) {
                return new ServerSOAPHandlerPipe(this.binding, next, cousin);
            }
        }
        return next;
    }

    public Pipe createWsaPipe(Pipe next) {
        if (this.wsdlModel == null) {
            if (this.binding.hasFeature("http://java.sun.com/xml/ns/jaxws/2004/08/addressing")) {
                return new WsaServerPipe(this.wsdlModel, this.binding, next);
            }
            return next;
        }
        WSDLPortImpl impl = (WSDLPortImpl)this.wsdlModel;
        if (impl.isAddressingEnabled()) {
            return new WsaServerPipe(this.wsdlModel, this.binding, next);
        }
        return next;
    }

    @NotNull
    public Pipe getTerminalPipe() {
        return this.terminal;
    }

    public boolean isSynchronous() {
        return this.isSynchronous;
    }
}

