/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.message;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.addressing.WsaPipeHelper;
import com.sun.xml.ws.addressing.WsaPipeHelperImpl;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.message.StringHeader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HeaderList
extends ArrayList<Header> {
    private int understoodBits;
    private BitSet moreUnderstoodBits = null;
    private String to = null;
    private String action = null;
    private EndpointReference replyTo = null;
    private EndpointReference faultTo = null;
    private String messageId;

    public HeaderList() {
    }

    public HeaderList(HeaderList that) {
        super(that);
        this.understoodBits = that.understoodBits;
        if (that.moreUnderstoodBits != null) {
            this.moreUnderstoodBits = (BitSet)that.moreUnderstoodBits.clone();
        }
        this.to = that.to;
        this.action = that.action;
        this.replyTo = that.replyTo;
        this.faultTo = that.faultTo;
        this.messageId = that.messageId;
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public Header get(int index) {
        return (Header)super.get(index);
    }

    public void understood(int index) {
        assert (index < this.size());
        if (index < 32) {
            this.understoodBits |= 1 << index;
        } else {
            if (this.moreUnderstoodBits == null) {
                this.moreUnderstoodBits = new BitSet();
            }
            this.moreUnderstoodBits.set(index - 32);
        }
    }

    public boolean isUnderstood(int index) {
        assert (index < this.size());
        if (index < 32) {
            return this.understoodBits == (this.understoodBits | 1 << index);
        }
        if (this.moreUnderstoodBits == null) {
            return false;
        }
        return this.moreUnderstoodBits.get(index - 32);
    }

    public void understood(@NotNull Header header) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            if (this.get(i) != header) continue;
            this.understood(i);
            return;
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    public Header get(@NotNull String nsUri, @NotNull String localName, boolean markAsUnderstood) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            Header h = this.get(i);
            if (!h.getLocalPart().equals(localName) || !h.getNamespaceURI().equals(nsUri)) continue;
            if (markAsUnderstood) {
                this.understood(i);
            }
            return h;
        }
        return null;
    }

    public Header get(String nsUri, String localName) {
        return this.get(nsUri, localName, true);
    }

    @Nullable
    public Header get(@NotNull QName name, boolean markAsUnderstood) {
        return this.get(name.getNamespaceURI(), name.getLocalPart(), markAsUnderstood);
    }

    @Nullable
    public Header get(@NotNull QName name) {
        return this.get(name, true);
    }

    public Iterator<Header> getHeaders(String nsUri, String localName) {
        return this.getHeaders(nsUri, localName, true);
    }

    @NotNull
    public Iterator<Header> getHeaders(final @NotNull String nsUri, final @NotNull String localName, final boolean markAsUnderstood) {
        return new Iterator<Header>(){
            int idx = 0;
            Header next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetch();
                }
                return this.next != null;
            }

            @Override
            public Header next() {
                if (this.next == null) {
                    this.fetch();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                if (markAsUnderstood) {
                    assert (HeaderList.this.get(this.idx - 1) == this.next);
                    HeaderList.this.understood(this.idx - 1);
                }
                Header r = this.next;
                this.next = null;
                return r;
            }

            private void fetch() {
                while (this.idx < HeaderList.this.size()) {
                    Header h;
                    if (!(h = HeaderList.this.get(this.idx++)).getLocalPart().equals(localName) || !h.getNamespaceURI().equals(nsUri)) continue;
                    this.next = h;
                    break;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    public Iterator<Header> getHeaders(@NotNull QName headerName, boolean markAsUnderstood) {
        return this.getHeaders(headerName.getNamespaceURI(), headerName.getLocalPart(), markAsUnderstood);
    }

    @NotNull
    public Iterator<Header> getHeaders(@NotNull String nsUri) {
        return this.getHeaders(nsUri, true);
    }

    @NotNull
    public Iterator<Header> getHeaders(final @NotNull String nsUri, final boolean markAsUnderstood) {
        return new Iterator<Header>(){
            int idx = 0;
            Header next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetch();
                }
                return this.next != null;
            }

            @Override
            public Header next() {
                if (this.next == null) {
                    this.fetch();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                if (markAsUnderstood) {
                    assert (HeaderList.this.get(this.idx - 1) == this.next);
                    HeaderList.this.understood(this.idx - 1);
                }
                Header r = this.next;
                this.next = null;
                return r;
            }

            private void fetch() {
                while (this.idx < HeaderList.this.size()) {
                    Header h;
                    if (!(h = HeaderList.this.get(this.idx++)).getNamespaceURI().equals(nsUri)) continue;
                    this.next = h;
                    break;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getTo(AddressingVersion version) {
        Header h = this.getFirstHeader(version.toTag, true);
        if (this.to != null && h != null) {
            this.to = h.getStringContent();
        }
        return this.to;
    }

    public String getAction(AddressingVersion version) {
        Header h = this.getFirstHeader(version.actionTag, true);
        if (this.action != null && h != null) {
            this.action = h.getStringContent();
        }
        return this.action;
    }

    public void setAction(AddressingVersion version) {
        Header h = this.getFirstHeader(version.actionTag, true);
        throw new UnsupportedOperationException();
    }

    public EndpointReference getReplyTo(AddressingVersion version) {
        Header h = this.getFirstHeader(version.replyToTag, true);
        if (this.replyTo == null || h != null) {
            // empty if block
        }
        return this.replyTo;
    }

    private Header getFirstHeader(QName name, boolean markUnderstood) {
        return this.getFirstHeader(name.getNamespaceURI(), name.getLocalPart(), markUnderstood);
    }

    private Header getFirstHeader(String nsUri, String localName, boolean markUnderstood) {
        Iterator<Header> iter = this.getHeaders(nsUri, localName, markUnderstood);
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public EndpointReference getFaultTo(AddressingVersion version) {
        Header h = this.getFirstHeader(version.faultToTag, true);
        if (this.faultTo == null || h != null) {
            // empty if block
        }
        return this.faultTo;
    }

    public String getMessageID(AddressingVersion version) {
        Header h = this.getFirstHeader(version.messageIDTag, true);
        if (this.messageId != null && h != null) {
            this.messageId = h.getStringContent();
        }
        return this.messageId;
    }

    public void fillRequestAddressingHeaders(WSDLPort wsdlPort, WSBinding binding, Packet packet) {
        AddressingVersion ver = binding.getAddressingVersion();
        WsaPipeHelper wsaHelper = this.getWsaHelper(wsdlPort, binding);
        StringHeader h = new StringHeader(ver.toTag, packet.endpointAddress.toString());
        this.add(h);
        String action = wsaHelper.getInputAction(packet);
        if (wsaHelper.isInputActionDefault(packet) && packet.soapAction != null && !packet.soapAction.equals("")) {
            action = packet.soapAction;
        }
        if (action == null) {
            action = "http://fake.input.action";
        }
        packet.soapAction = action;
        h = new StringHeader(ver.actionTag, action);
        this.add(h);
        h = new StringHeader(ver.messageIDTag, packet.getMessage().getID(binding));
        this.add(h);
        if (wsdlPort != null && !packet.getMessage().isOneWay(wsdlPort)) {
            WSEndpointReference epr = ver.anonymousEpr;
            this.add(epr.createHeader(ver.replyToTag));
        }
    }

    private WsaPipeHelper getWsaHelper(WSDLPort wsdlPort, WSBinding binding) {
        switch (binding.getAddressingVersion()) {
            case MEMBER: {
                return new com.sun.xml.ws.addressing.v200408.WsaPipeHelperImpl(wsdlPort, binding);
            }
            case W3C: {
                return new WsaPipeHelperImpl(wsdlPort, binding);
            }
        }
        throw new AssertionError((Object)binding.getAddressingVersion());
    }

    @Override
    public boolean add(Header header) {
        return super.add(header);
    }

    @Override
    public Header remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public static HeaderList copy(HeaderList original) {
        if (original == null) {
            return null;
        }
        return new HeaderList(original);
    }
}

