/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.addressing;

import com.sun.istack.NotNull;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferException;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.stream.buffer.XMLStreamBufferSource;
import com.sun.xml.stream.buffer.sax.SAXBufferProcessor;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferProcessor;
import com.sun.xml.ws.addressing.model.InvalidMapException;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.EPRHeader;
import com.sun.xml.ws.api.addressing.OutboundReferenceParameterHeader;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.resources.AddressingMessages;
import com.sun.xml.ws.spi.ProviderImpl;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.xml.XMLStreamWriterFilter;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class WSEndpointReference {
    private final XMLStreamBuffer infoset;
    private final AddressingVersion version;
    @NotNull
    private Header[] referenceParameters;
    private String address;
    private static final OutboundReferenceParameterHeader[] EMPTY_ARRAY = new OutboundReferenceParameterHeader[0];

    public WSEndpointReference(EndpointReference epr, AddressingVersion version) throws XMLStreamException {
        MutableXMLStreamBuffer xsb = new MutableXMLStreamBuffer();
        epr.writeTo((Result)new XMLStreamBufferResult(xsb));
        this.infoset = xsb;
        this.version = version;
        this.parse();
    }

    public WSEndpointReference(XMLStreamBuffer infoset, AddressingVersion version) throws XMLStreamException {
        this.infoset = infoset;
        this.version = version;
        this.parse();
    }

    public WSEndpointReference(InputStream infoset, AddressingVersion version) throws XMLStreamBufferException, XMLStreamException {
        this(XMLInputFactory.newInstance().createXMLStreamReader(infoset), version);
    }

    public WSEndpointReference(XMLStreamReader in, AddressingVersion version) throws XMLStreamBufferException, XMLStreamException {
        this(XMLStreamBuffer.createNewBufferFromXMLStreamReader((XMLStreamReader)in), version);
    }

    @NotNull
    public EndpointReference toSpec() {
        return ProviderImpl.INSTANCE.readEndpointReference((Source)new XMLStreamBufferSource(this.infoset));
    }

    @NotNull
    public AddressingVersion getVersion() {
        return this.version;
    }

    @NotNull
    public String getAddress() {
        return this.address;
    }

    private void parse() throws XMLStreamException {
        StreamReaderBufferProcessor xsr = this.infoset.readAsXMLStreamReader();
        if (xsr.getEventType() == 7) {
            xsr.nextTag();
        }
        assert (xsr.getEventType() == 1);
        String rootLocalName = xsr.getLocalName();
        if (!xsr.getNamespaceURI().equals(this.version.nsUri)) {
            throw new WebServiceException(AddressingMessages.WRONG_ADDRESSING_VERSION(this.version.nsUri, xsr.getNamespaceURI()));
        }
        ArrayList<OutboundReferenceParameterHeader> marks = null;
        while (xsr.nextTag() == 1) {
            String localName = xsr.getLocalName();
            if (this.version.isReferenceParameter(localName)) {
                XMLStreamBuffer mark;
                while ((mark = xsr.nextTagAndMark()) != null) {
                    if (marks == null) {
                        marks = new ArrayList<OutboundReferenceParameterHeader>();
                    }
                    marks.add(new OutboundReferenceParameterHeader(mark, xsr.getNamespaceURI(), xsr.getLocalName()));
                    XMLStreamReaderUtil.skipElement((XMLStreamReader)xsr);
                }
                continue;
            }
            if (localName.equals("Address")) {
                if (this.address != null) {
                    throw new InvalidMapException(new QName(this.version.nsUri, rootLocalName), AddressingVersion.fault_duplicateAddressInEpr);
                }
                this.address = xsr.getElementText();
                continue;
            }
            XMLStreamReaderUtil.skipElement((XMLStreamReader)xsr);
        }
        this.referenceParameters = marks == null ? EMPTY_ARRAY : (Header[])marks.toArray(new OutboundReferenceParameterHeader[marks.size()]);
        if (this.address == null) {
            throw new InvalidMapException(new QName(this.version.nsUri, rootLocalName), this.version.fault_missingAddressInEpr);
        }
    }

    public XMLStreamReader read(final @NotNull String localName) throws XMLStreamException {
        return new StreamReaderBufferProcessor(this.infoset){

            protected void processElement(String prefix, String uri, String _localName) {
                if (this._depth == 0) {
                    _localName = localName;
                }
                super.processElement(prefix, uri, _localName);
            }
        };
    }

    public Source asSource(@NotNull String localName) {
        return new SAXSource((XMLReader)((Object)new SAXBufferProcessorImpl(localName)), new InputSource());
    }

    public void writeTo(@NotNull String localName, ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        SAXBufferProcessorImpl p = new SAXBufferProcessorImpl(localName);
        p.setContentHandler(contentHandler);
        p.setErrorHandler(errorHandler);
        p.process(this.infoset);
    }

    public void writeTo(final @NotNull String localName, @NotNull XMLStreamWriter w) throws XMLStreamBufferException, XMLStreamException {
        this.infoset.writeToXMLStreamWriter((XMLStreamWriter)new XMLStreamWriterFilter(w){
            private boolean root;
            {
                super(x0);
                this.root = true;
            }

            private String override(String ln) {
                if (this.root) {
                    this.root = false;
                    return localName;
                }
                return ln;
            }

            public void writeStartElement(String localName2) throws XMLStreamException {
                super.writeStartElement(this.override(localName2));
            }

            public void writeStartElement(String namespaceURI, String localName2) throws XMLStreamException {
                super.writeStartElement(namespaceURI, this.override(localName2));
            }

            public void writeStartElement(String prefix, String localName2, String namespaceURI) throws XMLStreamException {
                super.writeStartElement(prefix, this.override(localName2), namespaceURI);
            }
        });
    }

    public Header createHeader(QName rootTagName) {
        return new EPRHeader(rootTagName, this);
    }

    public void addReferenceParameters(HeaderList outbound) {
        for (Header header : this.referenceParameters) {
            outbound.add(header);
        }
    }

    public String toString() {
        try {
            StringWriter sw = new StringWriter();
            XmlUtil.newTransformer().transform(this.asSource("EndpointReference"), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException e) {
            return e.toString();
        }
    }

    class SAXBufferProcessorImpl
    extends SAXBufferProcessor {
        private final String rootLocalName;
        private boolean root;

        public SAXBufferProcessorImpl(String rootLocalName) {
            super(WSEndpointReference.this.infoset);
            this.root = true;
            this.rootLocalName = rootLocalName;
        }

        protected void processElement(String uri, String localName, String qName) throws SAXException {
            if (this.root) {
                this.root = false;
                if (qName.equals(localName)) {
                    qName = localName = this.rootLocalName;
                } else {
                    localName = this.rootLocalName;
                    int idx = qName.indexOf(58);
                    qName = qName.substring(0, idx + 1) + this.rootLocalName;
                }
            }
            super.processElement(uri, localName, qName);
        }
    }
}

