/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing;

import com.sun.xml.ws.addressing.WsaPipe;
import com.sun.xml.ws.addressing.model.AddressingProperties;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.transport.http.client.HttpTransportPipe;
import java.net.URI;

public class WsaServerPipe
extends WsaPipe {
    public WsaServerPipe(WSDLPort wsdlPort, WSBinding binding, Pipe next) {
        super(wsdlPort, binding, next);
    }

    public Pipe copy(PipeCloner cloner) {
        WsaServerPipe that = new WsaServerPipe(this.wsdlPort, this.binding, this.next);
        cloner.add(this, that);
        return that;
    }

    public Packet process(Packet packet) {
        if (this.wsdlPort == null) {
            return this.next.process(packet);
        }
        Packet p = this.helper.readServerInboundHeaders(packet);
        AddressingProperties inbound = (AddressingProperties)p.invocationProperties.get("server.inbound");
        if (p.getMessage() != null && p.getMessage().isFault()) {
            return this.processFault(p, inbound, false);
        }
        if (inbound != null && inbound.getReplyTo() != null) {
            if (this.helper.getAddress(inbound.getReplyTo()).equals(this.helper.getNoneURI()) && (inbound.getFaultTo() == null || !this.helper.getAddress(inbound.getFaultTo()).equals(this.helper.getAnonymousURI()))) {
                if (p.transportBackChannel != null) {
                    p.transportBackChannel.close();
                }
                return this.next.process(p);
            }
            if (!(this.helper.getAddress(inbound.getReplyTo()).equals(this.helper.getAnonymousURI()) || inbound.getFaultTo() != null && this.helper.getAddress(inbound.getFaultTo()).equals(this.helper.getAnonymousURI()))) {
                return this.processNonAnonymousReply(p, this.helper.getAddress(inbound.getReplyTo()), true);
            }
        }
        p = this.next.process(p);
        if ((p = this.helper.writeServerOutboundHeaders(p)).getMessage() != null && p.getMessage().isFault()) {
            return this.processFault(p, (AddressingProperties)p.invocationProperties.get("server.inbound"), false);
        }
        return p;
    }

    private Packet processFault(Packet p, AddressingProperties ap, boolean invokeEndpoint) {
        if (ap == null) {
            return p;
        }
        if (ap.getFaultTo() == null) {
            if (ap.getReplyTo() != null) {
                if (this.helper.getAddress(ap.getReplyTo()).equals(this.helper.getNoneURI())) {
                    if (invokeEndpoint) {
                        return p.createResponse(null);
                    }
                    p.transportBackChannel.close();
                } else if (!this.helper.getAddress(ap.getReplyTo()).equals(this.helper.getAnonymousURI())) {
                    return this.processNonAnonymousReply(p, this.helper.getAddress(ap.getReplyTo()), invokeEndpoint);
                }
            }
        } else if (this.helper.getAddress(ap.getFaultTo()).equals(this.helper.getNoneURI())) {
            if (invokeEndpoint) {
                return p.createResponse(null);
            }
            p.transportBackChannel.close();
        } else if (!this.helper.getAddress(ap.getFaultTo()).equals(this.helper.getAnonymousURI())) {
            return this.processNonAnonymousReply(p, this.helper.getAddress(ap.getFaultTo()), invokeEndpoint);
        }
        return p;
    }

    private Packet processNonAnonymousReply(Packet packet, String uri, boolean invokeEndpoint) {
        if (packet.transportBackChannel != null) {
            packet.transportBackChannel.close();
        }
        Packet response = packet;
        if (invokeEndpoint) {
            response = this.next.process(packet);
            response = this.helper.writeServerOutboundHeaders(response);
        }
        AddressingProperties ap = (AddressingProperties)packet.invocationProperties.get("server.inbound");
        if (response != null && response.getMessage() != null && response.getMessage().isFault() && ap.getFaultTo() != null && this.helper.getAddress(ap.getFaultTo()).equals(this.helper.getNoneURI()) || ap.getReplyTo() != null && this.helper.getAddress(ap.getReplyTo()).equals(this.helper.getNoneURI())) {
            return packet;
        }
        if (!uri.startsWith("http")) {
            System.out.printf("Unknown protocol: \"%s\"\n", uri.substring(0, uri.indexOf("://")));
            return packet;
        }
        System.out.printf("Sending non-anonymous reply to %s\n", uri);
        HttpTransportPipe tPipe = new HttpTransportPipe(this.binding);
        response.endpointAddress = new EndpointAddress(URI.create(uri));
        response = tPipe.process(response);
        if (response == null) {
            System.out.printf("%s: null response\n", uri);
        }
        return response;
    }
}

