/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.ws.api.addressing.MemberSubmissionEndpointReference;
import com.sun.xml.ws.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.util.DOMUtil;
import com.sun.xml.ws.util.xml.XmlUtil;
import com.sun.xml.ws.wsdl.parser.WSDLConstants;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointReferenceUtil {
    private static boolean w3cMetadataWritten = false;

    public static <T extends EndpointReference> T getEndpointReference(Class<T> clazz, String address) {
        return EndpointReferenceUtil.getEndpointReference(clazz, address, null, null, null, true);
    }

    public static <T extends EndpointReference> T getEndpointReference(Class<T> clazz, String address, QName service, String port, QName portType, boolean hasWSDL) {
        if (clazz.isAssignableFrom(W3CEndpointReference.class)) {
            ByteOutputStream bos = new ByteOutputStream();
            XMLStreamWriter writer = XMLStreamWriterFactory.createXMLStreamWriter((OutputStream)bos);
            try {
                writer.writeStartDocument();
                writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
                writer.writeNamespace("wsa", "http://www.w3.org/2005/08/addressing");
                writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
                writer.writeCharacters(address);
                writer.writeEndElement();
                EndpointReferenceUtil.writeW3CMetaData(writer, address, service, port, portType, hasWSDL);
                writer.writeEndElement();
                writer.writeEndDocument();
                writer.flush();
            }
            catch (XMLStreamException e) {
                throw new WebServiceException((Throwable)e);
            }
            return (T)new W3CEndpointReference((Source)new StreamSource((InputStream)bos.newInputStream()));
        }
        if (clazz.isAssignableFrom(MemberSubmissionEndpointReference.class)) {
            ByteOutputStream bos = new ByteOutputStream();
            XMLStreamWriter writer = XMLStreamWriterFactory.createXMLStreamWriter((OutputStream)bos);
            try {
                writer.writeStartDocument();
                writer.writeStartElement("wsa", "EndpointReference", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
                writer.writeNamespace("wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
                writer.writeStartElement("wsa", "Address", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
                writer.writeCharacters(address);
                writer.writeEndElement();
                EndpointReferenceUtil.writeMSMetaData(writer, address, service, port, portType, hasWSDL);
                if (hasWSDL) {
                    EndpointReferenceUtil.writeWsdl(writer, service, address);
                }
                writer.writeEndElement();
                writer.writeEndDocument();
                writer.flush();
            }
            catch (XMLStreamException e) {
                throw new WebServiceException((Throwable)e);
            }
            return (T)new MemberSubmissionEndpointReference(new StreamSource((InputStream)bos.newInputStream()));
        }
        throw new WebServiceException(clazz + "is not a recognizable EndpointReference");
    }

    private static void writeW3CMetaData(XMLStreamWriter writer, String eprAddress, QName service, String port, QName portType, boolean hasWSDL) throws XMLStreamException {
        writer.writeStartElement("wsa", "Metadata", "http://www.w3.org/2005/08/addressing");
        writer.writeNamespace("wsaw", "http://www.w3.org/2006/05/addressing/wsdl");
        if (portType != null) {
            writer.writeStartElement("wsaw", "InterfaceName", "http://www.w3.org/2006/05/addressing/wsdl");
            String portTypePrefix = portType.getPrefix();
            if (portTypePrefix == null || portTypePrefix.equals("")) {
                portTypePrefix = "wsns";
            }
            writer.writeNamespace(portTypePrefix, portType.getNamespaceURI());
            writer.writeCharacters(portTypePrefix + ":" + portType.getLocalPart());
            writer.writeEndElement();
        }
        if (!service.getNamespaceURI().equals("") && !service.getLocalPart().equals("")) {
            writer.writeStartElement("wsaw", "ServiceName", "http://www.w3.org/2006/05/addressing/wsdl");
            String servicePrefix = service.getPrefix();
            if (servicePrefix == null || servicePrefix.equals("")) {
                servicePrefix = "wsns";
            }
            writer.writeAttribute("EndpointName", port);
            writer.writeNamespace(servicePrefix, service.getNamespaceURI());
            writer.writeCharacters(servicePrefix + ":" + service.getLocalPart());
            writer.writeEndElement();
        }
        if (hasWSDL) {
            EndpointReferenceUtil.writeWsdl(writer, service, eprAddress);
        }
        writer.writeEndElement();
    }

    private static void writeMSMetaData(XMLStreamWriter writer, String eprAddress, QName service, String port, QName portType, boolean hasWSDL) throws XMLStreamException {
        if (portType != null) {
            writer.writeStartElement("wsa", "PortType", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            String portTypePrefix = portType.getPrefix();
            if (portTypePrefix == null || portTypePrefix.equals("")) {
                portTypePrefix = "wsns";
            }
            writer.writeNamespace(portTypePrefix, portType.getNamespaceURI());
            writer.writeCharacters(portTypePrefix + ":" + portType.getLocalPart());
            writer.writeEndElement();
        }
        assert (service != null);
        if (!service.getNamespaceURI().equals("") && !service.getLocalPart().equals("")) {
            writer.writeStartElement("wsa", "ServiceName", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            String servicePrefix = service.getPrefix();
            if (servicePrefix == null || servicePrefix.equals("")) {
                servicePrefix = "wsns";
            }
            writer.writeAttribute("PortName", port);
            writer.writeNamespace(servicePrefix, service.getNamespaceURI());
            writer.writeCharacters(servicePrefix + ":" + service.getLocalPart());
            writer.writeEndElement();
        }
    }

    private static void writeWsdl(XMLStreamWriter writer, QName service, String eprAddress) throws XMLStreamException {
        writer.writeStartElement("wsdl", WSDLConstants.QNAME_DEFINITIONS.getLocalPart(), "http://schemas.xmlsoap.org/wsdl/");
        writer.writeNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        writer.writeStartElement("wsdl", WSDLConstants.QNAME_IMPORT.getLocalPart(), "http://schemas.xmlsoap.org/wsdl/");
        writer.writeAttribute("namespace", service.getNamespaceURI());
        writer.writeAttribute("location", eprAddress + "?wsdl");
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public static <T extends EndpointReference> T transform(Class<T> clazz, @NotNull EndpointReference epr) {
        assert (epr != null);
        if (clazz.isAssignableFrom(W3CEndpointReference.class)) {
            if (epr instanceof W3CEndpointReference) {
                return (T)epr;
            }
            if (epr instanceof MemberSubmissionEndpointReference) {
                return (T)EndpointReferenceUtil.toW3CEpr((MemberSubmissionEndpointReference)epr);
            }
        } else if (clazz.isAssignableFrom(MemberSubmissionEndpointReference.class)) {
            if (epr instanceof W3CEndpointReference) {
                return (T)EndpointReferenceUtil.toMSEpr((W3CEndpointReference)epr);
            }
            if (epr instanceof MemberSubmissionEndpointReference) {
                return (T)epr;
            }
        }
        throw new WebServiceException("Unknwon EndpointReference: " + epr.getClass());
    }

    private static W3CEndpointReference toW3CEpr(MemberSubmissionEndpointReference msEpr) {
        ByteOutputStream bos = new ByteOutputStream();
        XMLStreamWriter writer = XMLStreamWriterFactory.createXMLStreamWriter((OutputStream)bos);
        w3cMetadataWritten = false;
        try {
            writer.writeStartDocument();
            writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
            writer.writeNamespace("wsa", "http://www.w3.org/2005/08/addressing");
            writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
            writer.writeCharacters(msEpr.addr.uri);
            writer.writeEndElement();
            if (msEpr.referenceProperties != null && msEpr.referenceProperties.elements.size() > 0 || msEpr.referenceParameters != null && msEpr.referenceParameters.elements.size() > 0) {
                writer.writeStartElement("wsa", "ReferenceParameters", "http://www.w3.org/2005/08/addressing");
                if (msEpr.referenceProperties != null) {
                    for (Element e : msEpr.referenceProperties.elements) {
                        DOMUtil.serializeNode(e, writer);
                    }
                }
                if (msEpr.referenceParameters != null) {
                    for (Element e : msEpr.referenceParameters.elements) {
                        DOMUtil.serializeNode(e, writer);
                    }
                }
                writer.writeEndElement();
            }
            if (msEpr.portTypeName != null) {
                EndpointReferenceUtil.writeW3CMetadata(writer);
                writer.writeStartElement("wsaw", "InterfaceName", "http://www.w3.org/2006/05/addressing/wsdl");
                writer.writeNamespace("wsaw", "http://www.w3.org/2006/05/addressing/wsdl");
                String portTypePrefix = EndpointReferenceUtil.fixNull(msEpr.portTypeName.name.getPrefix());
                writer.writeNamespace(portTypePrefix, msEpr.portTypeName.name.getNamespaceURI());
                if (portTypePrefix.equals("")) {
                    writer.writeCharacters(msEpr.portTypeName.name.getLocalPart());
                } else {
                    writer.writeCharacters(portTypePrefix + ":" + msEpr.portTypeName.name.getLocalPart());
                }
                writer.writeEndElement();
            }
            if (msEpr.serviceName != null) {
                EndpointReferenceUtil.writeW3CMetadata(writer);
                writer.writeStartElement("wsaw", "ServiceName", "http://www.w3.org/2006/05/addressing/wsdl");
                writer.writeNamespace("wsaw", "http://www.w3.org/2006/05/addressing/wsdl");
                String servicePrefix = EndpointReferenceUtil.fixNull(msEpr.serviceName.name.getPrefix());
                if (msEpr.serviceName.portName != null) {
                    writer.writeAttribute("EndpointName", msEpr.serviceName.portName);
                }
                writer.writeNamespace(servicePrefix, msEpr.serviceName.name.getNamespaceURI());
                if (servicePrefix.length() > 0) {
                    writer.writeCharacters(servicePrefix + ":" + msEpr.serviceName.name.getLocalPart());
                } else {
                    writer.writeCharacters(msEpr.serviceName.name.getLocalPart());
                }
                writer.writeEndElement();
            }
            Element wsdlElement = null;
            if (msEpr.elements != null && msEpr.elements.size() > 0) {
                for (Element e : msEpr.elements) {
                    if (!e.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || !e.getLocalName().equals(WSDLConstants.QNAME_DEFINITIONS.getLocalPart())) continue;
                    wsdlElement = e;
                }
            }
            if (wsdlElement != null) {
                DOMUtil.serializeNode(wsdlElement, writer);
            }
            if (w3cMetadataWritten) {
                writer.writeEndElement();
            }
            if (msEpr.elements != null && msEpr.elements.size() > 0) {
                for (Element e : msEpr.elements) {
                    if (!e.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || e.getLocalName().equals(WSDLConstants.QNAME_DEFINITIONS.getLocalPart())) {
                        // empty if block
                    }
                    DOMUtil.serializeNode(e, writer);
                }
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new WebServiceException((Throwable)e);
        }
        return new W3CEndpointReference((Source)new StreamSource((InputStream)bos.newInputStream()));
    }

    private static void writeW3CMetadata(XMLStreamWriter writer) throws XMLStreamException {
        if (!w3cMetadataWritten) {
            writer.writeStartElement("wsa", "Metadata", "http://www.w3.org/2005/08/addressing");
            w3cMetadataWritten = true;
        }
    }

    private static MemberSubmissionEndpointReference toMSEpr(W3CEndpointReference w3cEpr) {
        DOMResult result = new DOMResult();
        w3cEpr.writeTo((Result)result);
        Node eprNode = result.getNode();
        Element e = DOMUtil.getFirstElementChild(eprNode);
        if (e == null) {
            return null;
        }
        MemberSubmissionEndpointReference msEpr = new MemberSubmissionEndpointReference();
        NodeList nodes = e.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() == 1) {
                Element child = (Element)nodes.item(i);
                if (child.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing") && child.getLocalName().equals("Address")) {
                    if (msEpr.addr == null) {
                        msEpr.addr = new MemberSubmissionEndpointReference.Address();
                    }
                    msEpr.addr.uri = XmlUtil.getTextForNode(child);
                    msEpr.addr.attributes = EndpointReferenceUtil.getAttributes(child);
                    continue;
                }
                if (child.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing") && child.getLocalName().equals("ReferenceParameters")) {
                    NodeList refParams = child.getChildNodes();
                    for (int j = 0; j < refParams.getLength(); ++j) {
                        if (refParams.item(j).getNodeType() != 1) continue;
                        if (msEpr.referenceParameters == null) {
                            msEpr.referenceParameters = new MemberSubmissionEndpointReference.Elements();
                            msEpr.referenceParameters.elements = new ArrayList<Element>();
                        }
                        msEpr.referenceParameters.elements.add((Element)refParams.item(i));
                    }
                    continue;
                }
                if (child.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing") && child.getLocalName().equals("Metadata")) {
                    NodeList metadata = child.getChildNodes();
                    for (int j = 0; j < metadata.getLength(); ++j) {
                        String ns;
                        String name;
                        String prefix;
                        Node node = metadata.item(j);
                        if (node.getNodeType() != 1) continue;
                        Element elm = (Element)node;
                        if (elm.getNamespaceURI().equals("http://www.w3.org/2006/05/addressing/wsdl") && elm.getLocalName().equals("ServiceName")) {
                            msEpr.serviceName = new MemberSubmissionEndpointReference.ServiceNameType();
                            msEpr.serviceName.portName = elm.getAttribute("EndpointName");
                            String service = elm.getTextContent();
                            prefix = XmlUtil.getPrefix(service);
                            name = XmlUtil.getLocalPart(service);
                            if (name == null) continue;
                            if (prefix != null) {
                                ns = elm.lookupNamespaceURI(prefix);
                                if (ns != null) {
                                    msEpr.serviceName.name = new QName(ns, name, prefix);
                                }
                            } else {
                                msEpr.serviceName.name = new QName(null, name);
                            }
                            msEpr.serviceName.attributes = EndpointReferenceUtil.getAttributes(elm);
                            continue;
                        }
                        if (elm.getNamespaceURI().equals("http://www.w3.org/2006/05/addressing/wsdl") && elm.getLocalName().equals("InterfaceName")) {
                            msEpr.portTypeName = new MemberSubmissionEndpointReference.AttributedQName();
                            String portType = elm.getTextContent();
                            prefix = XmlUtil.getPrefix(portType);
                            name = XmlUtil.getLocalPart(portType);
                            if (name == null) continue;
                            if (prefix != null) {
                                ns = elm.lookupNamespaceURI(prefix);
                                if (ns != null) {
                                    msEpr.portTypeName.name = new QName(ns, name, prefix);
                                }
                            } else {
                                msEpr.portTypeName.name = new QName(null, name);
                            }
                            msEpr.portTypeName.attributes = EndpointReferenceUtil.getAttributes(elm);
                            continue;
                        }
                        if (msEpr.elements == null) {
                            msEpr.elements = new ArrayList<Element>();
                        }
                        msEpr.elements.add(elm);
                    }
                    continue;
                }
                if (msEpr.elements == null) {
                    msEpr.elements = new ArrayList<Element>();
                }
                msEpr.elements.add(child);
                continue;
            }
            if (nodes.item(i).getNodeType() != 2) continue;
            Node n = nodes.item(i);
            if (msEpr.attributes != null) continue;
            msEpr.attributes = new HashMap<QName, String>();
            String prefix = EndpointReferenceUtil.fixNull(n.getPrefix());
            String ns = EndpointReferenceUtil.fixNull(n.getNamespaceURI());
            String localName = n.getLocalName();
            msEpr.attributes.put(new QName(ns, localName, prefix), n.getNodeValue());
        }
        return msEpr;
    }

    private static Map<QName, String> getAttributes(Node node) {
        HashMap<QName, String> attribs = null;
        NamedNodeMap nm = node.getAttributes();
        for (int i = 0; i < nm.getLength(); ++i) {
            if (attribs == null) {
                attribs = new HashMap<QName, String>();
            }
            Node n = nm.item(i);
            String prefix = EndpointReferenceUtil.fixNull(n.getPrefix());
            String ns = EndpointReferenceUtil.fixNull(n.getNamespaceURI());
            String localName = n.getLocalName();
            if (prefix.equals("xmlns") || prefix.length() == 0 && localName.equals("xmlns") || localName.equals("EndpointName")) continue;
            attribs.put(new QName(ns, localName, prefix), n.getNodeValue());
        }
        return attribs;
    }

    @NotNull
    private static String fixNull(@Nullable String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

