/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.sei;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.encoding.soap.DeserializationException;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.model.ParameterImpl;
import com.sun.xml.ws.model.WrapperParameter;
import com.sun.xml.ws.server.sei.EndpointArgumentsBuilder;
import com.sun.xml.ws.server.sei.EndpointResponseMessageBuilder;
import com.sun.xml.ws.server.sei.EndpointValueSetter;
import com.sun.xml.ws.server.sei.MessageFiller;
import com.sun.xml.ws.server.sei.SEIInvokerTube;
import com.sun.xml.ws.server.sei.ValueGetter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebParam;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EndpointMethodHandler {
    private final SOAPVersion soapVersion;
    private final Method method;
    private final int noOfArgs;
    private final JavaMethodImpl javaMethodModel;
    private final Boolean isOneWay;
    private final EndpointArgumentsBuilder argumentsBuilder;
    private final EndpointResponseMessageBuilder bodyBuilder;
    private final MessageFiller[] outFillers;
    private final SEIInvokerTube owner;
    private static final Logger LOGGER = Logger.getLogger(EndpointMethodHandler.class.getName());

    public EndpointMethodHandler(SEIInvokerTube owner, JavaMethodImpl method, WSBinding binding) {
        this.owner = owner;
        this.soapVersion = binding.getSOAPVersion();
        this.method = method.getMethod();
        this.javaMethodModel = method;
        this.argumentsBuilder = this.createArgumentsBuilder();
        ArrayList<MessageFiller> fillers = new ArrayList<MessageFiller>();
        this.bodyBuilder = this.createResponseMessageBuilder(fillers);
        this.outFillers = fillers.toArray(new MessageFiller[fillers.size()]);
        this.isOneWay = method.getMEP().isOneWay();
        this.noOfArgs = this.method.getParameterTypes().length;
    }

    private EndpointArgumentsBuilder createArgumentsBuilder() {
        EndpointArgumentsBuilder argsBuilder;
        List<ParameterImpl> rp = this.javaMethodModel.getRequestParameters();
        ArrayList<EndpointArgumentsBuilder> builders = new ArrayList<EndpointArgumentsBuilder>();
        block10: for (ParameterImpl param : rp) {
            EndpointValueSetter setter = EndpointValueSetter.get(param);
            switch (param.getInBinding().kind) {
                case BODY: {
                    if (param.isWrapperStyle()) {
                        if (param.getParent().getBinding().isRpcLit()) {
                            builders.add(new EndpointArgumentsBuilder.RpcLit((WrapperParameter)param));
                            continue block10;
                        }
                        builders.add(new EndpointArgumentsBuilder.DocLit((WrapperParameter)param, WebParam.Mode.OUT));
                        continue block10;
                    }
                    builders.add(new EndpointArgumentsBuilder.Body(param.getBridge(), setter));
                    continue block10;
                }
                case HEADER: {
                    builders.add(new EndpointArgumentsBuilder.Header(this.soapVersion, param, setter));
                    continue block10;
                }
                case ATTACHMENT: {
                    builders.add(EndpointArgumentsBuilder.AttachmentBuilder.createAttachmentBuilder(param, setter));
                    continue block10;
                }
                case UNBOUND: {
                    builders.add(new EndpointArgumentsBuilder.NullSetter(setter, EndpointArgumentsBuilder.getVMUninitializedValue(param.getTypeReference().type)));
                    continue block10;
                }
            }
            throw new AssertionError();
        }
        List<ParameterImpl> resp = this.javaMethodModel.getResponseParameters();
        for (ParameterImpl param : resp) {
            if (param.isWrapperStyle()) {
                WrapperParameter wp = (WrapperParameter)param;
                List<ParameterImpl> children = wp.getWrapperChildren();
                for (ParameterImpl p : children) {
                    if (!p.isOUT() || p.getIndex() == -1) continue;
                    EndpointValueSetter setter = EndpointValueSetter.get(p);
                    builders.add(new EndpointArgumentsBuilder.NullSetter(setter, null));
                }
                continue;
            }
            if (!param.isOUT() || param.getIndex() == -1) continue;
            EndpointValueSetter setter = EndpointValueSetter.get(param);
            builders.add(new EndpointArgumentsBuilder.NullSetter(setter, null));
        }
        switch (builders.size()) {
            case 0: {
                argsBuilder = EndpointArgumentsBuilder.NONE;
                break;
            }
            case 1: {
                argsBuilder = (EndpointArgumentsBuilder)builders.get(0);
                break;
            }
            default: {
                argsBuilder = new EndpointArgumentsBuilder.Composite(builders);
            }
        }
        return argsBuilder;
    }

    private EndpointResponseMessageBuilder createResponseMessageBuilder(List<MessageFiller> fillers) {
        EndpointResponseMessageBuilder bodyBuilder = null;
        List<ParameterImpl> rp = this.javaMethodModel.getResponseParameters();
        block10: for (ParameterImpl param : rp) {
            ValueGetter getter = ValueGetter.get(param);
            switch (param.getOutBinding().kind) {
                case BODY: {
                    if (param.isWrapperStyle()) {
                        if (param.getParent().getBinding().isRpcLit()) {
                            bodyBuilder = new EndpointResponseMessageBuilder.RpcLit((WrapperParameter)param, this.soapVersion);
                            continue block10;
                        }
                        bodyBuilder = new EndpointResponseMessageBuilder.DocLit((WrapperParameter)param, this.soapVersion);
                        continue block10;
                    }
                    bodyBuilder = new EndpointResponseMessageBuilder.Bare(param, this.soapVersion);
                    continue block10;
                }
                case HEADER: {
                    fillers.add(new MessageFiller.Header(param.getIndex(), param.getBridge(), getter));
                    continue block10;
                }
                case ATTACHMENT: {
                    fillers.add(MessageFiller.AttachmentFiller.createAttachmentFiller(param, getter));
                    continue block10;
                }
                case UNBOUND: {
                    continue block10;
                }
            }
            throw new AssertionError();
        }
        if (bodyBuilder == null) {
            switch (this.soapVersion) {
                case SOAP_11: {
                    bodyBuilder = EndpointResponseMessageBuilder.EMPTY_SOAP11;
                    break;
                }
                case SOAP_12: {
                    bodyBuilder = EndpointResponseMessageBuilder.EMPTY_SOAP12;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return bodyBuilder;
    }

    public Packet invoke(Packet req) {
        Message responseMessage;
        Message reqMsg = req.getMessage();
        Object[] args = new Object[this.noOfArgs];
        try {
            this.argumentsBuilder.readRequest(reqMsg, args);
        }
        catch (JAXBException e) {
            throw new DeserializationException("failed.to.read.response", new Object[]{e});
        }
        catch (XMLStreamException e) {
            throw new DeserializationException("failed.to.read.response", e);
        }
        if (this.isOneWay.booleanValue() && req.transportBackChannel != null) {
            req.transportBackChannel.close();
        }
        try {
            Object ret = this.owner.getInvoker(req).invoke(req, this.method, args);
            responseMessage = this.isOneWay != false ? null : this.createResponseMessage(args, ret);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof RuntimeException) && cause instanceof Exception) {
                LOGGER.log(Level.INFO, cause.getMessage(), cause);
                responseMessage = SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, this.javaMethodModel.getCheckedException(cause.getClass()), cause);
            } else {
                LOGGER.log(Level.SEVERE, cause.getMessage(), cause);
                responseMessage = SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, null, cause);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            responseMessage = SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, null, e);
        }
        return req.createServerResponse(responseMessage, req.endpoint.getPort(), this.javaMethodModel.getOwner(), req.endpoint.getBinding());
    }

    private Message createResponseMessage(Object[] args, Object returnValue) {
        Message msg = this.bodyBuilder.createMessage(args, returnValue);
        for (MessageFiller filler : this.outFillers) {
            filler.fillIn(args, returnValue, msg);
        }
        return msg;
    }
}

