/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.local;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.TransportTubeFactory;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.local.InVmServer;
import com.sun.xml.ws.transport.local.LocalAsyncTransportTube;
import com.sun.xml.ws.transport.local.LocalTransportTube;
import java.net.URI;
import javax.xml.ws.WebServiceException;

public final class InVmTransportFactory
extends TransportTubeFactory {
    public Tube doCreate(@NotNull ClientTubeAssemblerContext context) {
        URI adrs = context.getAddress().getURI();
        if (!adrs.getScheme().equals("in-vm") && !adrs.getScheme().equals("in-vm-async")) {
            return null;
        }
        String serverId = adrs.getAuthority();
        InVmServer server = InVmServer.get(serverId);
        if (server == null) {
            throw new WebServiceException("No such server is running: " + adrs);
        }
        WSEndpoint endpoint = server.getEndpoints().size() == 1 ? server.getEndpoints().get(0) : server.getByPortName(adrs.getQuery());
        if (endpoint == null) {
            throw new WebServiceException("No such port exists: " + adrs);
        }
        if (adrs.getScheme().equals("in-vm")) {
            return new LocalTransportTube(adrs, endpoint, context.getCodec());
        }
        return new LocalAsyncTransportTube(adrs, endpoint, context.getCodec());
    }
}

