/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier.statics;

import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.AccessFlags;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.FieldOrMethod;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.generic.ALOAD;
import com.sun.org.apache.bcel.internal.generic.ANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.ASTORE;
import com.sun.org.apache.bcel.internal.generic.ATHROW;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.BREAKPOINT;
import com.sun.org.apache.bcel.internal.generic.CHECKCAST;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.DLOAD;
import com.sun.org.apache.bcel.internal.generic.DSTORE;
import com.sun.org.apache.bcel.internal.generic.EmptyVisitor;
import com.sun.org.apache.bcel.internal.generic.FLOAD;
import com.sun.org.apache.bcel.internal.generic.FSTORE;
import com.sun.org.apache.bcel.internal.generic.FieldInstruction;
import com.sun.org.apache.bcel.internal.generic.GETSTATIC;
import com.sun.org.apache.bcel.internal.generic.GotoInstruction;
import com.sun.org.apache.bcel.internal.generic.IINC;
import com.sun.org.apache.bcel.internal.generic.ILOAD;
import com.sun.org.apache.bcel.internal.generic.IMPDEP1;
import com.sun.org.apache.bcel.internal.generic.IMPDEP2;
import com.sun.org.apache.bcel.internal.generic.INSTANCEOF;
import com.sun.org.apache.bcel.internal.generic.INVOKEINTERFACE;
import com.sun.org.apache.bcel.internal.generic.INVOKESPECIAL;
import com.sun.org.apache.bcel.internal.generic.INVOKESTATIC;
import com.sun.org.apache.bcel.internal.generic.INVOKEVIRTUAL;
import com.sun.org.apache.bcel.internal.generic.ISTORE;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.InvokeInstruction;
import com.sun.org.apache.bcel.internal.generic.JsrInstruction;
import com.sun.org.apache.bcel.internal.generic.LDC;
import com.sun.org.apache.bcel.internal.generic.LDC2_W;
import com.sun.org.apache.bcel.internal.generic.LLOAD;
import com.sun.org.apache.bcel.internal.generic.LOOKUPSWITCH;
import com.sun.org.apache.bcel.internal.generic.LSTORE;
import com.sun.org.apache.bcel.internal.generic.LoadClass;
import com.sun.org.apache.bcel.internal.generic.MULTIANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.NEW;
import com.sun.org.apache.bcel.internal.generic.NEWARRAY;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.PUTSTATIC;
import com.sun.org.apache.bcel.internal.generic.RET;
import com.sun.org.apache.bcel.internal.generic.ReturnInstruction;
import com.sun.org.apache.bcel.internal.generic.TABLESWITCH;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.verifier.PassVerifier;
import com.sun.org.apache.bcel.internal.verifier.VerificationResult;
import com.sun.org.apache.bcel.internal.verifier.Verifier;
import com.sun.org.apache.bcel.internal.verifier.VerifierFactory;
import com.sun.org.apache.bcel.internal.verifier.exc.AssertionViolatedException;
import com.sun.org.apache.bcel.internal.verifier.exc.ClassConstraintException;
import com.sun.org.apache.bcel.internal.verifier.exc.InvalidMethodException;
import com.sun.org.apache.bcel.internal.verifier.exc.StaticCodeConstraintException;
import com.sun.org.apache.bcel.internal.verifier.exc.StaticCodeInstructionConstraintException;
import com.sun.org.apache.bcel.internal.verifier.exc.StaticCodeInstructionOperandConstraintException;
import com.sun.org.apache.bcel.internal.verifier.statics.IntList;

public final class Pass3aVerifier
extends PassVerifier {
    private Verifier myOwner;
    private int method_no;
    InstructionList instructionList;
    Code code;

    public Pass3aVerifier(Verifier owner, int method_no) {
        this.myOwner = owner;
        this.method_no = method_no;
    }

    @Override
    public VerificationResult do_verify() {
        if (this.myOwner.doPass2().equals(VerificationResult.VR_OK)) {
            JavaClass jc = Repository.lookupClass(this.myOwner.getClassName());
            Method[] methods = jc.getMethods();
            if (this.method_no >= methods.length) {
                throw new InvalidMethodException("METHOD DOES NOT EXIST!");
            }
            Method method = methods[this.method_no];
            this.code = method.getCode();
            if (method.isAbstract() || method.isNative()) {
                return VerificationResult.VR_OK;
            }
            try {
                this.instructionList = new InstructionList(method.getCode().getCode());
            }
            catch (RuntimeException re) {
                return new VerificationResult(2, "Bad bytecode in the code array of the Code attribute of method '" + method + "'.");
            }
            this.instructionList.setPositions(true);
            VerificationResult vr = VerificationResult.VR_OK;
            try {
                this.delayedPass2Checks();
            }
            catch (ClassConstraintException cce) {
                vr = new VerificationResult(2, cce.getMessage());
                return vr;
            }
            try {
                this.pass3StaticInstructionChecks();
                this.pass3StaticInstructionOperandsChecks();
            }
            catch (StaticCodeConstraintException scce) {
                vr = new VerificationResult(2, scce.getMessage());
            }
            return vr;
        }
        return VerificationResult.VR_NOTYET;
    }

    private void delayedPass2Checks() {
        int i;
        int[] instructionPositions = this.instructionList.getInstructionPositions();
        int codeLength = this.code.getCode().length;
        LineNumberTable lnt = this.code.getLineNumberTable();
        if (lnt != null) {
            LineNumber[] lineNumbers = lnt.getLineNumberTable();
            IntList offsets = new IntList();
            block0: for (i = 0; i < lineNumbers.length; ++i) {
                for (int j = 0; j < instructionPositions.length; ++j) {
                    int offset = lineNumbers[i].getStartPC();
                    if (instructionPositions[j] != offset) continue;
                    if (offsets.contains(offset)) {
                        this.addMessage("LineNumberTable attribute '" + this.code.getLineNumberTable() + "' refers to the same code offset ('" + offset + "') more than once which is violating the semantics [but is sometimes produced by IBM's 'jikes' compiler].");
                        continue block0;
                    }
                    offsets.add(offset);
                    continue block0;
                }
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LineNumberTable attribute '" + this.code.getLineNumberTable() + "' referring to a code offset ('" + lineNumbers[i].getStartPC() + "') that does not exist.");
            }
        }
        Attribute[] atts = this.code.getAttributes();
        for (int a = 0; a < atts.length; ++a) {
            LocalVariableTable lvt;
            if (!(atts[a] instanceof LocalVariableTable) || (lvt = (LocalVariableTable)atts[a]) == null) continue;
            LocalVariable[] localVariables = lvt.getLocalVariableTable();
            for (int i2 = 0; i2 < localVariables.length; ++i2) {
                int startpc = localVariables[i2].getStartPC();
                int length = localVariables[i2].getLength();
                if (!Pass3aVerifier.contains(instructionPositions, startpc)) {
                    throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset ('" + startpc + "') that does not exist.");
                }
                if (Pass3aVerifier.contains(instructionPositions, startpc + length) || startpc + length == codeLength) continue;
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset start_pc+length ('" + (startpc + length) + "') that does not exist.");
            }
        }
        CodeException[] exceptionTable = this.code.getExceptionTable();
        for (i = 0; i < exceptionTable.length; ++i) {
            int startpc = exceptionTable[i].getStartPC();
            int endpc = exceptionTable[i].getEndPC();
            int handlerpc = exceptionTable[i].getHandlerPC();
            if (startpc >= endpc) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + exceptionTable[i] + "' that has its start_pc ('" + startpc + "') not smaller than its end_pc ('" + endpc + "').");
            }
            if (!Pass3aVerifier.contains(instructionPositions, startpc)) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + exceptionTable[i] + "' that has a non-existant bytecode offset as its start_pc ('" + startpc + "').");
            }
            if (!Pass3aVerifier.contains(instructionPositions, endpc) && endpc != codeLength) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + exceptionTable[i] + "' that has a non-existant bytecode offset as its end_pc ('" + startpc + "') [that is also not equal to code_length ('" + codeLength + "')].");
            }
            if (Pass3aVerifier.contains(instructionPositions, handlerpc)) continue;
            throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + exceptionTable[i] + "' that has a non-existant bytecode offset as its handler_pc ('" + handlerpc + "').");
        }
    }

    private void pass3StaticInstructionChecks() {
        if (this.code.getCode().length >= 65536) {
            throw new StaticCodeInstructionConstraintException("Code array in code attribute '" + this.code + "' too big: must be smaller than 65536 bytes.");
        }
        for (InstructionHandle ih = this.instructionList.getStart(); ih != null; ih = ih.getNext()) {
            Instruction i = ih.getInstruction();
            if (i instanceof IMPDEP1) {
                throw new StaticCodeInstructionConstraintException("IMPDEP1 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (i instanceof IMPDEP2) {
                throw new StaticCodeInstructionConstraintException("IMPDEP2 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (!(i instanceof BREAKPOINT)) continue;
            throw new StaticCodeInstructionConstraintException("BREAKPOINT must not be in the code, it is an illegal instruction for _internal_ JVM use!");
        }
        Instruction last = this.instructionList.getEnd().getInstruction();
        if (!(last instanceof ReturnInstruction || last instanceof RET || last instanceof GotoInstruction || last instanceof ATHROW)) {
            throw new StaticCodeInstructionConstraintException("Execution must not fall off the bottom of the code array. This constraint is enforced statically as some existing verifiers do - so it may be a false alarm if the last instruction is not reachable.");
        }
    }

    private void pass3StaticInstructionOperandsChecks() {
        ConstantPoolGen cpg = new ConstantPoolGen(Repository.lookupClass(this.myOwner.getClassName()).getConstantPool());
        InstOperandConstraintVisitor v = new InstOperandConstraintVisitor(cpg);
        for (InstructionHandle ih = this.instructionList.getStart(); ih != null; ih = ih.getNext()) {
            Instruction i = ih.getInstruction();
            if (i instanceof JsrInstruction) {
                InstructionHandle target = ((JsrInstruction)i).getTarget();
                if (target == this.instructionList.getStart()) {
                    throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may have a top-level instruction (such as the very first instruction, which is targeted by instruction '" + ih + "' as its target.");
                }
                if (!(target.getInstruction() instanceof ASTORE)) {
                    throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may target anything else than an ASTORE instruction. Instruction '" + ih + "' targets '" + target + "'.");
                }
            }
            ih.accept(v);
        }
    }

    private static boolean contains(int[] ints, int i) {
        for (int j = 0; j < ints.length; ++j) {
            if (ints[j] != i) continue;
            return true;
        }
        return false;
    }

    public int getMethodNo() {
        return this.method_no;
    }

    private class InstOperandConstraintVisitor
    extends EmptyVisitor {
        private ConstantPoolGen cpg;

        InstOperandConstraintVisitor(ConstantPoolGen cpg) {
            this.cpg = cpg;
        }

        private int max_locals() {
            return Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getCode().getMaxLocals();
        }

        private void constraintViolated(Instruction i, String message) {
            throw new StaticCodeInstructionOperandConstraintException("Instruction " + i + " constraint violated: " + message);
        }

        private void indexValid(Instruction i, int idx) {
            if (idx < 0 || idx >= this.cpg.getSize()) {
                this.constraintViolated(i, "Illegal constant pool index '" + idx + "'.");
            }
        }

        @Override
        public void visitLoadClass(LoadClass o) {
            Verifier v;
            VerificationResult vr;
            ObjectType t = o.getLoadClassType(this.cpg);
            if (t != null && (vr = (v = VerifierFactory.getVerifier(t.getClassName())).doPass1()).getStatus() != 1) {
                this.constraintViolated((Instruction)((Object)o), "Class '" + o.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded: '" + vr + "'.");
            }
        }

        @Override
        public void visitLDC(LDC o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantInteger || c instanceof ConstantFloat || c instanceof ConstantString)) {
                this.constraintViolated(o, "Operand of LDC or LDC_W must be one of CONSTANT_Integer, CONSTANT_Float or CONSTANT_String, but is '" + c + "'.");
            }
        }

        @Override
        public void visitLDC2_W(LDC2_W o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantLong) && !(c instanceof ConstantDouble)) {
                this.constraintViolated(o, "Operand of LDC2_W must be CONSTANT_Long or CONSTANT_Double, but is '" + c + "'.");
            }
            try {
                this.indexValid(o, o.getIndex() + 1);
            }
            catch (StaticCodeInstructionOperandConstraintException e) {
                throw new AssertionViolatedException("OOPS: Does not BCEL handle that? LDC2_W operand has a problem.");
            }
        }

        @Override
        public void visitFieldInstruction(FieldInstruction o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantFieldref)) {
                this.constraintViolated(o, "Indexing a constant that's not a CONSTANT_Fieldref but a '" + c + "'.");
            }
            String field_name = o.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(o.getClassType(this.cpg).getClassName());
            Field[] fields = jc.getFields();
            FieldOrMethod f = null;
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(field_name)) continue;
                f = fields[i];
                break;
            }
            if (f == null) {
                this.constraintViolated(o, "Referenced field '" + field_name + "' does not exist in class '" + jc.getClassName() + "'.");
            } else {
                Type o_type;
                Type f_type = Type.getType(f.getSignature());
                if (!f_type.equals(o_type = o.getType(this.cpg))) {
                    this.constraintViolated(o, "Referenced field '" + field_name + "' has type '" + f_type + "' instead of '" + o_type + "' as expected.");
                }
            }
        }

        @Override
        public void visitInvokeInstruction(InvokeInstruction o) {
            Verifier v;
            VerificationResult vr;
            ConstantNameAndType cnat;
            Constant c;
            this.indexValid(o, o.getIndex());
            if (o instanceof INVOKEVIRTUAL || o instanceof INVOKESPECIAL || o instanceof INVOKESTATIC) {
                c = this.cpg.getConstant(o.getIndex());
                if (!(c instanceof ConstantMethodref)) {
                    this.constraintViolated(o, "Indexing a constant that's not a CONSTANT_Methodref but a '" + c + "'.");
                } else {
                    cnat = (ConstantNameAndType)this.cpg.getConstant(((ConstantMethodref)c).getNameAndTypeIndex());
                    ConstantUtf8 cutf8 = (ConstantUtf8)this.cpg.getConstant(cnat.getNameIndex());
                    if (cutf8.getBytes().equals("<init>") && !(o instanceof INVOKESPECIAL)) {
                        this.constraintViolated(o, "Only INVOKESPECIAL is allowed to invoke instance initialization methods.");
                    }
                    if (!cutf8.getBytes().equals("<init>") && cutf8.getBytes().startsWith("<")) {
                        this.constraintViolated(o, "No method with a name beginning with '<' other than the instance initialization methods may be called by the method invocation instructions.");
                    }
                }
            } else {
                String name;
                c = this.cpg.getConstant(o.getIndex());
                if (!(c instanceof ConstantInterfaceMethodref)) {
                    this.constraintViolated(o, "Indexing a constant that's not a CONSTANT_InterfaceMethodref but a '" + c + "'.");
                }
                if ((name = ((ConstantUtf8)this.cpg.getConstant((cnat = (ConstantNameAndType)this.cpg.getConstant(((ConstantInterfaceMethodref)c).getNameAndTypeIndex())).getNameIndex())).getBytes()).equals("<init>")) {
                    this.constraintViolated(o, "Method to invoke must not be '<init>'.");
                }
                if (name.equals("<clinit>")) {
                    this.constraintViolated(o, "Method to invoke must not be '<clinit>'.");
                }
            }
            Type t = o.getReturnType(this.cpg);
            if (t instanceof ArrayType) {
                t = ((ArrayType)t).getBasicType();
            }
            if (t instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o, "Return type class/interface could not be verified successfully: '" + vr.getMessage() + "'.");
            }
            Type[] ts = o.getArgumentTypes(this.cpg);
            for (int i = 0; i < ts.length; ++i) {
                Verifier v2;
                VerificationResult vr2;
                t = ts[i];
                if (t instanceof ArrayType) {
                    t = ((ArrayType)t).getBasicType();
                }
                if (!(t instanceof ObjectType) || (vr2 = (v2 = VerifierFactory.getVerifier(((ObjectType)t).getClassName())).doPass2()).getStatus() == 1) continue;
                this.constraintViolated(o, "Argument type class/interface could not be verified successfully: '" + vr2.getMessage() + "'.");
            }
        }

        @Override
        public void visitINSTANCEOF(INSTANCEOF o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
        }

        @Override
        public void visitCHECKCAST(CHECKCAST o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
        }

        @Override
        public void visitNEW(NEW o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            } else {
                ConstantUtf8 cutf8 = (ConstantUtf8)this.cpg.getConstant(((ConstantClass)c).getNameIndex());
                Type t = Type.getType("L" + cutf8.getBytes() + ";");
                if (t instanceof ArrayType) {
                    this.constraintViolated(o, "NEW must not be used to create an array.");
                }
            }
        }

        @Override
        public void visitMULTIANEWARRAY(MULTIANEWARRAY o) {
            Type t;
            short dimensions2create;
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
            if ((dimensions2create = o.getDimensions()) < 1) {
                this.constraintViolated(o, "Number of dimensions to create must be greater than zero.");
            }
            if ((t = o.getType(this.cpg)) instanceof ArrayType) {
                int dimensions = ((ArrayType)t).getDimensions();
                if (dimensions < dimensions2create) {
                    this.constraintViolated(o, "Not allowed to create array with more dimensions ('+dimensions2create+') than the one referenced by the CONSTANT_Class '" + t + "'.");
                }
            } else {
                this.constraintViolated(o, "Expecting a CONSTANT_Class referencing an array type. [Constraint not found in The Java Virtual Machine Specification, Second Edition, 4.8.1]");
            }
        }

        @Override
        public void visitANEWARRAY(ANEWARRAY o) {
            int dimensions;
            Type t;
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
            if ((t = o.getType(this.cpg)) instanceof ArrayType && (dimensions = ((ArrayType)t).getDimensions()) >= 255) {
                this.constraintViolated(o, "Not allowed to create an array with more than 255 dimensions.");
            }
        }

        @Override
        public void visitNEWARRAY(NEWARRAY o) {
            byte t = o.getTypecode();
            if (t != 4 && t != 5 && t != 6 && t != 7 && t != 8 && t != 9 && t != 10 && t != 11) {
                this.constraintViolated(o, "Illegal type code '+t+' for 'atype' operand.");
            }
        }

        @Override
        public void visitILOAD(ILOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitFLOAD(FLOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitALOAD(ALOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitISTORE(ISTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitFSTORE(FSTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitASTORE(ASTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitIINC(IINC o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitRET(RET o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitLLOAD(LLOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitDLOAD(DLOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitLSTORE(LSTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitDSTORE(DSTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitLOOKUPSWITCH(LOOKUPSWITCH o) {
            int[] matchs = o.getMatchs();
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < matchs.length; ++i) {
                if (matchs[i] == max && i != 0) {
                    this.constraintViolated(o, "Match '" + matchs[i] + "' occurs more than once.");
                }
                if (matchs[i] < max) {
                    this.constraintViolated(o, "Lookup table must be sorted but isn't.");
                    continue;
                }
                max = matchs[i];
            }
        }

        @Override
        public void visitTABLESWITCH(TABLESWITCH o) {
        }

        @Override
        public void visitPUTSTATIC(PUTSTATIC o) {
            String field_name = o.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(o.getClassType(this.cpg).getClassName());
            Field[] fields = jc.getFields();
            AccessFlags f = null;
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(field_name)) continue;
                f = fields[i];
                break;
            }
            if (f == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            if (f.isFinal() && !Pass3aVerifier.this.myOwner.getClassName().equals(o.getClassType(this.cpg).getClassName())) {
                this.constraintViolated(o, "Referenced field '" + f + "' is final and must therefore be declared in the current class '" + Pass3aVerifier.this.myOwner.getClassName() + "' which is not the case: it is declared in '" + o.getClassType(this.cpg).getClassName() + "'.");
            }
            if (!f.isStatic()) {
                this.constraintViolated(o, "Referenced field '" + f + "' is not static which it should be.");
            }
            String meth_name = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getName();
            if (!jc.isClass() && !meth_name.equals("<clinit>")) {
                this.constraintViolated(o, "Interface field '" + f + "' must be set in a '" + "<clinit>" + "' method.");
            }
        }

        @Override
        public void visitGETSTATIC(GETSTATIC o) {
            String field_name = o.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(o.getClassType(this.cpg).getClassName());
            Field[] fields = jc.getFields();
            AccessFlags f = null;
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(field_name)) continue;
                f = fields[i];
                break;
            }
            if (f == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            if (!f.isStatic()) {
                this.constraintViolated(o, "Referenced field '" + f + "' is not static which it should be.");
            }
        }

        @Override
        public void visitINVOKEINTERFACE(INVOKEINTERFACE o) {
            String classname = o.getClassName(this.cpg);
            JavaClass jc = Repository.lookupClass(classname);
            Method[] ms = jc.getMethods();
            Method m = null;
            for (int i = 0; i < ms.length; ++i) {
                if (!ms[i].getName().equals(o.getMethodName(this.cpg)) || !Type.getReturnType(ms[i].getSignature()).equals(o.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(ms[i].getSignature()), o.getArgumentTypes(this.cpg))) continue;
                m = ms[i];
                break;
            }
            if (m == null) {
                this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' with expected signature not found in class '" + jc.getClassName() + "'. The native verfier does allow the method to be declared in some superinterface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (jc.isClass()) {
                this.constraintViolated(o, "Referenced class '" + jc.getClassName() + "' is a class, but not an interface as expected.");
            }
        }

        @Override
        public void visitINVOKESPECIAL(INVOKESPECIAL o) {
            JavaClass current;
            String classname = o.getClassName(this.cpg);
            JavaClass jc = Repository.lookupClass(classname);
            Method[] ms = jc.getMethods();
            Method m = null;
            for (int i = 0; i < ms.length; ++i) {
                if (!ms[i].getName().equals(o.getMethodName(this.cpg)) || !Type.getReturnType(ms[i].getSignature()).equals(o.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(ms[i].getSignature()), o.getArgumentTypes(this.cpg))) continue;
                m = ms[i];
                break;
            }
            if (m == null) {
                this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' with expected signature not found in class '" + jc.getClassName() + "'. The native verfier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if ((current = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName())).isSuper() && Repository.instanceOf(current, jc) && !current.equals(jc) && !o.getMethodName(this.cpg).equals("<init>")) {
                int supidx = -1;
                Method meth = null;
                while (supidx != 0) {
                    supidx = current.getSuperclassNameIndex();
                    current = Repository.lookupClass(current.getSuperclassName());
                    Method[] meths = current.getMethods();
                    for (int i = 0; i < meths.length; ++i) {
                        if (!meths[i].getName().equals(o.getMethodName(this.cpg)) || !Type.getReturnType(meths[i].getSignature()).equals(o.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(meths[i].getSignature()), o.getArgumentTypes(this.cpg))) continue;
                        meth = meths[i];
                        break;
                    }
                    if (meth == null) continue;
                    break;
                }
                if (meth == null) {
                    this.constraintViolated(o, "ACC_SUPER special lookup procedure not successful: method '" + o.getMethodName(this.cpg) + "' with proper signature not declared in superclass hierarchy.");
                }
            }
        }

        @Override
        public void visitINVOKESTATIC(INVOKESTATIC o) {
            String classname = o.getClassName(this.cpg);
            JavaClass jc = Repository.lookupClass(classname);
            Method[] ms = jc.getMethods();
            AccessFlags m = null;
            for (int i = 0; i < ms.length; ++i) {
                if (!ms[i].getName().equals(o.getMethodName(this.cpg)) || !Type.getReturnType(ms[i].getSignature()).equals(o.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(ms[i].getSignature()), o.getArgumentTypes(this.cpg))) continue;
                m = ms[i];
                break;
            }
            if (m == null) {
                this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' with expected signature not found in class '" + jc.getClassName() + "'. The native verifier possibly allows the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (!m.isStatic()) {
                this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' has ACC_STATIC unset.");
            }
        }

        @Override
        public void visitINVOKEVIRTUAL(INVOKEVIRTUAL o) {
            String classname = o.getClassName(this.cpg);
            JavaClass jc = Repository.lookupClass(classname);
            Method[] ms = jc.getMethods();
            Method m = null;
            for (int i = 0; i < ms.length; ++i) {
                if (!ms[i].getName().equals(o.getMethodName(this.cpg)) || !Type.getReturnType(ms[i].getSignature()).equals(o.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(ms[i].getSignature()), o.getArgumentTypes(this.cpg))) continue;
                m = ms[i];
                break;
            }
            if (m == null) {
                this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' with expected signature not found in class '" + jc.getClassName() + "'. The native verfier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (!jc.isClass()) {
                this.constraintViolated(o, "Referenced class '" + jc.getClassName() + "' is an interface, but not a class as expected.");
            }
        }

        private boolean objarrayequals(Object[] o, Object[] p) {
            if (o.length != p.length) {
                return false;
            }
            for (int i = 0; i < o.length; ++i) {
                if (o[i].equals(p[i])) continue;
                return false;
            }
            return true;
        }
    }
}

