/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.webservices.reflect;

import com.sun.script.webservices.reflect.ArrayAdapter;
import com.sun.script.webservices.reflect.ValueHolder;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public class ObjectAdapter {
    protected final Object adaptee;
    protected final Class adapteeType;
    protected final ValueHolder owner;

    protected ObjectAdapter(ValueHolder owner, Object adaptee) {
        this.owner = owner;
        this.adaptee = adaptee;
        this.adapteeType = adaptee.getClass();
    }

    public ValueHolder getValue(String key) {
        Method getter = null;
        Method setter = null;
        Class parameterType = null;
        Class<?> propertyType = null;
        PropertyDescriptor[] descriptors = null;
        try {
            return this.getValue(new Integer(key));
        }
        catch (NumberFormatException e) {
            if (this instanceof ArrayAdapter) {
                this.owner.throwIncorrectArgumentException("Attempt to set property " + key + " in an array.");
            }
            try {
                BeanInfo info = Introspector.getBeanInfo(this.adapteeType);
                for (PropertyDescriptor descriptor : descriptors = info.getPropertyDescriptors()) {
                    Type at;
                    Type type;
                    if (!key.equals(descriptor.getName())) continue;
                    getter = descriptor.getReadMethod();
                    setter = descriptor.getWriteMethod();
                    propertyType = descriptor.getPropertyType();
                    Object value = getter.invoke(this.adaptee, new Object[0]);
                    if (value == null) {
                        value = ValueHolder.createInstance(propertyType);
                        setter.invoke(this.adaptee, value);
                    }
                    if (value instanceof List && getter != null && (type = getter.getGenericReturnType()) instanceof ParameterizedType && (at = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
                        parameterType = (Class)at;
                    }
                    return new PropertyValueHolder(this.owner, key, propertyType, parameterType, value, setter);
                }
            }
            catch (IntrospectionException e2) {
            }
            catch (IllegalAccessException eee) {
            }
            catch (InvocationTargetException eeee) {
                // empty catch block
            }
            if (propertyType == null) {
                String message = "Could not access property\n\t" + key + ".\n" + "The recognized property names are:\n";
                for (int i = 0; i < descriptors.length; ++i) {
                    message = message + "\t" + descriptors[i].getName() + "\n";
                }
                this.owner.throwIncorrectArgumentException(message);
            }
            return null;
        }
    }

    protected ValueHolder getValue(Integer number) {
        this.owner.throwIncorrectArgumentException("Attempt to set property " + number + " in an object that is not an array.");
        return null;
    }

    public static ObjectAdapter newObjectAdapter(ValueHolder owner, Object adaptee) {
        ArrayAdapter aa = null;
        aa = ArrayAdapter.newArrayAdapter(owner, adaptee);
        if (null != aa) {
            return aa;
        }
        return new ObjectAdapter(owner, adaptee);
    }

    public final class PropertyValueHolder
    extends ValueHolder {
        private final String propertyName;
        private final Method setter;

        public PropertyValueHolder(ValueHolder parent, String propertyName, Class type, Class parameterType, Object value, Method setter) {
            this.propertyName = propertyName;
            this.setter = setter;
            this.parent = parent;
            this.obj = value;
            this.type = type;
            this.parameterType = parameterType;
        }

        public void onValueChanged(Object newValue) {
            try {
                this.setter.invoke(ObjectAdapter.this.adaptee, newValue);
            }
            catch (Exception e) {
                ObjectAdapter.this.owner.throwIncorrectArgumentException("Could not set the property " + this.propertyName);
            }
        }
    }
}

