/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.webservices.reflect;

import com.sun.script.webservices.reflect.ObjectAdapter;
import java.lang.reflect.Method;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class ValueHolder {
    protected Object obj;
    protected Class type;
    protected Class parameterType;
    protected ValueHolder parent;

    public ValueHolder(Class argType) {
        this.type = argType;
        try {
            this.obj = argType.newInstance();
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    protected ValueHolder() {
    }

    public ValueHolder(Object obj) {
        this.obj = obj;
        this.type = obj.getClass();
    }

    public Class getParameterType() {
        return this.parameterType;
    }

    public Object getObjectAdapter() {
        return ObjectAdapter.newObjectAdapter(this, this.obj);
    }

    public Object getValue() {
        return this.obj;
    }

    public void setValue(String s) {
        if (this.type == String.class) {
            this.onValueChanged(s);
        } else if (this.type.getAnnotation(XmlEnum.class) != null) {
            Object enume = null;
            try {
                Method[] methods;
                for (Method method : methods = this.type.getDeclaredMethods()) {
                    String ss = method.getName();
                    if (!method.getName().equals("fromValue")) continue;
                    Class<?>[] types = method.getParameterTypes();
                    enume = method.invoke(null, s);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.onValueChanged(enume);
        } else {
            this.throwIncorrectArgumentException();
        }
    }

    public void setValue(Double d) {
        if (this.type == Byte.class || this.type == Byte.TYPE) {
            this.onValueChanged(new Byte(d.byteValue()));
        } else if (this.type == Short.class || this.type == Short.TYPE) {
            this.onValueChanged(new Short(d.shortValue()));
        } else if (this.type == Integer.class || this.type == Integer.TYPE) {
            this.onValueChanged(new Integer(d.intValue()));
        } else if (this.type == Long.class || this.type == Long.TYPE) {
            this.onValueChanged(new Long(d.longValue()));
        } else if (this.type == Float.class || this.type == Float.TYPE) {
            this.onValueChanged(new Float(d.floatValue()));
        } else if (this.type == Double.class || this.type == Double.TYPE) {
            this.onValueChanged(d);
        } else {
            this.throwIncorrectArgumentException();
        }
    }

    public void setValue(Boolean b) {
        if (this.type == Boolean.class || this.type == Boolean.TYPE) {
            this.onValueChanged(new Boolean(b));
        } else {
            this.throwIncorrectArgumentException();
        }
    }

    public void setValue(Object obj) {
        if (this.type.isAssignableFrom(obj.getClass())) {
            this.onValueChanged(obj);
        } else {
            this.throwIncorrectArgumentException();
        }
    }

    public void setNullValue() {
        this.onValueChanged(null);
    }

    public void onValueChanged(Object newValue) {
        this.obj = newValue;
    }

    public void throwIncorrectArgumentException() {
        if (this.parent != null) {
            this.parent.throwIncorrectArgumentException();
        }
        throw new IllegalArgumentException();
    }

    public void throwIncorrectArgumentException(String message) {
        if (this.parent != null) {
            this.parent.throwIncorrectArgumentException(message);
        }
        throw new IllegalArgumentException(message);
    }

    public static Object createInstance(Class clasz) {
        try {
            if (clasz.equals(XMLGregorianCalendar.class)) {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar();
            }
            return clasz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }
}

