/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.webservices.reflect;

import com.sun.script.webservices.reflect.Operation;

public class IncorrectArgumentException
extends RuntimeException {
    private final Operation operation;
    private final int index;
    private final String additionalMessage;

    public IncorrectArgumentException(int index, Operation operation) {
        this.index = index;
        this.operation = operation;
        this.additionalMessage = null;
    }

    public IncorrectArgumentException(int index, Operation operation, String additionalMessage) {
        this.index = index;
        this.operation = operation;
        this.additionalMessage = additionalMessage;
    }

    public String getMessage() {
        String message = "\n\nArgument #" + this.index + " to Operation " + this.operation.getName() + " is incorrect.\n" + "The types of the arguments are:\n";
        for (int j = 0; j < this.operation.getArgTypes().length; ++j) {
            message = message + "\t#" + j + "  " + this.getTypeName(this.operation.getArgTypes()[j]) + "\n\n";
        }
        if (this.additionalMessage != null) {
            message = message + this.additionalMessage + "\n";
        }
        return message;
    }

    private String getTypeName(Class argType) {
        if (argType == Byte.class || argType == Byte.TYPE || argType == Short.class || argType == Short.TYPE || argType == Integer.class || argType == Integer.TYPE || argType == Long.class || argType == Long.TYPE || argType == Float.class || argType == Float.TYPE || argType == Double.class || argType == Double.TYPE) {
            return "number";
        }
        if (argType == Boolean.class || argType == Boolean.TYPE) {
            return "boolean";
        }
        if (argType == String.class) {
            return "string";
        }
        return "object (" + argType.getName() + ")";
    }
}

