/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.webservices.reflect;

import com.sun.script.webservices.reflect.ObjectAdapter;
import com.sun.script.webservices.reflect.ValueHolder;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;

public class ArrayAdapter
extends ObjectAdapter {
    private final ArrayList list;
    private final Class elementType;

    private ArrayAdapter(ValueHolder owner, Object adaptee, ArrayList list, Class elementType) {
        super(owner, adaptee);
        this.list = list;
        this.elementType = elementType;
    }

    public static ArrayAdapter newArrayAdapter(ValueHolder owner, Object adaptee) {
        if (adaptee instanceof ArrayList && owner.getParameterType() != null) {
            return new ArrayAdapter(owner, adaptee, (ArrayList)adaptee, owner.getParameterType());
        }
        Class<?> clasz = adaptee.getClass();
        Field[] fields = clasz.getDeclaredFields();
        if (fields.length != 1) {
            return null;
        }
        Field field = fields[0];
        Type type = null;
        Object ptype = null;
        try {
            XmlElement annotation = field.getAnnotation(XmlElement.class);
            if (null != annotation) {
                ParameterizedType pt;
                Type[] types;
                String annotationName = annotation.name();
                if (annotationName.equals("##default")) {
                    String fieldName = field.getName();
                    Character upper = Character.valueOf(Character.toUpperCase(fieldName.charAt(0)));
                    StringBuilder builder = new StringBuilder(fieldName);
                    builder.setCharAt(0, upper.charValue());
                    annotationName = new String(builder);
                }
                if (field.getType() == List.class && (type = field.getGenericType()) instanceof ParameterizedType && (types = (pt = (ParameterizedType)type).getActualTypeArguments()).length == 1 && types[0] instanceof Class) {
                    Method getter = clasz.getMethod("get" + annotationName, new Class[0]);
                    ArrayList list = (ArrayList)getter.invoke(adaptee, new Object[0]);
                    return new ArrayAdapter(owner, adaptee, list, (Class)types[0]);
                }
            }
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchMethodException ee) {
        }
        catch (InvocationTargetException eee) {
            // empty catch block
        }
        return null;
    }

    public ValueHolder getValue(String key) {
        if (key.equals("length")) {
            return new ValueHolder(new Integer(this.list.size()));
        }
        return super.getValue(key);
    }

    public ValueHolder getValue(Integer number) {
        Object element;
        int elementIndex = number;
        if (elementIndex >= this.list.size()) {
            for (int i = this.list.size(); i <= elementIndex; ++i) {
                this.list.add(null);
            }
        }
        if ((element = this.list.get(elementIndex)) == null) {
            try {
                element = this.elementType.newInstance();
                this.list.set(elementIndex, element);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException ee) {
                // empty catch block
            }
        }
        return new ArrayElementHolder(this.owner, elementIndex, element);
    }

    public final class ArrayElementHolder
    extends ValueHolder {
        private final int elementIndex;

        public ArrayElementHolder(ValueHolder parent, int elementIndex, Object value) {
            this.elementIndex = elementIndex;
            this.parent = parent;
            this.obj = value;
            this.type = ArrayAdapter.this.elementType;
        }

        public void onValueChanged(Object newValue) {
            ArrayAdapter.this.list.set(this.elementIndex, newValue);
        }
    }
}

