/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.webservices;

import com.sun.script.webservices.reflect.Service;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;

public class ServiceManager {
    private static HashSet<Service> services = new HashSet();
    private static String initString = null;

    public static String getInitString() {
        return initString;
    }

    public static Service findService(String name) {
        for (Service s : services) {
            if (!s.getServiceName().equals(name)) continue;
            return s;
        }
        throw new RuntimeException(ServiceManager.getNoSuchServiceMessage(name));
    }

    public static void addService(Service s) {
        services.add(s);
    }

    public static void addService(String s) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> claszz = null;
        try {
            claszz = loader.loadClass(s);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find WebService class " + s);
        }
        ServiceManager.addService(new Service(claszz));
    }

    public static Collection getServices() {
        return services;
    }

    static String getNoSuchServiceMessage(String name) {
        String message = "\n\nUnknown service -  " + name + ".\n";
        if (services.isEmpty()) {
            message = message + "There are no recognized services";
        } else {
            message = message + "The recognized services are:\n";
            for (Service service : services) {
                message = message + "   " + service.getServiceName() + "\n";
            }
        }
        return message;
    }

    static {
        StringBuffer buffer = new StringBuffer();
        try {
            int i;
            InputStream stream = ServiceManager.class.getResourceAsStream("/resources/webservices.init.js");
            InputStreamReader reader = new InputStreamReader(stream);
            boolean count = false;
            while (-1 != (i = reader.read())) {
                buffer.append((char)i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        initString = buffer.toString();
    }
}

