/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.webservices.reflect;

import com.sun.script.webservices.reflect.Port;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;

public class Service {
    protected final Class clasz;
    protected String name;
    protected final ArrayList<Port> ports = new ArrayList();

    public Service(Class clasz) {
        if (clasz == null) {
            throw new NullPointerException();
        }
        this.clasz = clasz;
        this.init();
    }

    private void init() {
        Method[] methods;
        WebServiceClient clientAnnotation = this.clasz.getAnnotation(WebServiceClient.class);
        if (clientAnnotation == null) {
            throw new IllegalArgumentException("Class does not have a WebServiceClientAnnotation");
        }
        this.name = clientAnnotation.name();
        for (Method method : methods = this.clasz.getDeclaredMethods()) {
            WebEndpoint we = method.getAnnotation(WebEndpoint.class);
            if (we == null || method.getParameterTypes().length != 0) continue;
            this.ports.add(new Port(we.name(), method));
        }
    }

    public String getServiceName() {
        return this.name;
    }

    public String getPackageName() {
        String className = this.clasz.getName();
        int lastIndex = className.lastIndexOf(".");
        return className.substring(0, lastIndex);
    }

    public Class getServiceClass() {
        return this.clasz;
    }

    public Port[] getPorts() {
        return this.ports.toArray(new Port[0]);
    }

    public Port getPort(String name) {
        for (Port port : this.ports) {
            if (!port.getName().equals(name)) continue;
            return port;
        }
        throw new RuntimeException(this.getNoSuchPortMessage(name));
    }

    public javax.xml.ws.Service newJAXWSService() {
        try {
            return (javax.xml.ws.Service)this.clasz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("\nCould not create an instance of " + this.clasz.getName() + ".  The remote endpoint does not respond.\n");
        }
    }

    private String getNoSuchPortMessage(String name) {
        String message = "\n\nUnknown Port -  " + name + ".\n";
        message = this.ports.size() == 1 ? message + "The recognized Port is:\n" : message + "The recognized Ports are:\n";
        for (Port port : this.ports) {
            message = message + "   " + port.getName() + "\n";
        }
        return message;
    }
}

