/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.webservices.reflect;

import com.sun.script.webservices.reflect.Operation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.jws.WebMethod;
import javax.xml.ws.Service;

public class Port {
    private final String name;
    private final Method getter;
    private Class clasz;
    private ArrayList<Operation> operations = new ArrayList();

    public Port(String name, Method getter) {
        this.name = name;
        this.getter = getter;
        this.init();
    }

    private void init() {
        Method[] methods;
        this.clasz = this.getter.getReturnType();
        for (Method method : methods = this.clasz.getMethods()) {
            WebMethod wm = method.getAnnotation(WebMethod.class);
            if (wm == null) continue;
            String name = wm.operationName();
            if (name == null || name.equals("")) {
                name = method.getName();
            }
            Operation op = new Operation(name, method);
            this.operations.add(op);
        }
    }

    public String getName() {
        return this.name;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Operation[] getOperations() {
        return this.operations.toArray(new Operation[0]);
    }

    public Operation getOperation(String name) {
        for (Operation operation : this.operations) {
            if (!operation.getName().equals(name)) continue;
            return operation;
        }
        throw new RuntimeException(this.getNoSuchOperationMessage(name));
    }

    public Object getJAXWSPort(Service service) {
        try {
            return this.getter.invoke((Object)service, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getNoSuchOperationMessage(String name) {
        String message = "\n\nUnknown Operation -  " + name + ".\n";
        message = this.operations.size() == 1 ? message + "The recognized Operation is:\n" : message + "The recognized Operations are:\n";
        for (Operation op : this.operations) {
            message = message + "   " + op.getName() + "\n";
        }
        return message;
    }
}

