/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


/**
 * webservices.init.js
 */

function WebServiceManager() {
    
   
    /*
      Initialization
     */
  
    var servicemanager = Packages.com.sun.script.webservices.ServiceManager;
   
    /*
      Helper functions
     */
    
    /**
     * Returns the classname if the object is a Java Object.  
     * Returns undefined otherwise
     */
    function getJavaClassName(obj) {
        
        gcfunction = obj.getClass;
       
        if (gcfunction != undefined && typeof(gcfunction) == "function") {
            var clasz = gcfunction.apply(obj);
            if (clasz != undefined) {
                var name = clasz.getName();
                if (name != undefined) {
                    return name;
                }
            }
        }
        return undefined;
        
    }
    
    /**
     * Checks whether the specified object is an instance of the
     * specified type.  Works with types Array and Date
     */
    function verifyObjectType(obj, type) {
        if (obj.constructor.toString().indexOf(type) == -1)
            return false;
        else
            return true;
    }
    
   /**
     * Determines whether argument is an instance of the specified class.
     *
     * @return true - if (obj instanceof class)
     *         false - otherwise (including error cases where obj is not a JavaObject
     *           or className is not the name of a Class.
     */
   function isInstanceOf(obj, className) {
       
        var derivedclass = obj.getClass();
        var clasz = Packages.java.lang.Class.forName(className);
        if (derivedclass == undefined || clasz == undefined) {
            return false;
        }
        
        if (clasz.isAssignableFrom(derivedclass)) {
            return true;
        } else {
            return false;
        }
    }
   
    /**
      * Converts a JavaScript Date object to an instance of 
      * javax.xml.datatype.XMLGregorianCalendar
      */
     
    function dateToJavaDate(date) {
	var gdate = new Packages.java.util.GregorianCalendar();
	gdate.setTimeInMillis(date.getTime());
	var factory = Packages.javax.xml.datatype.DatatypeFactory.newInstance();
	return factory.newXMLGregorianCalendar(gdate);
    }

    /**
     * Converts an instance of javax.xml.datatype.XMLGregorianCalendar
     * to a JavaScript Date object.
     */
    function javaDateToDate(javaDate) {
            var gdate = javaDate.toGregorianCalendar();
            var ret = new Date();
            ret.setTime(gdate.getTimeInMillis());
            return ret;
    }

    
    /**
      * Function used to access instances of com.sun.script.javascript.reflect.ValueHolder
      * from Javascript.  Unwraps the  wrapped value if it is a primitive.  If
      * the wrapped value is an object, the function returns an object that unwraps
      * object-valued properties in a similar way.
      */ 
    function getValue(valueHolder) {
        
        var value = valueHolder.getValue();
        if (value == null) {
            return null;
        }
        
        if (isInstanceOf(value, "java.lang.String")) {
            return "" + value;
        } else if (isInstanceOf(value , "java.lang.Number")) {
            return value.doubleValue();
        } else if (isInstanceOf(value, "java.lang.Boolean")) {
            return value.booleanValue();
        } else if (isInstanceOf(value, "javax.xml.datatype.XMLGregorianCalendar")) {
            return javaDateToDate(value);
        //TODO other cases
        } else {
            
            var adapter = valueHolder.getObjectAdapter();
            return new JSAdapter (new function() {
                this.__get__ = function(key) {
                                   var ret = adapter.getValue(key);
                                   return getValue(ret);
                               }
                });
       }
         
    }
    
   
    /*
     * Helper to copy a Javascript parameter property-by-property member into the JAXB Bean
     * that will be passed to Java method.
     *
     * @param source The Javascript parameter
     * @param target A com.sun.script.webservices.ArgumentHolder
     */
    
    function pass(source, target) {
        
        if (source == null || source == undefined) {          
            target.setNullValue();
            return;
        }    
        var type = typeof(source);
        if (type == "string" || 
            type == "number" || 
            type == "boolean" ||
            getJavaClassName(source) != undefined ) {
                
            //pass primitive argument or Java object by value
            target.setValue(source);
            
        } else if (type == "object"){ 
            
            //TODO - Handle built-in Javascript objects, such as Date, RegExp
            if (verifyObjectType(source, "Date")) {
                target.setValue(dateToJavaDate(source));
                return;
            }
                 
            var adapter = target.getObjectAdapter();         
            for (var key in source) {
                pass(source[key], adapter.getValue(key));
            }
            
        } else {
            //TODO - Handle error cases, such as Function.
        }
                
    }
    
    /**
      * Packages the return value from a WebService operation in a form that
      * is easy to access from JavaScript.
      */
    function receive(retval) {
  
        var valueHolder = 
            new Packages.com.sun.script.webservices.reflect.ValueHolder(retval);
        return getValue(valueHolder);
  
    }
    
    /**
      * Adds a WebService Client.  Pass the fully-qualified name of the
      * Class generated by wsimport that implements javax.xml.ws.Service,
      * which is on the classpath.
     */
    function addService(className) {
        
        servicemanager.addService(className);
    }
    
    
    /*
      Returns a wrapper for a specified WebService Client for use by the application
     */
    function findService(name) {
     
        var servicedata = servicemanager.findService(name); 

        //return a wrapper for the Service with the specified name
        return new JSAdapter(new function() {

            //servicedata is a com.sun.script.webservices.reflect.Service, 
            //which has a helper method that returns an instance of the 
            //corresponding javax.xml.ws.Service class
            var service = servicedata.newJAXWSService()
            var ports = servicedata.getPorts();

            this.__get__ = function(name) {

                var portdata = servicedata.getPort(name);
                return new JSAdapter(new function() {

                    //each portdata is a com.sun.script.webservices.reflect.Port 
                    //thathas a helper method returning an instance of the 
                    //corresponding javax.xml.ws.Port class.
                    var port = portdata.getJAXWSPort(service);
                    var operations = portdata.getOperations();

                    this.__get__ = function(name) {

                        var operation = portdata.getOperation(name);
                        return function() {
                            var argHolders = operation.getArgumentHolders();
                            var len = arguments.length;

                            for (var i = 0; i < len; i++) {
                                //TODO - Validate number of arguments.
                                pass(arguments[i], argHolders[i]);   
                            }

                          
                            var ret = operation.invoke(port, argHolders);
                            return receive(ret);
                        }   
                    }       
                })        
            }
        })
    }
    
    //exports
    this.findService = findService;
    this.addService = addService;
}     
    
   