/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.webapp;

import com.sun.phobos.container.PhobosAdapter;
import com.sun.phobos.container.ResourceService;
import com.sun.phobos.container.webapp.HttpServletRequestWrapper;
import com.sun.phobos.container.webapp.HttpServletResponseWrapper;
import com.sun.phobos.container.webapp.WebappFileResourceService;
import com.sun.phobos.container.webapp.WebappResourceService;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappPhobosAdapter
extends PhobosAdapter<HttpServletRequest, HttpServletResponse> {
    public static final String WEBAPP_PLATFORM = "webapp";
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final int WEB_XML_LEN = "/WEB-INF/web.xml".length();
    protected ServletContext context;

    public WebappPhobosAdapter(ServletContext context) {
        this.context = context;
        Properties properties = new Properties();
        Enumeration e = context.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = context.getInitParameter(name);
            properties.put(name, value);
        }
        this.properties = properties;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    protected ResourceService createResourceService(String baseDir) {
        return baseDir == null ? new WebappResourceService(this.context) : new WebappFileResourceService(baseDir);
    }

    protected String getPlatform() {
        return WEBAPP_PLATFORM;
    }

    protected String getDefaultScratchDirectory() {
        try {
            return ((File)this.context.getAttribute("javax.servlet.context.tempdir")).getCanonicalPath();
        }
        catch (IOException e) {
            return ((File)this.context.getAttribute("javax.servlet.context.tempdir")).getAbsolutePath();
        }
    }

    protected String getEnvironment() {
        String s = this.context.getInitParameter("com.sun.phobos.environment");
        return s == null ? super.getEnvironment() : s;
    }

    protected String getDefaultBaseDirectory() {
        String realPath = this.context.getRealPath(WEB_XML);
        if (realPath == null) {
            return null;
        }
        return realPath.substring(0, realPath.length() - WEB_XML_LEN);
    }

    protected HttpServletRequestWrapper createRequestWrapper(HttpServletRequest request) {
        return new HttpServletRequestWrapper(request);
    }

    protected HttpServletResponseWrapper createResponseWrapper(HttpServletResponse response) {
        return new HttpServletResponseWrapper(response);
    }
}

