/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.simple;

import com.sun.net.httpserver.HttpExchange;
import com.sun.phobos.container.RequestWrapper;
import com.sun.phobos.container.simple.Cookie;
import com.sun.phobos.container.simple.Cookies;
import com.sun.phobos.container.simple.Enumerator;
import com.sun.phobos.container.simple.FastHttpDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRequestWrapper
extends RequestWrapper<HttpExchange> {
    private boolean cookiesParsed = false;
    private boolean parametersParsed;
    private Cookie[] cookies;
    private Map<String, List<String>> parameters;
    private SimpleDateFormat[] formats = (SimpleDateFormat[])staticDateFormats.get();
    private String requestURI;
    private String queryString;
    private String charEncoding;
    private boolean gotReader;
    private boolean gotStream;
    private Reader reader;
    private Map attributes;
    private static ThreadLocal staticDateFormats = new ThreadLocal(){

        protected Object initialValue() {
            SimpleDateFormat[] f = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
            return f;
        }
    };
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private static final String APPLICATION_X_WWW_FORM_URLENCODED_MEDIA_TYPE = "application/x-www-form-urlencoded";

    public SimpleRequestWrapper(HttpExchange request) {
        super(request);
        this.formats[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[1].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[2].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.parseRequestURI();
        this.gotReader = false;
        this.gotStream = false;
        this.attributes = new HashMap();
    }

    @Override
    public Object getRequestObject() {
        return this;
    }

    @Override
    public String getRequestURI() {
        return this.requestURI;
    }

    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public Enumeration getHeaderNames() {
        return new Enumerator<String>(((HttpExchange)this.request).getRequestHeaders().keySet());
    }

    @Override
    public String getHeader(String name) {
        return ((HttpExchange)this.request).getRequestHeaders().getFirst(name);
    }

    public String getContextPath() {
        return ((HttpExchange)this.request).getHttpContext().getPath();
    }

    public String getProtocol() {
        return ((HttpExchange)this.request).getProtocol();
    }

    public String getScheme() {
        return "http";
    }

    public boolean isSecure() {
        return false;
    }

    public String getLocalAddr() {
        return ((HttpExchange)this.request).getLocalAddress().getAddress().getHostAddress();
    }

    public String getLocalName() {
        return ((HttpExchange)this.request).getLocalAddress().getHostName();
    }

    public int getLocalPort() {
        return ((HttpExchange)this.request).getLocalAddress().getPort();
    }

    public String getRemoteAddr() {
        return ((HttpExchange)this.request).getRemoteAddress().getAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return ((HttpExchange)this.request).getRemoteAddress().getHostName();
    }

    public int getRemotePort() {
        return ((HttpExchange)this.request).getRemoteAddress().getPort();
    }

    public String getServerName() {
        String host = this.getHeader("Host");
        if (host != null) {
            int i = host.indexOf(58);
            if (i == -1) {
                return host;
            }
            return host.substring(0, i);
        }
        return this.getLocalAddr();
    }

    public int getServerPort() {
        return ((HttpExchange)this.request).getHttpContext().getServer().getAddress().getPort();
    }

    public Reader getReader() throws IOException {
        if (this.gotStream) {
            throw new IllegalStateException("getReader called previously");
        }
        this.gotReader = true;
        String enc = this.getCharacterEncoding();
        if (enc == null) {
            enc = DEFAULT_CHARACTER_ENCODING;
        }
        this.reader = new InputStreamReader(((HttpExchange)this.request).getRequestBody(), enc);
        return this.reader;
    }

    public InputStream getInputStream() {
        if (this.gotReader) {
            throw new IllegalStateException("getWriter called previously");
        }
        this.gotStream = true;
        return ((HttpExchange)this.request).getRequestBody();
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = FastHttpDateFormat.parseDate(value, this.formats);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    public Enumeration getHeaders(String name) {
        return new Enumerator(((HttpExchange)this.request).getRequestHeaders().get(name));
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getMethod() {
        return ((HttpExchange)this.request).getRequestMethod();
    }

    public Cookie[] getCookies() {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        return this.cookies;
    }

    public String getParameter(String name) {
        List<String> values;
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        if ((values = this.parameters.get(name)) == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public String[] getParameterValues(String name) {
        List<String> values;
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        if ((values = this.parameters.get(name)) == null) {
            return null;
        }
        return values.toArray(EMPTY_STRING_ARRAY);
    }

    public Enumeration getParameterNames() {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return new Enumerator<String>(this.parameters.keySet());
    }

    public Map getParameterMap() {
        throw new UnsupportedOperationException();
    }

    public int getContentLength() {
        try {
            String value = this.getHeader("Content-length");
            if (value == null) {
                return -1;
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getContentType() {
        return this.getHeader("Content-type");
    }

    public String getCharacterEncoding() {
        if (this.charEncoding != null) {
            return this.charEncoding;
        }
        String type = this.getContentType();
        if (type == null) {
            return null;
        }
        int semicolonIndex = -1;
        boolean hasCharset = false;
        int len = type.length();
        int index = type.indexOf(59);
        while (index != -1) {
            semicolonIndex = index++;
            while (index < len && Character.isSpace(type.charAt(index))) {
                ++index;
            }
            if (index + 8 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                hasCharset = true;
                break;
            }
            index = type.indexOf(59, index);
        }
        if (!hasCharset) {
            return null;
        }
        String tail = type.substring(index + 8);
        int nextParam = tail.indexOf(59);
        String charsetValue = null;
        charsetValue = nextParam != -1 ? tail.substring(0, nextParam) : tail;
        if (charsetValue != null && charsetValue.length() > 0) {
            this.charEncoding = charsetValue.replace('\"', ' ').trim();
        }
        return this.charEncoding;
    }

    public void setCharacterEncoding(String enc) {
        this.charEncoding = enc;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Enumeration getAttributeNames() {
        return new Enumerator(this.attributes.keySet());
    }

    private void parseCookies() {
        this.cookiesParsed = true;
        Cookies serverCookies = new Cookies(((HttpExchange)this.request).getRequestHeaders());
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        this.cookies = new Cookie[count];
        int idx = 0;
        for (int i = 0; i < count; ++i) {
            Cookie scookie = serverCookies.getCookie(i);
            try {
                Cookie cookie = new Cookie(scookie.getName(), scookie.getValue());
                cookie.setPath(scookie.getPath());
                cookie.setVersion(scookie.getVersion());
                if (scookie.getDomain() != null) {
                    cookie.setDomain(scookie.getDomain());
                }
                this.cookies[idx++] = cookie;
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (idx < count) {
            Cookie[] ncookies = new Cookie[idx];
            System.arraycopy(this.cookies, 0, ncookies, 0, idx);
            this.cookies = ncookies;
        }
    }

    private void parseParameters() {
        this.parametersParsed = true;
        this.parameters = new HashMap<String, List<String>>();
        this.parseQueryParameters();
        this.parseBodyParameters();
    }

    private void parseQueryParameters() {
        this.parseAsParameters(this.getQueryString());
    }

    private void parseBodyParameters() {
        if (this.getMethod().equals("POST")) {
            String type = this.getContentType();
            int i = type.indexOf(";");
            if (i != -1) {
                type = type.substring(0, i);
            }
            if (type.equals(APPLICATION_X_WWW_FORM_URLENCODED_MEDIA_TYPE)) {
                String enc = this.getCharacterEncoding();
                if (enc == null) {
                    enc = DEFAULT_CHARACTER_ENCODING;
                }
                StringBuilder sb = new StringBuilder();
                char[] buffer = new char[1024];
                try {
                    int len;
                    Reader r = this.getReader();
                    while ((len = r.read(buffer)) != -1) {
                        sb.append(buffer, 0, len);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                String s = sb.toString();
                try {
                    this.parseAsParameters(URLDecoder.decode(s, enc));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    private void parseAsParameters(String str) {
        int nameStart;
        int nameEnd;
        if (str == null) {
            return;
        }
        int len = str.length();
        for (int i = 0; i < len && (nameEnd = str.indexOf(61, nameStart = i)) != -1; ++i) {
            String value;
            int valEnd;
            int nextAmpersand = str.indexOf(38, nameStart);
            if (nextAmpersand != (valEnd = str.indexOf(38, nameEnd))) {
                i = nextAmpersand + 1;
                continue;
            }
            String name = str.substring(nameStart, nameEnd);
            if (valEnd == -1) {
                value = str.substring(nameEnd + 1);
                i = len;
            } else {
                value = str.substring(nameEnd + 1, valEnd);
                i = valEnd++;
            }
            this.addParameter(name, value);
        }
    }

    private void addParameter(String name, String value) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.parameters.put(name, values);
        }
        values.add(value);
    }

    private void parseRequestURI() {
        URI uri = ((HttpExchange)this.request).getRequestURI();
        this.requestURI = uri.getPath();
        this.queryString = uri.getQuery();
    }
}

