/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.simple;

import com.sun.net.httpserver.Headers;
import com.sun.phobos.container.simple.Cookie;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class Cookies {
    public static final int INITIAL_SIZE = 4;
    Cookie[] scookies = new Cookie[4];
    int cookieCount = 0;
    boolean unprocessed = true;
    Headers headers;

    public Cookies(Headers headers) {
        this.headers = headers;
    }

    public Cookies() {
    }

    public void setHeaders(Headers headers) {
        this.recycle();
        this.headers = headers;
    }

    public void recycle() {
        for (int i = 0; i < this.cookieCount; ++i) {
            if (this.scookies[i] == null) continue;
            this.scookies[i].recycle();
        }
        this.cookieCount = 0;
        this.unprocessed = true;
    }

    public Cookie getCookie(int idx) {
        if (this.unprocessed) {
            this.getCookieCount();
        }
        return this.scookies[idx];
    }

    public int getCookieCount() {
        if (this.unprocessed) {
            this.unprocessed = false;
            this.processCookies(this.headers);
        }
        return this.cookieCount;
    }

    public Cookie addCookie() {
        Cookie c;
        if (this.cookieCount >= this.scookies.length) {
            Cookie[] scookiesTmp = new Cookie[2 * this.cookieCount];
            System.arraycopy(this.scookies, 0, scookiesTmp, 0, this.cookieCount);
            this.scookies = scookiesTmp;
        }
        if ((c = this.scookies[this.cookieCount]) == null) {
            this.scookies[this.cookieCount] = c = new Cookie();
        }
        ++this.cookieCount;
        return c;
    }

    public void processCookies(Headers headers) {
        if (headers == null) {
            return;
        }
        Object cookieValues = headers.get("Cookie");
        if (cookieValues != null) {
            Iterator i$ = cookieValues.iterator();
            while (i$.hasNext()) {
                String value = (String)i$.next();
                this.processCookieHeader(value);
            }
        }
    }

    private void processCookieHeader(String cookieString) {
        StringTokenizer tok = new StringTokenizer(cookieString, ";", false);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            int i = token.indexOf("=");
            if (i <= -1) continue;
            String name = token.substring(0, i).trim();
            String value = token.substring(i + 1, token.length()).trim();
            value = Cookies.stripQuote(value);
            Cookie cookie = this.addCookie();
            cookie.setName(name);
            cookie.setValue(value);
        }
    }

    private static String stripQuote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            try {
                return value.substring(1, value.length() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }
}

