/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.simple;

import com.sun.phobos.container.simple.DateTool;
import java.text.FieldPosition;
import java.util.Date;

public class Cookie
implements Cloneable {
    private String name;
    private String value;
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private int version = 0;
    private static final String tspecials = ",; ";
    private static final String ancientDate = DateTool.formatOldCookie(new Date(10000L));

    public Cookie(String name, String value) {
        if (!Cookie.isToken(name) || name.equalsIgnoreCase("Comment") || name.equalsIgnoreCase("Discard") || name.equalsIgnoreCase("Domain") || name.equalsIgnoreCase("Expires") || name.equalsIgnoreCase("Max-Age") || name.equalsIgnoreCase("Path") || name.equalsIgnoreCase("Secure") || name.equalsIgnoreCase("Version") || name.startsWith("$")) {
            throw new IllegalArgumentException("invalid cookie name");
        }
        this.name = name;
        this.value = value;
    }

    public Cookie() {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String purpose) {
        this.comment = purpose;
    }

    public String getComment() {
        return this.comment;
    }

    public void setDomain(String pattern) {
        this.domain = pattern.toLowerCase();
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(int expiry) {
        this.maxAge = expiry;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String uri) {
        this.path = uri;
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    private static boolean isToken(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public void recycle() {
        this.path = null;
        this.name = null;
        this.value = null;
        this.comment = null;
        this.maxAge = -1;
        this.domain = null;
        this.version = 0;
        this.secure = false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String getCookieHeaderName() {
        return Cookie.getCookieHeaderName(this.version);
    }

    public static String getCookieHeaderName(int version) {
        if (version == 1) {
            return "Set-Cookie";
        }
        return "Set-Cookie";
    }

    public static void appendCookieValue(StringBuffer buf, int version, String name, String value, String path, String domain, String comment, int maxAge, boolean isSecure) {
        buf.append(name);
        buf.append("=");
        Cookie.maybeQuote(version, buf, value);
        if (version == 1) {
            buf.append("; Version=1");
            if (comment != null) {
                buf.append("; Comment=");
                Cookie.maybeQuote(version, buf, comment);
            }
        }
        if (domain != null) {
            buf.append("; Domain=");
            Cookie.maybeQuote(version, buf, domain);
        }
        if (maxAge >= 0) {
            if (version == 0) {
                buf.append("; Expires=");
                if (maxAge == 0) {
                    buf.append(ancientDate);
                } else {
                    DateTool.formatOldCookie(new Date(System.currentTimeMillis() + (long)maxAge * 1000L), buf, new FieldPosition(0));
                }
            } else {
                buf.append("; Max-Age=");
                buf.append(maxAge);
            }
        }
        if (path != null) {
            buf.append("; Path=");
            Cookie.maybeQuote(version, buf, path);
        }
        if (isSecure) {
            buf.append("; Secure");
        }
    }

    public static void maybeQuote(int version, StringBuffer buf, String value) {
        if (Cookie.isToken(value)) {
            buf.append(value);
        } else {
            if (version == 0) {
                throw new IllegalArgumentException(value);
            }
            buf.append('\"');
            buf.append(value);
            buf.append('\"');
        }
    }
}

