/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.grizzly.impl;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.phobos.container.grizzly.impl.Constants;
import com.sun.phobos.container.grizzly.impl.GrizzlyInputBuffer;
import com.sun.phobos.container.grizzly.impl.GrizzlyInputStream;
import com.sun.phobos.container.grizzly.impl.GrizzlyReader;
import com.sun.phobos.container.grizzly.impl.GrizzlyResponse;
import com.sun.phobos.container.grizzly.impl.util.Cookie;
import com.sun.phobos.container.grizzly.impl.util.Enumerator;
import com.sun.phobos.container.grizzly.impl.util.ParameterMap;
import com.sun.phobos.container.grizzly.impl.util.StringParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.security.auth.Subject;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Request;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.Parameters;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.res.StringManager;

public class GrizzlyRequest {
    protected Request coyoteRequest;
    protected static StringManager sm = StringManager.getManager((String)"com.sun.phobos.container.grizzly.impl");
    private static final Log log = LogFactory.getLog(GrizzlyRequest.class);
    protected Cookie[] cookies = null;
    private static ThreadLocal staticDateFormats = new ThreadLocal(){

        protected Object initialValue() {
            SimpleDateFormat[] f = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
            return f;
        }
    };
    protected SimpleDateFormat[] formats;
    protected static Locale defaultLocale = Locale.getDefault();
    protected HashMap attributes = new HashMap();
    private HashMap readOnlyAttributes = new HashMap();
    protected ArrayList locales = new ArrayList();
    private transient HashMap notes = new HashMap();
    protected String authType = null;
    protected Object dispatcherType = null;
    protected GrizzlyInputBuffer inputBuffer = new GrizzlyInputBuffer();
    protected GrizzlyInputStream inputStream = new GrizzlyInputStream(this.inputBuffer);
    protected GrizzlyReader reader = new GrizzlyReader(this.inputBuffer);
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    protected Principal userPrincipal = null;
    protected boolean sessionParsed = false;
    protected boolean requestParametersParsed = false;
    protected boolean cookiesParsed = false;
    protected boolean secure = false;
    protected Subject subject = null;
    protected static int CACHED_POST_LEN = 8192;
    protected byte[] postData = null;
    protected ParameterMap parameterMap = new ParameterMap();
    protected Object requestDispatcherPath = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected boolean requestedSessionURL = false;
    protected Socket socket = null;
    protected boolean localesParsed = false;
    private StringParser parser = new StringParser();
    protected int localPort = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected int remotePort = -1;
    protected String localName = null;
    protected String localAddr = null;
    private int dispatchDepth = 0;
    private static int maxDispatchDepth = 20;
    private String jrouteId;
    protected GrizzlyResponse response = null;
    protected B2CConverter URIConverter = null;

    public GrizzlyRequest() {
        this.formats = (SimpleDateFormat[])staticDateFormats.get();
        this.formats[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[1].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[2].setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void setRequest(Request coyoteRequest) {
        this.coyoteRequest = coyoteRequest;
        this.inputBuffer.setRequest(coyoteRequest);
    }

    public Request getRequest() {
        return this.coyoteRequest;
    }

    public GrizzlyResponse getResponse() {
        return this.response;
    }

    public void setResponse(GrizzlyResponse response) {
        this.response = response;
    }

    public void recycle() {
        this.dispatcherType = null;
        this.requestDispatcherPath = null;
        this.authType = null;
        this.inputBuffer.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
        this.userPrincipal = null;
        this.subject = null;
        this.sessionParsed = false;
        this.requestParametersParsed = false;
        this.cookiesParsed = false;
        this.locales.clear();
        this.localesParsed = false;
        this.secure = false;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
        this.attributes.clear();
        this.notes.clear();
        this.cookies = null;
        this.dispatchDepth = 0;
        this.parameterMap.setLocked(false);
        this.parameterMap.clear();
        if (Constants.SECURITY) {
            if (this.inputStream != null) {
                this.inputStream.clear();
                this.inputStream = null;
            }
            if (this.reader != null) {
                this.reader.clear();
                this.reader = null;
            }
        }
    }

    public String getAuthorization() {
        return this.coyoteRequest.getHeader("authorization");
    }

    public void setAuthorization(String authorization) {
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
        this.remoteHost = null;
        this.remoteAddr = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
    }

    public InputStream getStream() {
        if (this.inputStream == null) {
            this.inputStream = new GrizzlyInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public void setStream(InputStream stream) {
    }

    protected B2CConverter getURIConverter() {
        return this.URIConverter;
    }

    protected void setURIConverter(B2CConverter URIConverter) {
        this.URIConverter = URIConverter;
    }

    public GrizzlyInputStream createInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new GrizzlyInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public void finishRequest() throws IOException {
    }

    public Object getNote(String name) {
        return this.notes.get(name);
    }

    public Iterator getNoteNames() {
        return this.notes.keySet().iterator();
    }

    public void removeNote(String name) {
        this.notes.remove(name);
    }

    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    public void setContentLength(int length) {
    }

    public void setContentType(String type) {
    }

    public void setProtocol(String protocol) {
    }

    public void setRemoteAddr(String remoteAddr) {
    }

    public void setRemoteHost(String remoteHost) {
    }

    public void setScheme(String scheme) {
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setServerName(String name) {
        this.coyoteRequest.serverName().setString(name);
    }

    public void setServerPort(int port) {
        this.coyoteRequest.setServerPort(port);
    }

    public Object getAttribute(String name) {
        Object attr = this.attributes.get(name);
        if (attr != null) {
            return attr;
        }
        attr = this.coyoteRequest.getAttribute(name);
        if (attr != null) {
            return attr;
        }
        if ("org.apache.coyote.request.X509Certificate".equals(name)) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_SSL_CERTIFICATE, null);
            attr = this.getAttribute("javax.servlet.request.X509Certificate");
            if (attr != null) {
                this.attributes.put(name, attr);
            }
        } else if (GrizzlyRequest.isSSLAttribute(name)) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_SSL_ATTRIBUTE, (Object)this.coyoteRequest);
            attr = this.coyoteRequest.getAttribute("javax.servlet.request.X509Certificate");
            if (attr != null) {
                this.attributes.put("javax.servlet.request.X509Certificate", attr);
            }
            if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.cipher_suite")) != null) {
                this.attributes.put("javax.servlet.request.cipher_suite", attr);
            }
            if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.key_size")) != null) {
                this.attributes.put("javax.servlet.request.key_size", attr);
            }
            attr = this.attributes.get(name);
        }
        return attr;
    }

    static boolean isSSLAttribute(String name) {
        return "javax.servlet.request.X509Certificate".equals(name) || "javax.servlet.request.cipher_suite".equals(name) || "javax.servlet.request.key_size".equals(name);
    }

    public Enumeration getAttributeNames() {
        return new Enumerator(this.attributes.keySet(), true);
    }

    public String getCharacterEncoding() {
        return this.coyoteRequest.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.coyoteRequest.getContentLength();
    }

    public String getContentType() {
        return this.coyoteRequest.getContentType();
    }

    public GrizzlyInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getInputStream.ise"));
        }
        this.usingInputStream = true;
        if (this.inputStream == null) {
            this.inputStream = new GrizzlyInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public Locale getLocale() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return (Locale)this.locales.get(0);
        }
        return defaultLocale;
    }

    public Enumeration getLocales() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return new Enumerator(this.locales);
        }
        ArrayList<Locale> results = new ArrayList<Locale>();
        results.add(defaultLocale);
        return new Enumerator(results);
    }

    public String getParameter(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.coyoteRequest.getParameters().getParameter(name);
    }

    public Map getParameterMap() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            String[] values = this.getParameterValues(name);
            this.parameterMap.put(name, values);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.coyoteRequest.getParameters().getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.coyoteRequest.getParameters().getParameterValues(name);
    }

    public String getProtocol() {
        return this.coyoteRequest.protocol().toString();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getReader.ise"));
        }
        this.usingReader = true;
        this.inputBuffer.checkConverter();
        if (this.reader == null) {
            this.reader = new GrizzlyReader(this.inputBuffer);
        }
        return this.reader;
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteAddr = inet.getHostAddress();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE, (Object)this.coyoteRequest);
                this.remoteAddr = this.coyoteRequest.remoteAddr().toString();
            }
        }
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteHost = inet.getHostName();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_HOST_ATTRIBUTE, (Object)this.coyoteRequest);
                this.remoteHost = this.coyoteRequest.remoteHost().toString();
            }
        }
        return this.remoteHost;
    }

    public int getRemotePort() {
        if (this.remotePort == -1) {
            if (this.socket != null) {
                this.remotePort = this.socket.getPort();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE, (Object)this.coyoteRequest);
                this.remotePort = this.coyoteRequest.getRemotePort();
            }
        }
        return this.remotePort;
    }

    public String getLocalName() {
        if (this.localName == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getLocalAddress();
                this.localName = inet.getHostName();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE, (Object)this.coyoteRequest);
                this.localName = this.coyoteRequest.localName().toString();
            }
        }
        return this.localName;
    }

    public String getLocalAddr() {
        if (this.localAddr == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getLocalAddress();
                this.localAddr = inet.getHostAddress();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE, (Object)this.coyoteRequest);
                this.localAddr = this.coyoteRequest.localAddr().toString();
            }
        }
        return this.localAddr;
    }

    public int getLocalPort() {
        if (this.localPort == -1) {
            if (this.socket != null) {
                this.localPort = this.socket.getLocalPort();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE, (Object)this.coyoteRequest);
                this.localPort = this.coyoteRequest.getLocalPort();
            }
        }
        return this.localPort;
    }

    public String getScheme() {
        return this.coyoteRequest.scheme().toString();
    }

    public String getServerName() {
        return this.coyoteRequest.serverName().toString();
    }

    public int getServerPort() {
        return this.coyoteRequest.getServerPort();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void removeAttribute(String name) {
        Object value = null;
        boolean found = false;
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        found = this.attributes.containsKey(name);
        if (!found) {
            return;
        }
        value = this.attributes.get(name);
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("coyoteRequest.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherType = value;
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value;
            return;
        }
        Object oldValue = null;
        boolean replaced = false;
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        oldValue = this.attributes.put(name, value);
        if (oldValue != null) {
            replaced = true;
        }
        if (name.startsWith("grizzly.")) {
            this.coyoteRequest.setAttribute(name, value);
        }
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.requestParametersParsed || this.usingReader) {
            log.warn((Object)sm.getString("coyoteRequest.setCharacterEncoding.ise", (Object)enc));
            return;
        }
        byte[] buffer = new byte[]{97};
        final byte[] finalBuffer = buffer;
        final String finalEnc = enc;
        String dummy = null;
        if (System.getSecurityManager() != null) {
            try {
                dummy = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnsupportedEncodingException {
                        return new String(finalBuffer, finalEnc);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (UnsupportedEncodingException)pae.getCause();
            }
        } else {
            dummy = new String(buffer, enc);
        }
        this.coyoteRequest.setCharacterEncoding(enc);
    }

    public static void setMaxDispatchDepth(int depth) {
        maxDispatchDepth = depth;
    }

    public static int getMaxDispatchDepth() {
        return maxDispatchDepth;
    }

    public int incrementDispatchDepth() {
        return ++this.dispatchDepth;
    }

    public int decrementDispatchDepth() {
        return --this.dispatchDepth;
    }

    public boolean isMaxDispatchDepthReached() {
        return this.dispatchDepth > maxDispatchDepth;
    }

    public void addCookie(Cookie cookie) {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        int size = 0;
        if (cookie != null) {
            size = this.cookies.length;
        }
        Cookie[] newCookies = new Cookie[size + 1];
        for (int i = 0; i < size; ++i) {
            newCookies[i] = this.cookies[i];
        }
        newCookies[size] = cookie;
        this.cookies = newCookies;
    }

    public void addHeader(String name, String value) {
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void addParameter(String name, String[] values) {
        this.coyoteRequest.getParameters().addParameterValues(name, values);
    }

    public void clearCookies() {
        this.cookiesParsed = true;
        this.cookies = null;
    }

    public void clearHeaders() {
    }

    public void clearLocales() {
        this.locales.clear();
    }

    public void clearParameters() {
    }

    public void setAuthType(String type) {
        this.authType = type;
    }

    public void setMethod(String method) {
    }

    public void setQueryString(String query) {
    }

    public void setRequestURI(String uri) {
    }

    public void setDecodedRequestURI(String uri) {
    }

    public String getDecodedRequestURI() {
        return this.coyoteRequest.decodedURI().toString();
    }

    public MessageBytes getDecodedRequestURIMB() {
        return this.coyoteRequest.decodedURI();
    }

    public void setUserPrincipal(Principal principal) {
        this.userPrincipal = principal;
    }

    public String getAuthType() {
        return this.authType;
    }

    public Cookie[] getCookies() {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = FastHttpDateFormat.parseDate((String)value, (DateFormat[])this.formats);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    public String getHeader(String name) {
        return this.coyoteRequest.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.coyoteRequest.getMimeHeaders().values(name);
    }

    public Enumeration getHeaderNames() {
        return this.coyoteRequest.getMimeHeaders().names();
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getMethod() {
        return this.coyoteRequest.method().toString();
    }

    public String getQueryString() {
        String queryString = this.coyoteRequest.queryString().toString();
        if (queryString == null || queryString.equals("")) {
            return null;
        }
        return queryString;
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.coyoteRequest.requestURI().toString();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    protected void parseCookies() {
        this.cookiesParsed = true;
        Cookies serverCookies = this.coyoteRequest.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        this.cookies = new Cookie[count];
        int idx = 0;
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            try {
                Cookie cookie = new Cookie(scookie.getName().toString(), scookie.getValue().toString());
                cookie.setPath(scookie.getPath().toString());
                cookie.setVersion(scookie.getVersion());
                String domain = scookie.getDomain().toString();
                if (domain != null) {
                    cookie.setDomain(scookie.getDomain().toString());
                }
                this.cookies[idx++] = cookie;
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (idx < count) {
            Cookie[] ncookies = new Cookie[idx];
            System.arraycopy(this.cookies, 0, ncookies, 0, idx);
            this.cookies = ncookies;
        }
    }

    protected void parseRequestParameters() {
        int semicolon;
        Parameters parameters = this.coyoteRequest.getParameters();
        String enc = this.getCharacterEncoding();
        this.requestParametersParsed = true;
        if (enc != null) {
            parameters.setEncoding(enc);
            parameters.setQueryStringEncoding(enc);
        } else {
            parameters.setEncoding("ISO-8859-1");
            parameters.setQueryStringEncoding("ISO-8859-1");
        }
        parameters.handleQueryParameters();
        if (this.usingInputStream || this.usingReader) {
            return;
        }
        if (!this.getMethod().equalsIgnoreCase("POST")) {
            return;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if (!"application/x-www-form-urlencoded".equals(contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim())) {
            return;
        }
        int len = this.getContentLength();
        if (len > 0) {
            try {
                byte[] formData = this.getPostBody();
                if (formData != null) {
                    parameters.processParameters(formData, 0, len);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    protected byte[] getPostBody() throws IOException {
        int len = this.getContentLength();
        byte[] formData = null;
        if (len < CACHED_POST_LEN) {
            if (this.postData == null) {
                this.postData = new byte[CACHED_POST_LEN];
            }
            formData = this.postData;
        } else {
            formData = new byte[len];
        }
        int actualLen = this.readPostBody(formData, len);
        if (actualLen == len) {
            return formData;
        }
        return null;
    }

    protected int readPostBody(byte[] body, int len) throws IOException {
        int inputLen;
        int offset = 0;
        do {
            if ((inputLen = this.getStream().read(body, offset, len - offset)) > 0) continue;
            return offset;
        } while (len - (offset += inputLen) > 0);
        return len;
    }

    protected void parseLocales() {
        this.localesParsed = true;
        Enumeration values = this.getHeaders("accept-language");
        while (values.hasMoreElements()) {
            String value = values.nextElement().toString();
            this.parseLocalesHeader(value);
        }
    }

    protected void parseLocalesHeader(String value) {
        int start;
        TreeMap<Double, ArrayList<Locale>> locales = new TreeMap<Double, ArrayList<Locale>>();
        int white = value.indexOf(32);
        if (white < 0) {
            white = value.indexOf(9);
        }
        if (white >= 0) {
            StringBuffer sb = new StringBuffer();
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                if (ch == ' ' || ch == '\t') continue;
                sb.append(ch);
            }
            value = sb.toString();
        }
        this.parser.setString(value);
        int length = this.parser.getLength();
        while ((start = this.parser.getIndex()) < length) {
            int end = this.parser.findChar(',');
            String entry = this.parser.extract(start, end).trim();
            this.parser.advance();
            double quality = 1.0;
            int semi = entry.indexOf(";q=");
            if (semi >= 0) {
                try {
                    quality = Double.parseDouble(entry.substring(semi + 3));
                }
                catch (NumberFormatException e) {
                    quality = 0.0;
                }
                entry = entry.substring(0, semi);
            }
            if (quality < 5.0E-5 || "*".equals(entry)) continue;
            String language = null;
            String country = null;
            String variant = null;
            int dash = entry.indexOf(45);
            if (dash < 0) {
                language = entry;
                country = "";
                variant = "";
            } else {
                language = entry.substring(0, dash);
                country = entry.substring(dash + 1);
                int vDash = country.indexOf(45);
                if (vDash > 0) {
                    String cTemp = country.substring(0, vDash);
                    variant = country.substring(vDash + 1);
                    country = cTemp;
                } else {
                    variant = "";
                }
            }
            Locale locale = new Locale(language, country, variant);
            Double key = new Double(-quality);
            ArrayList<Locale> values = (ArrayList<Locale>)locales.get(key);
            if (values == null) {
                values = new ArrayList<Locale>();
                locales.put(key, values);
            }
            values.add(locale);
        }
        for (Double key : locales.keySet()) {
            ArrayList list = (ArrayList)locales.get(key);
            for (Locale locale : list) {
                this.addLocale(locale);
            }
        }
    }

    void parseJrouteCookie() {
        Cookies serverCookies = this.coyoteRequest.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            if (!scookie.getName().equals("JROUTE")) continue;
            this.setJrouteId(scookie.getValue().toString());
            break;
        }
    }

    void setJrouteId(String jrouteId) {
        this.jrouteId = jrouteId;
    }

    public String getJrouteId() {
        return this.jrouteId;
    }
}

