/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.grizzly;

import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.phobos.container.AbstractMain;
import com.sun.phobos.container.grizzly.GrizzlyPhobosAdapter;
import java.util.Properties;
import org.apache.coyote.Adapter;

public class Main
extends AbstractMain {
    protected SelectorThread selectorThread;
    protected GrizzlyPhobosAdapter adapter;

    public static void main(String[] args) {
        try {
            final Main main = new Main();
            Thread thread = new Thread(){

                public void run() {
                    try {
                        main.start();
                    }
                    catch (Exception e) {
                        main.log(e);
                    }
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                main.log(e);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Main() {
    }

    public Main(Properties properties) {
        super(properties);
    }

    public void start() {
        String baseDir = this.getBaseDir();
        String scratchDir = this.getScratchDir();
        int portNumber = this.getPortNumber();
        this.selectorThread = new SelectorThread();
        this.selectorThread.setPort(portNumber);
        this.adapter = this.createAdapter();
        this.adapter.setScratchDirectoryName(scratchDir);
        this.adapter.setResourceService(this.getResourceService());
        this.adapter.setProperties(this.properties);
        this.adapter.setLogWriter(this.getLogWriter());
        this.maybeCreateDebugger();
        this.adapter.setDebugger(this.debugger);
        this.adapter.startup(baseDir);
        this.selectorThread.setAdapter((Adapter)this.adapter);
        Thread thread = new Thread(){

            public void run() {
                try {
                    Main.this.selectorThread.initEndpoint();
                    Main.this.selectorThread.startEndpoint();
                }
                catch (Exception e) {
                    Main.this.log(e);
                }
            }
        };
        thread.start();
        while (!this.selectorThread.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
    }

    public void stop(int delay) {
        this.adapter.shutdown();
        this.selectorThread.stopEndpoint();
        while (this.selectorThread.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected GrizzlyPhobosAdapter createAdapter() {
        return new GrizzlyPhobosAdapter();
    }
}

