/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.debug;

import com.sun.phobos.container.debug.ComplexDebugObjectImpl;
import com.sun.phobos.container.debug.DebugScriptImpl;
import com.sun.phobos.container.debug.DebuggerContextImpl;
import com.sun.phobos.container.debug.DebuggerImpl;
import com.sun.phobos.container.debug.ExceptionThrownDebugEventImpl;
import com.sun.phobos.container.debug.FrameEnteredDebugEventImpl;
import com.sun.phobos.container.debug.FrameExitedDebugEventImpl;
import com.sun.phobos.container.debug.LineChangedDebugEventImpl;
import com.sun.phobos.debug.DebugFrame;
import com.sun.phobos.debug.DebugObject;
import com.sun.phobos.debug.DebugScript;
import java.util.Iterator;
import java.util.LinkedList;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebuggableScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugFrameImpl
implements DebugFrame,
org.mozilla.javascript.debug.DebugFrame {
    private DebuggableScript fnOrScript;
    private DebugObject activation;
    private DebugObject thisObj;
    private String sourceFile;
    private int lineNumber;
    private DebugScript debugScript;
    private Context context;

    public DebugFrameImpl(DebuggableScript fnOrScript) {
        this.fnOrScript = fnOrScript;
        this.sourceFile = fnOrScript.getSourceName();
        this.lineNumber = -1;
        this.debugScript = new DebugScriptImpl(fnOrScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
        LinkedList<DebugFrame> callStack;
        LinkedList<DebugFrame> linkedList = callStack = this.getCallStack(cx);
        synchronized (linkedList) {
            callStack.addFirst(this);
        }
        DebuggerContextImpl debuggerContext = this.getDebuggerContext(cx);
        this.context = cx;
        this.activation = debuggerContext.createDebugObject(activation);
        this.thisObj = debuggerContext.createDebugObject(thisObj);
        this.lineNumber = this.findLowestLineNumber();
        debuggerContext.fireDebugEvent(new FrameEnteredDebugEventImpl(debuggerContext, this, args, this.lineNumber));
    }

    public void onLineChange(Context cx, int lineNumber) {
        this.lineNumber = lineNumber;
        DebuggerContextImpl debuggerContext = this.getDebuggerContext(cx);
        debuggerContext.fireDebugEvent(new LineChangedDebugEventImpl(this.getDebuggerContext(cx), this, lineNumber));
    }

    public void onExceptionThrown(Context cx, Throwable ex) {
        DebuggerContextImpl debuggerContext = this.getDebuggerContext(cx);
        debuggerContext.fireDebugEvent(new ExceptionThrownDebugEventImpl(this.getDebuggerContext(cx), this, ex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExit(Context cx, boolean byThrow, Object resultOrException) {
        LinkedList<DebugFrame> callStack;
        LinkedList<DebugFrame> linkedList = callStack = this.getCallStack(cx);
        synchronized (linkedList) {
            Iterator iterator = callStack.iterator();
            while (iterator.hasNext()) {
                DebugFrame frame = (DebugFrame)iterator.next();
                if (frame != this) continue;
                iterator.remove();
                break;
            }
        }
        DebuggerContextImpl debuggerContext = this.getDebuggerContext(cx);
        debuggerContext.fireDebugEvent(new FrameExitedDebugEventImpl(debuggerContext, this, byThrow, resultOrException));
        this.context = null;
        this.activation = null;
        this.thisObj = null;
        this.lineNumber = -1;
    }

    public DebugObject getActivation() {
        return this.activation;
    }

    public DebugObject getThisObject() {
        return this.thisObj;
    }

    public DebugObject evaluate(final String expr) {
        if (this.context == null) {
            throw new IllegalStateException("frame is inactive");
        }
        DebuggerContextImpl debuggerContext = this.getDebuggerContext(this.context);
        Object value = Undefined.instance;
        try {
            final Scriptable actualThisObj = this.thisObj instanceof ComplexDebugObjectImpl ? ((ComplexDebugObjectImpl)this.thisObj).getScriptable() : null;
            final Scriptable actualActivation = this.activation instanceof ComplexDebugObjectImpl ? ((ComplexDebugObjectImpl)this.activation).getScriptable() : null;
            value = debuggerContext.performInContext(new java.util.concurrent.Callable<Object>(){

                @Override
                public Object call() {
                    Script script = DebugFrameImpl.this.context.compileString(expr, "", 0, null);
                    if (script instanceof Callable) {
                        return ((Callable)script).call(DebugFrameImpl.this.context, actualActivation, actualThisObj, ScriptRuntime.emptyArgs);
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            value = Undefined.instance;
        }
        return debuggerContext.createDebugObject(value);
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public DebugScript getDebugScript() {
        return this.debugScript;
    }

    protected DebuggerImpl getDebugger(Context cx) {
        return (DebuggerImpl)cx.getDebugger();
    }

    protected DebuggerContextImpl getDebuggerContext(Context cx) {
        return (DebuggerContextImpl)cx.getDebuggerContextData();
    }

    protected LinkedList<DebugFrame> getCallStack(Context cx) {
        DebuggerContextImpl context = this.getDebuggerContext(cx);
        return context.getCallStack();
    }

    protected int findLowestLineNumber() {
        int[] lineNumbers = this.fnOrScript.getLineNumbers();
        int result = Integer.MAX_VALUE;
        for (int i = 0; i < lineNumbers.length; ++i) {
            if (lineNumbers[i] >= result) continue;
            result = lineNumbers[i];
        }
        if (result == Integer.MAX_VALUE) {
            result = -1;
        }
        return result;
    }
}

