/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container;

import com.sun.phobos.container.ResourceService;
import com.sun.phobos.container.debug.DebuggerImpl;
import com.sun.phobos.script.javascript.EmbeddedRhinoScriptEngineFactory;
import com.sun.phobos.script.javascript.RhinoScriptEngineFactory;
import com.sun.phobos.script.util.ScriptEnginePool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptingService {
    private List<ScriptEngineFactory> factories;
    private Map<ScriptEngineFactory, ScriptEnginePool> pools;
    private SortedSet<String> extensions;
    private Map<String, ScriptEngineFactory> extensionToFactoryMap;
    private ResourceService resourceService;
    private Map<ScriptEngine, Map<String, CompiledScriptInfo>> compiledScriptCache;
    private DebuggerImpl debugger;
    private Properties properties;
    private boolean flag_POOL_ENGINES;
    private boolean flag_COMPILE_SCRIPTS;
    private boolean flag_REUSE_ENGINES_PER_THREAD;
    private RhinoScriptEngineFactory rhinoFactory;
    private static ThreadLocal<Map<ScriptEngineFactory, CachedFactoryEntry>> cachedFactories = new ThreadLocal();

    public void initialize() {
        this.flag_POOL_ENGINES = !"false".equals(this.getProperty("com.sun.phobos.container.poolEngines"));
        this.flag_COMPILE_SCRIPTS = !"false".equals(this.getProperty("com.sun.phobos.container.compileScripts"));
        this.flag_REUSE_ENGINES_PER_THREAD = !"false".equals(this.getProperty("com.sun.phobos.container.reuseEnginesPerThread"));
        this.extensionToFactoryMap = new HashMap<String, ScriptEngineFactory>();
        this.factories = new ArrayList<ScriptEngineFactory>();
        this.rhinoFactory = new RhinoScriptEngineFactory(this.debugger != null ? this.debugger.getContextFactoryListener() : null);
        this.rhinoFactory.setProperties(this.properties);
        this.rhinoFactory.initialize();
        this.factories.add((ScriptEngineFactory)this.rhinoFactory);
        EmbeddedRhinoScriptEngineFactory embeddedRhinoFactory = new EmbeddedRhinoScriptEngineFactory();
        embeddedRhinoFactory.setProperties(this.properties);
        this.factories.add((ScriptEngineFactory)embeddedRhinoFactory);
        if (this.flag_POOL_ENGINES) {
            this.pools = new HashMap<ScriptEngineFactory, ScriptEnginePool>();
        }
        this.extensions = new TreeSet<String>();
        for (ScriptEngineFactory factory : this.factories) {
            for (String ext : factory.getExtensions()) {
                if (this.extensions.contains(ext)) continue;
                this.extensions.add(ext);
                this.extensionToFactoryMap.put(ext, factory);
            }
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        List<ScriptEngineFactory> otherFactories = manager.getEngineFactories();
        for (ScriptEngineFactory factory : otherFactories) {
            boolean added = false;
            for (String ext : factory.getExtensions()) {
                if (this.extensions.contains(ext)) continue;
                this.extensions.add(ext);
                this.extensionToFactoryMap.put(ext, factory);
                if (added) continue;
                this.factories.add(factory);
                added = true;
            }
        }
        this.extensions = Collections.unmodifiableSortedSet(this.extensions);
        this.factories = Collections.unmodifiableList(this.factories);
        if (this.flag_COMPILE_SCRIPTS) {
            this.compiledScriptCache = new WeakHashMap<ScriptEngine, Map<String, CompiledScriptInfo>>();
        }
    }

    public void destroy() {
        if (this.rhinoFactory != null) {
            this.rhinoFactory.destroy();
            this.rhinoFactory = null;
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected String getProperty(String key) {
        String value = null;
        if (this.properties != null) {
            value = this.properties.getProperty(key);
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    protected String getProperty(String name, String defaultValue) {
        String s = this.getProperty(name);
        return s == null ? defaultValue : s;
    }

    public void setDebugger(DebuggerImpl debugger) {
        this.debugger = debugger;
    }

    public List<ScriptEngineFactory> getEngineFactories() {
        return this.factories;
    }

    public SortedSet<String> getExtensions() {
        return this.extensions;
    }

    public ScriptEngine acquireEngine(String extension) {
        ScriptEngineFactory factory = this.getFactoryForExtension(extension);
        if (factory == null) {
            return null;
        }
        return this.acquireEngine(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngine acquireEngine(ScriptEngineFactory factory) {
        Object entry;
        if (this.flag_REUSE_ENGINES_PER_THREAD) {
            Map<ScriptEngineFactory, CachedFactoryEntry> cache = cachedFactories.get();
            if (cache == null) {
                cache = new HashMap<ScriptEngineFactory, CachedFactoryEntry>();
                cachedFactories.set(cache);
            }
            if (factory instanceof RhinoScriptEngineFactory && (entry = cache.get(factory)) != null) {
                ((CachedFactoryEntry)entry).acquire();
                return ((CachedFactoryEntry)entry).getEngine();
            }
        }
        ScriptEngine engine = null;
        if (this.flag_POOL_ENGINES) {
            entry = this;
            synchronized (entry) {
                ScriptEnginePool pool = this.pools.get(factory);
                if (pool != null) {
                    engine = pool.checkOut();
                } else {
                    pool = new ScriptEnginePool(factory);
                    this.pools.put(factory, pool);
                    engine = pool.checkOut();
                }
            }
        } else {
            engine = factory.getScriptEngine();
        }
        if (this.flag_REUSE_ENGINES_PER_THREAD) {
            Map<ScriptEngineFactory, CachedFactoryEntry> cache = cachedFactories.get();
            if (engine.getFactory().equals(factory)) {
                CachedFactoryEntry entry2 = new CachedFactoryEntry(factory, engine);
                cache.put(factory, entry2);
            }
        }
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEngine(ScriptEngine engine) {
        CachedFactoryEntry entry;
        ScriptEngineFactory factory;
        Map<ScriptEngineFactory, CachedFactoryEntry> cache;
        if (engine == null) {
            return;
        }
        if (this.flag_REUSE_ENGINES_PER_THREAD && (cache = cachedFactories.get()) != null && (factory = engine.getFactory()) instanceof RhinoScriptEngineFactory && (entry = cache.get(factory)) != null && entry.getEngine().equals(engine)) {
            int count = entry.release();
            if (count > 0) {
                return;
            }
            cache.remove(factory);
        }
        if (this.flag_POOL_ENGINES) {
            ScriptingService scriptingService = this;
            synchronized (scriptingService) {
                ScriptEnginePool pool = this.pools.get(engine.getFactory());
                if (pool != null) {
                    pool.checkIn(engine);
                }
            }
        }
    }

    public ScriptEngineFactory getFactoryForExtension(String extension) {
        return this.extensionToFactoryMap.get(extension);
    }

    public Object evalScript(String resourcePath, ScriptContext context) throws ScriptException {
        String extension = ScriptingService.getExtension(resourcePath);
        if (extension == null || extension.length() == 0) {
            throw new ScriptException("no extension found, cannot determine engine to use");
        }
        ScriptEngineFactory factory = this.getFactoryForExtension(extension);
        if (factory == null) {
            throw new ScriptException("cannot find engine for extension: " + extension);
        }
        return this.evalScript(resourcePath, context, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object evalScript(String resourcePath, ScriptContext context, ScriptEngineFactory factory) throws ScriptException {
        Object object;
        InputStream stream;
        ScriptEngine engine;
        block36: {
            engine = null;
            stream = null;
            engine = this.acquireEngine(factory);
            if (engine == null) {
                throw new ScriptException("cannot find engine");
            }
            if (this.flag_POOL_ENGINES && this.flag_COMPILE_SCRIPTS && engine instanceof Compilable) {
                Map<ScriptEngine, Map<String, CompiledScriptInfo>> map = this.compiledScriptCache;
                // MONITORENTER : map
                Map<String, CompiledScriptInfo> cache = this.compiledScriptCache.get(engine);
                // MONITOREXIT : map
                if (cache == null) {
                    cache = new WeakHashMap<String, CompiledScriptInfo>();
                    map = this.compiledScriptCache;
                    // MONITORENTER : map
                    this.compiledScriptCache.put(engine, cache);
                    // MONITOREXIT : map
                }
                CompiledScriptInfo info = cache.get(resourcePath);
                CompiledScript script = null;
                long lastModified = this.resourceService.getLastModified(resourcePath);
                if (info != null && lastModified <= info.getTimestamp()) {
                    script = info.getCompiledScript();
                }
                if (script == null) {
                    try {
                        stream = this.resourceService.getResourceAsStream(resourcePath);
                    }
                    catch (IOException e) {
                        throw new ScriptException("cannot find resource " + resourcePath);
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                    String filename = (String)engine.get("javax.script.filename");
                    try {
                        engine.put("javax.script.filename", resourcePath);
                        script = ((Compilable)((Object)engine)).compile(reader);
                        info = new CompiledScriptInfo(resourcePath, lastModified, script);
                        cache.put(resourcePath, info);
                    }
                    finally {
                        engine.put("javax.script.filename", filename);
                    }
                }
                Object savedFilename = context.getBindings(100).get("javax.script.filename");
                try {
                    context.getBindings(100).put("javax.script.filename", (Object)resourcePath);
                    Object object2 = script.eval(context);
                    return object2;
                }
                finally {
                    context.getBindings(100).put("javax.script.filename", savedFilename);
                }
            }
            stream = this.resourceService.getResourceAsStream(resourcePath);
            break block36;
            catch (IOException e) {
                throw new ScriptException("cannot find resource " + resourcePath);
            }
        }
        if (stream == null) {
            throw new ScriptException("cannot find resource " + resourcePath);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        Object savedFilename = context.getBindings(100).get("javax.script.filename");
        try {
            context.getBindings(100).put("javax.script.filename", (Object)resourcePath);
            object = engine.eval((Reader)reader, context);
            context.getBindings(100).put("javax.script.filename", savedFilename);
        }
        catch (Throwable throwable) {
            context.getBindings(100).put("javax.script.filename", savedFilename);
            throw throwable;
        }
        return object;
        finally {
            if (engine != null) {
                this.releaseEngine(engine);
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalScriptSource(String source, ScriptContext context, ScriptEngineFactory factory, String resourceIdentifier) throws ScriptException {
        Object object;
        ScriptEngine engine = null;
        Reader reader = null;
        engine = this.acquireEngine(factory);
        if (engine == null) {
            throw new ScriptException("cannot find engine");
        }
        if (this.flag_POOL_ENGINES && this.flag_COMPILE_SCRIPTS && engine instanceof Compilable) {
            Map<String, CompiledScriptInfo> cache;
            Map<ScriptEngine, Map<String, CompiledScriptInfo>> map = this.compiledScriptCache;
            synchronized (map) {
                cache = this.compiledScriptCache.get(engine);
            }
            if (cache == null) {
                cache = new WeakHashMap<String, CompiledScriptInfo>();
                map = this.compiledScriptCache;
                synchronized (map) {
                    this.compiledScriptCache.put(engine, cache);
                }
            }
            CompiledScriptInfo info = cache.get(source);
            CompiledScript script = null;
            if (info != null) {
                script = info.getCompiledScript();
            }
            if (script == null) {
                reader = new BufferedReader(new StringReader(source));
                String filename = (String)engine.get("javax.script.filename");
                try {
                    engine.put("javax.script.filename", resourceIdentifier);
                    script = ((Compilable)((Object)engine)).compile(reader);
                    info = new CompiledScriptInfo(source, 0L, script);
                    cache.put(source, info);
                }
                finally {
                    engine.put("javax.script.filename", filename);
                }
            }
            Object savedFilename = context.getBindings(100).get("javax.script.filename");
            try {
                context.getBindings(100).put("javax.script.filename", (Object)resourceIdentifier);
                Object object2 = script.eval(context);
                return object2;
            }
            finally {
                context.getBindings(100).put("javax.script.filename", savedFilename);
            }
        }
        reader = new BufferedReader(new StringReader(source));
        Object savedFilename = context.getBindings(100).get("javax.script.filename");
        try {
            context.getBindings(100).put("javax.script.filename", (Object)resourceIdentifier);
            object = engine.eval(reader, context);
            context.getBindings(100).put("javax.script.filename", savedFilename);
        }
        catch (Throwable throwable) {
            context.getBindings(100).put("javax.script.filename", savedFilename);
            throw throwable;
        }
        return object;
        finally {
            if (engine != null) {
                this.releaseEngine(engine);
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public static String getExtension(String resourcePath) {
        int index = resourcePath.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        return resourcePath.substring(index + 1);
    }

    public static class CompiledScriptInfo {
        private String resourcePath;
        private long timestamp;
        private CompiledScript script;

        public CompiledScriptInfo(String resourcePath, long timestamp, CompiledScript script) {
            this.resourcePath = resourcePath;
            this.timestamp = timestamp;
            this.script = script;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public CompiledScript getCompiledScript() {
            return this.script;
        }
    }

    private static class CachedFactoryEntry {
        private ScriptEngineFactory factory;
        private ScriptEngine engine;
        private int count;

        public CachedFactoryEntry(ScriptEngineFactory factory, ScriptEngine engine) {
            this.factory = factory;
            this.engine = engine;
            this.count = 1;
        }

        public ScriptEngineFactory getFactory() {
            return this.factory;
        }

        public ScriptEngine getEngine() {
            return this.engine;
        }

        public int acquire() {
            return ++this.count;
        }

        public int release() {
            return --this.count;
        }
    }
}

