/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container;

import com.sun.phobos.container.RequestWrapper;
import com.sun.phobos.container.ResponseWrapper;
import com.sun.phobos.container.debug.StackTraceInfo;
import com.sun.phobos.script.util.ExtendedScriptException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import javax.script.ScriptException;
import org.mozilla.javascript.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseHelper<RequestType, ResponseType> {
    public void sendErrorReply(ResponseWrapper<ResponseType> response, int code, String message) {
        try {
            response.setStatus(code);
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            writer.println("<html><head>Error</head><body><h1>");
            writer.print(message);
            writer.print("</h1></body></html>");
            writer.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void writeStatusPage(RequestWrapper<RequestType> request, ResponseWrapper<ResponseType> response, Map<String, Object> globals) {
        try {
            response.setStatus(200);
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            writer.println("<html><head><title>Project Phobos</title>");
            writer.println("<style type=\"text/css\">");
            writer.println("table { border: 1px solid #222222; }");
            writer.println(".header {color: white; background-color: #204a87; padding: 20px;}");
            writer.println(".subheader {color: white; background-color: #729fcf; padding-left: 20px;}");
            writer.println(".hilited {color: black; background-color: #f7f7d1;}");
            writer.println(".grayed {color: black; background-color: #d4d2dd;}");
            writer.println("</style></head>");
            writer.println("<body bgcolor=\"white\">");
            writer.println("<h1>Project Phobos</h1><p>This server is alive.</p>");
            writer.println("<p><table border=\"0\" cellspacing=\"0\" width=\"100%\">");
            writer.println("<tr><td class=\"header\" colspan=\"2\"><b>VERSION INFO</b></td></tr>");
            String s = (String)globals.get("adapterVersion");
            this.writeRow(writer, "Adapter", s, false);
            s = (String)globals.get("frameworkVersion");
            if (s != null) {
                this.writeRow(writer, "Framework", s, true);
            }
            writer.println("</table></p>");
            writer.println("<p><table border=\"0\" cellspacing=\"0\" width=\"100%\">");
            writer.println("<tr><td class=\"header\" colspan=\"2\"><b>REQUEST HEADERS</b></td></tr>");
            Enumeration names = request.getHeaderNames();
            int count = 0;
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                this.writeRow(writer, name, request.getHeader(name), count % 2 == 1);
                ++count;
            }
            writer.println("</table></p>");
            writer.println("<p><table border=\"0\" cellspacing=\"0\" width=\"100%\">");
            writer.println("<tr><td class=\"header\" colspan=\"2\"><b>SYSTEM PROPERTIES</b></td></tr>");
            TreeMap<Object, Object> sortedProperties = new TreeMap<Object, Object>(System.getProperties());
            count = 0;
            for (Map.Entry<Object, Object> entry : sortedProperties.entrySet()) {
                this.writeRow(writer, entry.getKey().toString(), entry.getValue().toString(), count % 2 == 1);
                ++count;
            }
            writer.println("</table></p>");
            writer.println("</body></html>");
            writer.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected void writeRow(PrintWriter writer, String key, Object value, boolean grayed) throws IOException {
        writer.print("<tr><td align=\"left\" width=\"20%\"");
        if (grayed) {
            writer.print("class=\"grayed\"");
        }
        writer.print("><b>");
        writer.print(key);
        writer.print(":</b></td><td align=\"left\" width=\"80%\"");
        if (grayed) {
            writer.print("class=\"grayed\"");
        }
        writer.print(">");
        writer.print(value);
        writer.println("</td></tr>");
    }

    public void sendScriptingErrorReply(ResponseWrapper<ResponseType> response, int code, ScriptException e, StackTraceInfo info) throws IOException {
        Throwable t;
        if (!response.isCommitted()) {
            response.reset();
        }
        response.setStatus(code);
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.println("<html><head>");
        writer.println("<title>Scripting Error</title>");
        writer.println("<style type=\"text/css\">");
        writer.println("table { border: 1px solid #222222; }");
        writer.println(".header {color: white; background-color: #204a87; padding: 20px;}");
        writer.println(".subheader {color: white; background-color: #729fcf; padding-left: 20px;}");
        writer.println(".hilited {color: black; background-color: #f7f7d1;}");
        writer.println(".grayed {color: black; background-color: #d4d2dd;}");
        writer.println("</style></head>");
        writer.println("<body bgcolor=\"white\">");
        writer.println("<h1>Scripting Error</h1>");
        Stack<ScriptException> exceptionStack = new Stack<ScriptException>();
        ArrayList<Throwable> exceptionList = new ArrayList<Throwable>();
        Throwable current = e;
        while (true) {
            if (current instanceof WrappedException) {
                WrappedException w = (WrappedException)current;
                if (w.getWrappedException() != null) {
                    current = w.getWrappedException();
                    continue;
                }
                exceptionStack.push((ScriptException)current);
                exceptionList.add(current);
                break;
            }
            exceptionStack.push((ScriptException)current);
            exceptionList.add(current);
            if (current instanceof ExtendedScriptException) {
                ExtendedScriptException e2 = (ExtendedScriptException)current;
                if (e2.getCause() == null) break;
                current = e2.getCause();
                continue;
            }
            if (current instanceof ScriptException || current.getCause() == null) break;
            current = current.getCause();
        }
        while (!exceptionStack.empty() && !((t = (Throwable)exceptionStack.peek()) instanceof ScriptException)) {
            exceptionStack.pop();
        }
        writer.println("<p>The following error occurred while running a script:</p>");
        writer.println("<p><span class=\"hilited\"><big>" + ((Throwable)exceptionStack.peek()).getMessage() + "</big></span></p>");
        if (info != null) {
            writer.println("<p><table border=\"0\" cellspacing=\"0\" width=\"100%\">");
            writer.println("<tr><td class=\"header\" colspan=\"2\"><b>JAVASCRIPT CALL STACK</b></td></tr>");
            writer.print("<tr><td class=\"subheader\" colspan=\"2\"><b>");
            writer.print(info.getCause().getMessage());
            writer.println("</b></td></tr>");
            int lineNo = 0;
            for (StackTraceInfo.Element element : info.getStackTrace()) {
                writer.print("<tr><td colspan=\"2\" ");
                if (lineNo % 2 == 1) {
                    writer.print("class=\"grayed\"");
                }
                writer.print(">");
                writer.print(element.getSourceFile());
                writer.print(":");
                writer.print(element.getLineNumber());
                writer.println("</td></tr>");
                ++lineNo;
            }
            writer.println("</table></p>");
        }
        writer.println("<br/>");
        writer.println("<p><table border=\"0\" cellspacing=\"0\" width=\"100%\">");
        writer.println("<tr><td class=\"header\" colspan=\"2\"><b>ERROR FRAMES</b></td></tr>");
        int frameNo = 1;
        while (!exceptionStack.empty()) {
            Throwable t2 = (Throwable)exceptionStack.pop();
            writer.println("<tr><td class=\"subheader\" colspan=\"2\"><b>FRAME " + Integer.toString(frameNo) + "</b></td></tr>");
            if (t2 instanceof ScriptException) {
                ScriptException e2 = (ScriptException)t2;
                String location = e2.getFileName();
                if (e2.getLineNumber() != -1) {
                    location = location + " (line ";
                    location = location + e2.getLineNumber();
                    location = location + ")";
                }
                writer.print("<tr><td align=\"left\" width=\"20%\"><b>Source position:</b></td><td align=\"left\" width=\"80%\">");
                writer.print(location);
                writer.println("</td></tr>");
            }
            writer.print("<tr><td align=\"left\" width=\"20%\"><b>Message:</b></td><td align=\"left\" width=\"80%\">");
            writer.print(t2.getMessage());
            writer.println("</td></tr>");
            ++frameNo;
        }
        writer.println("</table></p>");
        writer.println("<br/>");
        writer.println("<p><table border=\"0\" cellspacing=\"0\" width=\"100%\">");
        writer.println("<tr><td class=\"header\" colspan=\"2\"><b>JAVA STACK TRACE</b></td></tr>");
        int exceptionNo = 1;
        for (Throwable t3 : exceptionList) {
            writer.println("<tr><td class=\"subheader\" colspan=\"2\"><b> EXCEPTION " + Integer.toString(exceptionNo) + ": " + t3.getClass().getName() + "</b></td></tr>");
            int elementNo = 0;
            for (StackTraceElement element : t3.getStackTrace()) {
                String logicalPos = element.getClassName() + "." + element.getMethodName();
                String sourcePos = "(source not available)";
                if (element.getFileName() != null && element.getLineNumber() > 0) {
                    sourcePos = element.getFileName() + ":" + element.getLineNumber();
                }
                writer.print("<tr><td width=\"60%\"");
                if (elementNo % 2 == 1) {
                    writer.print("class=\"grayed\"");
                }
                writer.print(">");
                writer.print(logicalPos);
                writer.print("</td><td width=\"40%\"");
                if (elementNo % 2 == 1) {
                    writer.print("class=\"grayed\"");
                }
                writer.print(">");
                writer.print(sourcePos);
                writer.println("</td></tr>");
                ++elementNo;
            }
            ++exceptionNo;
        }
        writer.println("</table></p>");
        writer.println("<br/>");
        writer.println("</body></html>");
        writer.flush();
    }
}

