/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container;

import com.sun.phobos.container.FileResourceService;
import com.sun.phobos.container.PhobosRuntime;
import com.sun.phobos.container.RequestWrapper;
import com.sun.phobos.container.ResourceService;
import com.sun.phobos.container.ResponseHelper;
import com.sun.phobos.container.ResponseWrapper;
import com.sun.phobos.container.ScriptingService;
import com.sun.phobos.container.debug.DebuggerImpl;
import com.sun.phobos.container.debug.StackTraceInfo;
import com.sun.phobos.container.debug.StackTraceRecordingDebuggerListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhobosAdapter<RequestType, ResponseType> {
    protected Map<String, Object> globalContext;
    protected ScriptingService scriptingService;
    protected ResourceService resourceService;
    protected boolean bootstrapped = false;
    protected boolean initialized = false;
    protected String scratchDir;
    protected DebuggerImpl debugger;
    protected Properties properties;
    protected PrintWriter logWriter;
    protected ResponseHelper responseHelper;
    protected Lock logLock = new ReentrantLock();
    protected static final boolean DEBUG = true;
    protected static final boolean INFO = false;
    protected static final String SCRIPTING_STACK_TRACE_HEADER = "Scripting error: ";

    public PhobosAdapter() {
        this.responseHelper = this.createResponseHelper();
    }

    public void startup() {
        this.startup(this.getDefaultBaseDirectory());
    }

    public void startup(String baseDir) {
        if (this.logWriter == null) {
            this.logWriter = new PrintWriter(new OutputStreamWriter(System.err));
        }
        this.globalContext = new ConcurrentHashMap<String, Object>();
        this.scriptingService = this.createScriptingService();
        if (this.resourceService == null) {
            this.resourceService = this.createResourceService(baseDir);
        }
        this.scriptingService.setResourceService(this.resourceService);
        this.scriptingService.setProperties(this.properties);
        if ("true".equals(this.getProperty("com.sun.phobos.container.detailedStackTraces"))) {
            if (this.debugger == null) {
                this.debugger = this.createDebugger();
            }
            this.debugger.addDebuggerListener(new StackTraceRecordingDebuggerListener());
        }
        if (this.debugger != null) {
            this.debugger.setResourceService(this.resourceService);
            this.scriptingService.setDebugger(this.debugger);
        }
        this.scriptingService.initialize();
        if (this.scratchDir == null) {
            this.scratchDir = this.getDefaultScratchDirectory();
        }
        this.globalContext.put("adapterVersion", "0.5");
        this.globalContext.put("baseDir", baseDir);
        this.globalContext.put("scratchDir", this.scratchDir);
        this.globalContext.put("resource", this.resourceService);
        this.globalContext.put("scripting", this.scriptingService);
        this.globalContext.put("platform", this.getPlatform());
        this.globalContext.put("environment", this.getEnvironment());
        this.registerContextRoot();
        this.beforeBootstrap();
        try {
            this.runSpecialScript("/framework/bootstrap.js");
            this.bootstrapped = true;
        }
        catch (Throwable t) {
            this.log(t);
        }
        this.afterBootstrap(this.bootstrapped);
        if (this.bootstrapped) {
            this.beforeStartup();
            try {
                this.runSpecialScript("/framework/startup.js");
                this.initialized = true;
            }
            catch (Throwable t) {
                this.log(t);
            }
            this.afterStartup(this.initialized);
        }
    }

    public Map<String, Object> getGlobalContext() {
        return this.globalContext;
    }

    public void shutdown() {
        this.beforeShutdown();
        boolean succeeded = false;
        try {
            this.runSpecialScript("/framework/shutdown.js");
            succeeded = true;
        }
        catch (Throwable t) {
            this.log(t);
        }
        this.afterShutdown(succeeded);
        this.scriptingService.destroy();
        this.initialized = false;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter writer) {
        this.logWriter = writer;
    }

    public String getProperty(String key) {
        String value = null;
        if (this.properties != null) {
            value = this.properties.getProperty(key);
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    protected void registerContextRoot() {
        String s = this.getProperty("phobos.contextRoot");
        if (s != null && !s.startsWith("/")) {
            s = "/" + s;
        }
        if (s == null) {
            s = "";
        }
        this.globalContext.put("contextRoot", s);
    }

    protected String getProperty(String name, String defaultValue) {
        String s = this.getProperty(name);
        return s == null ? defaultValue : s;
    }

    protected String getDefaultBaseDirectory() {
        String baseDir = null;
        try {
            baseDir = new File("..").getCanonicalPath();
        }
        catch (IOException e) {
            baseDir = new File("..").getAbsolutePath();
        }
        return baseDir;
    }

    protected String getDefaultScratchDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    protected String getPlatform() {
        return this.getProperty("com.sun.phobos.platform", "undefined");
    }

    protected String getEnvironment() {
        return this.getProperty("com.sun.phobos.environment", "development");
    }

    protected ScriptingService createScriptingService() {
        return new ScriptingService();
    }

    public ScriptingService getScriptingService() {
        return this.scriptingService;
    }

    protected ResponseHelper<RequestType, ResponseType> createResponseHelper() {
        return new ResponseHelper();
    }

    protected ResourceService createResourceService(String baseDir) {
        return new FileResourceService(baseDir);
    }

    protected DebuggerImpl createDebugger() {
        DebuggerImpl debugger = new DebuggerImpl();
        debugger.setDebugRequests(true);
        return debugger;
    }

    protected abstract RequestWrapper<RequestType> createRequestWrapper(RequestType var1);

    protected abstract ResponseWrapper<ResponseType> createResponseWrapper(ResponseType var1);

    public void setScratchDirectoryName(String s) {
        this.scratchDir = s;
    }

    public DebuggerImpl getDebugger() {
        return this.debugger;
    }

    public void setDebugger(DebuggerImpl debugger) {
        this.debugger = debugger;
    }

    public ResourceService getResourceService() {
        return this.resourceService;
    }

    public void setResourceService(ResourceService svc) {
        this.resourceService = svc;
    }

    protected void beforeBootstrap() {
    }

    protected void afterBootstrap(boolean succeeded) {
    }

    protected void beforeStartup() {
    }

    protected void afterStartup(boolean succeeded) {
    }

    protected void beforeShutdown() {
    }

    protected void afterShutdown(boolean succeeded) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(RequestType request, ResponseType response) {
        RequestWrapper<RequestType> requestWrapper = this.createRequestWrapper(request);
        ResponseWrapper<ResponseType> responseWrapper = this.createResponseWrapper(response);
        try {
            this.beforeService(requestWrapper, responseWrapper);
            if (!this.initialized) {
                this.responseHelper.sendErrorReply(responseWrapper, 404, "404 Not Found");
            } else if (requestWrapper.getRequestURI().equals("/status")) {
                this.responseHelper.writeStatusPage(requestWrapper, responseWrapper, this.globalContext);
            } else if (!this.runServiceScript(requestWrapper, responseWrapper)) {
                this.responseHelper.sendErrorReply(responseWrapper, 404, "404 Not Found");
            }
            this.afterService(requestWrapper, responseWrapper);
        }
        catch (Throwable t) {
            this.log(t);
        }
        finally {
            this.finallyService(requestWrapper, responseWrapper);
        }
    }

    protected void beforeService(RequestWrapper<RequestType> request, ResponseWrapper<ResponseType> response) throws IOException {
    }

    protected void afterService(RequestWrapper<RequestType> request, ResponseWrapper<ResponseType> response) throws IOException {
    }

    protected void finallyService(RequestWrapper<RequestType> request, ResponseWrapper<ResponseType> response) {
    }

    protected ScriptContext createScriptContext() {
        return new SimpleScriptContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Throwable t) {
        this.logLock.lock();
        try {
            t.printStackTrace(this.logWriter);
            this.logWriter.flush();
        }
        finally {
            this.logLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logScriptingStackTrace(Map<String, Object> requestContext) {
        StackTraceInfo info;
        StackTraceInfo stackTraceInfo = info = requestContext != null ? (StackTraceInfo)requestContext.get("stackTraceInfo") : null;
        if (info != null) {
            this.logLock.lock();
            try {
                this.logWriter.println(SCRIPTING_STACK_TRACE_HEADER + info.getCause());
                for (StackTraceInfo.Element element : info.getStackTrace()) {
                    this.logWriter.println("\tat " + element.getSourceFile() + ":" + element.getLineNumber());
                }
                this.logWriter.flush();
            }
            finally {
                this.logLock.unlock();
            }
        }
    }

    protected String getExtension(RequestWrapper<RequestType> request) {
        return this.getExtension(request.getRequestURI());
    }

    protected String getExtension(String name) {
        boolean len = false;
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        return name.substring(index + 1);
    }

    protected boolean runServiceScript(RequestWrapper<RequestType> request, ResponseWrapper<ResponseType> response) {
        String scriptFilename = "/framework/service.js";
        if (!this.resourceService.isResourcePresent(scriptFilename)) {
            return false;
        }
        return this.runScript(scriptFilename, request, response);
    }

    /*
     * Exception decompiling
     */
    protected boolean runScript(String scriptFilename, RequestWrapper<RequestType> request, ResponseWrapper<ResponseType> response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void runSpecialScript(String name) throws Throwable {
        String scriptFilename;
        HashMap<String, Object> requestContext;
        Reader reader;
        ScriptEngine engine;
        ScriptContext context;
        block33: {
            block32: {
                String extension;
                block31: {
                    context = null;
                    engine = null;
                    reader = null;
                    requestContext = null;
                    extension = this.getExtension(name);
                    if (extension != null && extension.length() != 0) break block31;
                    if (engine != null) {
                        this.scriptingService.releaseEngine(engine);
                    }
                    if (reader == null) return;
                    try {
                        reader.close();
                        return;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                engine = this.scriptingService.acquireEngine(extension);
                if (engine != null) break block32;
                if (engine != null) {
                    this.scriptingService.releaseEngine(engine);
                }
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            scriptFilename = name;
            context = this.createScriptContext();
            if (this.resourceService.isResourcePresent(scriptFilename)) break block33;
            if (engine != null) {
                this.scriptingService.releaseEngine(engine);
            }
            if (reader == null) return;
            try {
                reader.close();
                return;
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        try {
            reader = new InputStreamReader(this.resourceService.getResourceAsStream(scriptFilename));
        }
        catch (IOException e) {
            if (engine != null) {
                this.scriptingService.releaseEngine(engine);
            }
            if (reader == null) return;
            try {
                reader.close();
                return;
            }
            catch (IOException e2) {
                // empty catch block
            }
            return;
        }
        Bindings engineBindings = context.getBindings(100);
        engineBindings.put("javax.script.filename", (Object)scriptFilename);
        engineBindings.put("context", (Object)context);
        requestContext = new HashMap<String, Object>();
        requestContext.put("engine", engine);
        requestContext.put("scriptName", scriptFilename);
        PhobosRuntime.setCurrentAdapter(this);
        PhobosRuntime.setCurrentEngineBindings(engineBindings);
        PhobosRuntime.setGlobalContext(this.globalContext);
        PhobosRuntime.setRequestContext(requestContext);
        try {
            Object result = engine.eval(reader, context);
        }
        finally {
            PhobosRuntime.clear();
        }
        if (engine != null) {
            this.scriptingService.releaseEngine(engine);
        }
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException e) {}
        return;
        catch (Throwable t) {
            try {
                this.logScriptingStackTrace(requestContext);
                this.log(t);
                throw t;
            }
            catch (Throwable throwable) {
                if (engine != null) {
                    this.scriptingService.releaseEngine(engine);
                }
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void runBackgroundScript(String name) {
        String scriptFilename;
        HashMap<String, Object> requestContext;
        Reader reader;
        ScriptEngine engine;
        ScriptContext context;
        block43: {
            block42: {
                String extension;
                block41: {
                    context = null;
                    engine = null;
                    reader = null;
                    requestContext = null;
                    scriptFilename = "/framework/background.js";
                    if (!this.resourceService.isResourcePresent(scriptFilename)) {
                        return;
                    }
                    extension = this.getExtension(scriptFilename);
                    if (extension != null && extension.length() != 0) break block41;
                    if (engine != null) {
                        this.scriptingService.releaseEngine(engine);
                    }
                    if (reader == null) return;
                    try {
                        reader.close();
                        return;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                engine = this.scriptingService.acquireEngine(extension);
                if (engine != null) break block42;
                if (engine != null) {
                    this.scriptingService.releaseEngine(engine);
                }
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            context = this.createScriptContext();
            if (this.resourceService.isResourcePresent(scriptFilename)) break block43;
            if (engine != null) {
                this.scriptingService.releaseEngine(engine);
            }
            if (reader == null) return;
            try {
                reader.close();
                return;
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        try {
            reader = new InputStreamReader(this.resourceService.getResourceAsStream(scriptFilename));
        }
        catch (IOException e) {
            if (engine != null) {
                this.scriptingService.releaseEngine(engine);
            }
            if (reader == null) return;
            try {
                reader.close();
                return;
            }
            catch (IOException e2) {
                // empty catch block
            }
            return;
        }
        Bindings engineBindings = context.getBindings(100);
        engineBindings.put("javax.script.filename", (Object)scriptFilename);
        engineBindings.put("context", (Object)context);
        requestContext = new HashMap<String, Object>();
        requestContext.put("engine", engine);
        requestContext.put("scriptName", scriptFilename);
        requestContext.put("backgroundScriptName", name);
        PhobosRuntime.setCurrentAdapter(this);
        PhobosRuntime.setCurrentEngineBindings(engineBindings);
        PhobosRuntime.setGlobalContext(this.globalContext);
        PhobosRuntime.setRequestContext(requestContext);
        try {
            Object result = engine.eval(reader, context);
        }
        finally {
            PhobosRuntime.clear();
        }
        if (engine != null) {
            this.scriptingService.releaseEngine(engine);
        }
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException e) {}
        return;
        catch (ScriptException e) {
            this.logScriptingStackTrace(requestContext);
            this.log(e);
            if (engine != null) {
                this.scriptingService.releaseEngine(engine);
            }
            if (reader == null) return;
            try {
                reader.close();
                return;
            }
            catch (IOException e3) {}
            return;
        }
        catch (Throwable t) {
            this.log(t);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                if (engine != null) {
                    this.scriptingService.releaseEngine(engine);
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

