/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container;

import com.sun.phobos.container.ResourceService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileResourceService
implements ResourceService {
    protected File resourceBase;

    public FileResourceService(String resourceBase) {
        this.resourceBase = new File(resourceBase);
    }

    public InputStream getResourceAsStream(String resourcePath) throws IOException {
        return new FileInputStream(this.fileFor(resourcePath));
    }

    public boolean isResourcePresent(String resourcePath) {
        File file = this.fileFor(resourcePath);
        return file.exists() && file.isFile();
    }

    public boolean isDirectoryPresent(String resourcePath) {
        File file = this.fileFor(resourcePath);
        return file.exists() && file.isDirectory();
    }

    public String getRealPath(String resourcePath) {
        return this.fileFor(resourcePath).getAbsolutePath();
    }

    public long getLastModified(String resourcePath) {
        return this.fileFor(resourcePath).lastModified();
    }

    public long getLength(String resourcePath) {
        return this.fileFor(resourcePath).length();
    }

    public String[] getChildren(String resourcePath) {
        return this.fileFor(resourcePath).list();
    }

    public OutputStream getOutputStream(String resourcePath, boolean create, boolean append) {
        if (this.isReadOnly(resourcePath)) {
            return null;
        }
        File f = this.fileFor(resourcePath);
        if (!f.exists()) {
            boolean ok;
            if (!create) {
                return null;
            }
            File parent = f.getParentFile();
            if (parent != null && !parent.exists() && !(ok = parent.mkdirs())) {
                return null;
            }
        }
        try {
            return new FileOutputStream(f, append);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    protected File fileFor(String resourcePath) {
        return new File(this.resourceBase, this.normalize(resourcePath));
    }

    protected String normalize(String resourcePath) {
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        return resourcePath;
    }

    protected boolean isReadOnly(String resourcePath) {
        return false;
    }
}

