/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.mock;

import com.sun.phobos.container.util.Cookie;
import com.sun.phobos.container.util.FastHttpDateFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class MockResponse {
    protected SimpleDateFormat format = null;
    private int statusCode;
    private int contentLength;
    private Locale locale;
    private String contentType;
    private String characterEncoding;
    private String quotedCharsetValue;
    private boolean charsetSet;
    private boolean headersSent;
    private boolean exchangeTerminated;
    private Map<String, List<String>> headers;
    private boolean gotWriter;
    private boolean gotStream;
    private PrintWriter writer;
    private ByteArrayOutputStream outputStream;
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";

    public MockResponse() {
        this.init();
    }

    private void init() {
        this.statusCode = 200;
        this.contentLength = 0;
        this.quotedCharsetValue = this.characterEncoding = DEFAULT_CHARACTER_ENCODING;
        this.locale = DEFAULT_LOCALE;
        this.headers = new HashMap<String, List<String>>();
        this.headersSent = false;
        this.exchangeTerminated = false;
        this.charsetSet = false;
        this.gotWriter = false;
        this.gotStream = false;
    }

    public void addCookie(Cookie cookie) {
        StringBuffer sb = new StringBuffer();
        Cookie.appendCookieValue(sb, cookie.getVersion(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure());
        this.addHeader("Set-Cookie", sb.toString());
    }

    public void addDateHeader(String name, long value) {
        if (this.format == null) {
            this.format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.addHeader(name, FastHttpDateFormat.formatDate(value, this.format));
    }

    public void addHeader(String name, String value) {
        List<String> current = this.headers.get(name);
        if (current == null) {
            current = new ArrayList<String>();
            this.headers.put(name, current);
        }
        current.add(value);
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public void sendError(int sc) throws IOException {
        if (this.headersSent) {
            throw new IllegalStateException("headers already sent");
        }
        this.statusCode = sc;
        this.contentLength = -1;
        this.sendHeaders();
        this.terminateExchange();
    }

    public void setDateHeader(String name, long date) {
        if (this.format == null) {
            this.format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.setHeader(name, FastHttpDateFormat.formatDate(date, this.format));
    }

    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.headers.put(name, values);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void setStatus(int code) {
        this.statusCode = code;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public String getContentType() {
        String ret = this.contentType;
        if (ret != null && this.quotedCharsetValue != null && this.charsetSet) {
            ret = ret + ";charset=" + this.quotedCharsetValue;
        }
        return ret;
    }

    public void setContentType(String type) {
        int semicolonIndex = -1;
        if (type == null) {
            this.contentType = null;
            return;
        }
        boolean hasCharset = false;
        int len = type.length();
        int index = type.indexOf(59);
        while (index != -1) {
            semicolonIndex = index++;
            while (index < len && Character.isSpace(type.charAt(index))) {
                ++index;
            }
            if (index + 8 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                hasCharset = true;
                break;
            }
            index = type.indexOf(59, index);
        }
        if (!hasCharset) {
            this.contentType = type;
            return;
        }
        this.contentType = type.substring(0, semicolonIndex);
        String tail = type.substring(index + 8);
        int nextParam = tail.indexOf(59);
        String charsetValue = null;
        if (nextParam != -1) {
            this.contentType = this.contentType + tail.substring(nextParam);
            charsetValue = tail.substring(0, nextParam);
        } else {
            charsetValue = tail;
        }
        if (charsetValue != null && charsetValue.length() > 0) {
            this.charsetSet = true;
            this.quotedCharsetValue = charsetValue;
            this.characterEncoding = charsetValue.replace('\"', ' ').trim();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.gotWriter) {
            throw new IllegalStateException("getWriter called previously");
        }
        this.gotStream = true;
        this.sendHeaders();
        this.outputStream = new ByteArrayOutputStream();
        return this.outputStream;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String charset) {
        if (charset == null) {
            return;
        }
        this.characterEncoding = charset;
        this.quotedCharsetValue = charset;
        this.charsetSet = true;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.gotStream) {
            throw new IllegalStateException("getStream called previously");
        }
        this.gotWriter = true;
        this.sendHeaders();
        this.outputStream = new ByteArrayOutputStream();
        this.writer = new PrintWriter(this.outputStream);
        return this.writer;
    }

    public void flushBuffer() {
    }

    public int getBufferSize() {
        return 0;
    }

    public void setBufferSize(int size) {
        if (this.headersSent) {
            throw new IllegalStateException("headers already sent");
        }
    }

    public boolean isCommitted() {
        return this.headersSent;
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("response already committed");
        }
        this.init();
        this.headers.clear();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("response already committed");
        }
    }

    private void sendHeaders() throws IOException {
        if (!this.headersSent) {
            if (this.contentType != null) {
                this.addHeader("Content-Type", this.contentType);
            }
            this.headersSent = true;
        }
    }

    public void terminateExchange() {
        try {
            if (!this.exchangeTerminated) {
                this.sendHeaders();
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                this.exchangeTerminated = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

