/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container;

import com.sun.phobos.container.PhobosAdapter;
import java.util.Map;
import javax.script.Bindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhobosRuntime {
    private static ThreadLocal<Bindings> currentEngineBindings = new ThreadLocal();
    private static ThreadLocal<PhobosAdapter> currentAdapter = new ThreadLocal();
    private static ThreadLocal<Map<String, Object>> globalContext = new ThreadLocal();
    private static ThreadLocal<Map<String, Object>> requestContext = new ThreadLocal();

    private PhobosRuntime() {
    }

    public static Bindings getCurrentEngineBindings() {
        return currentEngineBindings.get();
    }

    public static void setCurrentEngineBindings(Bindings bindings) {
        currentEngineBindings.set(bindings);
    }

    public static Map<String, Object> getGlobalContext() {
        return globalContext.get();
    }

    public static void setGlobalContext(Map<String, Object> map) {
        globalContext.set(map);
    }

    public static Map<String, Object> getRequestContext() {
        return requestContext.get();
    }

    public static void setRequestContext(Map<String, Object> map) {
        requestContext.set(map);
    }

    public static PhobosAdapter getCurrentAdapter() {
        return currentAdapter.get();
    }

    public static void setCurrentAdapter(PhobosAdapter adapter) {
        currentAdapter.set(adapter);
    }

    public static Runnable createScriptRunnable(final String name) {
        final PhobosAdapter adapter = PhobosRuntime.getCurrentAdapter();
        return new Runnable(){

            public void run() {
                adapter.runBackgroundScript(name);
            }
        };
    }

    public static Runnable createScriptRunnable(final String name, final String arg) {
        final PhobosAdapter adapter = PhobosRuntime.getCurrentAdapter();
        return new Runnable(){

            public void run() {
                adapter.runBackgroundScript(name, arg);
            }
        };
    }

    public static void clear() {
        PhobosRuntime.setCurrentAdapter(null);
        PhobosRuntime.setCurrentEngineBindings(null);
        PhobosRuntime.setRequestContext(null);
        PhobosRuntime.setGlobalContext(null);
    }
}

