/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container;

import com.sun.phobos.container.Framework;
import com.sun.phobos.container.PhobosAdapter;
import com.sun.phobos.container.PhobosRuntime;
import com.sun.phobos.container.RequestWrapper;
import com.sun.phobos.container.ResourceService;
import com.sun.phobos.container.ResponseHelper;
import com.sun.phobos.container.ResponseWrapper;
import com.sun.phobos.container.ScriptingService;
import com.sun.phobos.container.debug.StackTraceInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;

public class PhobosFramework
implements Framework {
    protected PhobosAdapter adapter;
    protected Map<String, Object> globalContext;
    protected ResponseHelper responseHelper;
    protected ResourceService resourceService;
    protected ScriptingService scriptingService;
    protected boolean disableDetailedErrorPage = false;
    protected boolean enableCustomErrorPage = false;
    protected String customErrorPageContentType;
    protected String customErrorPageResource;
    protected boolean startupFailed = false;
    protected Throwable startupThrowable;
    protected StackTraceInfo startupStackTraceInfo;

    public PhobosFramework(PhobosAdapter adapter) {
        this.adapter = adapter;
        this.responseHelper = adapter.getResponseHelper();
        this.resourceService = adapter.getResourceService();
        this.scriptingService = adapter.getScriptingService();
        this.globalContext = adapter.getGlobalContext();
        if ("true".equals(adapter.getProperty("com.sun.phobos.container.disableDetailedErrorPage"))) {
            this.disableDetailedErrorPage = true;
        }
        if ("true".equals(adapter.getProperty("com.sun.phobos.container.enableCustomErrorPage"))) {
            this.enableCustomErrorPage = true;
            this.customErrorPageContentType = adapter.getProperty("com.sun.phobos.container.customErrorPageContentType");
            this.customErrorPageResource = adapter.getProperty("com.sun.phobos.container.customErrorPageResource");
            if (this.customErrorPageContentType == null || "".equals(this.customErrorPageContentType) || this.customErrorPageResource == null || "".equals(this.customErrorPageResource)) {
                this.enableCustomErrorPage = false;
            }
        }
    }

    public void onBootstrap() throws Throwable {
        this.runSpecialScript(this.getBootstrapScript(), true);
    }

    public void onStartup() throws Throwable {
        this.runSpecialScript(this.getStartupScript(), true);
    }

    public void onShutdown() throws Throwable {
        this.runSpecialScript(this.getShutdownScript());
    }

    public boolean onService(RequestWrapper request, ResponseWrapper response) {
        return this.runServiceScript(request, response);
    }

    public void onBackground(String name, String arg) {
        this.runBackgroundScript(name, arg);
    }

    /*
     * Exception decompiling
     */
    protected boolean runScript(String scriptFilename, RequestWrapper request, ResponseWrapper response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void sendHardwiredErrorPage(ResponseWrapper response) {
        if (this.enableCustomErrorPage) {
            try {
                InputStream data = this.resourceService.getResourceAsStream(this.customErrorPageResource);
                if (data != null) {
                    this.responseHelper.sendErrorReply(response, 500, this.customErrorPageContentType, data);
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.responseHelper.sendErrorReply(response, 500, "500 Internal Server Error");
    }

    protected void runSpecialScript(String name) throws Throwable {
        this.runSpecialScript(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runSpecialScript(String name, boolean captureStartupError) throws Throwable {
        Reader reader;
        ScriptEngine engine;
        block38: {
            block39: {
                block35: {
                    block36: {
                        block34: {
                            ScriptContext context = null;
                            engine = null;
                            reader = null;
                            HashMap<String, Object> requestContext = null;
                            try {
                                String extension = this.getExtension(name);
                                if (extension == null) return;
                                if (extension.length() == 0) {
                                    return;
                                }
                                engine = this.scriptingService.acquireEngine(extension);
                                if (engine == null) {
                                    if (engine != null) {
                                        this.scriptingService.releaseEngine(engine);
                                    }
                                    if (reader == null) return;
                                    break block34;
                                }
                                String scriptFilename = name;
                                context = this.createScriptContext();
                                if (!this.resourceService.isResourcePresent(scriptFilename)) {
                                    if (engine == null) break block35;
                                    break block36;
                                }
                                try {
                                    reader = new InputStreamReader(this.resourceService.getResourceAsStream(scriptFilename));
                                }
                                catch (IOException e) {
                                    if (engine != null) {
                                        this.scriptingService.releaseEngine(engine);
                                    }
                                    if (reader == null) return;
                                    try {
                                        reader.close();
                                        return;
                                    }
                                    catch (IOException e2) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                Bindings engineBindings = context.getBindings(100);
                                engineBindings.put("javax.script.filename", (Object)scriptFilename);
                                engineBindings.put("context", (Object)context);
                                requestContext = new HashMap<String, Object>();
                                requestContext.put("engine", engine);
                                requestContext.put("scriptName", scriptFilename);
                                PhobosRuntime.setCurrentAdapter(this.adapter);
                                PhobosRuntime.setCurrentEngineBindings(engineBindings);
                                PhobosRuntime.setGlobalContext(this.globalContext);
                                PhobosRuntime.setRequestContext(requestContext);
                                try {
                                    Object result = engine.eval(reader, context);
                                }
                                finally {
                                    PhobosRuntime.clear();
                                }
                                if (engine == null) break block38;
                                break block39;
                            }
                            catch (ScriptException e) {
                                this.adapter.logScriptingStackTrace(requestContext);
                                this.adapter.log(e);
                                if (this.startupFailed) throw e;
                                if (!captureStartupError) throw e;
                                this.startupFailed = true;
                                this.startupThrowable = e;
                                if (this.disableDetailedErrorPage) throw e;
                                this.startupStackTraceInfo = requestContext != null ? (StackTraceInfo)requestContext.get("stackTraceInfo") : null;
                                throw e;
                            }
                            catch (Throwable t) {
                                this.adapter.logScriptingStackTrace(requestContext);
                                this.adapter.log(t);
                                if (this.startupFailed) throw t;
                                if (!captureStartupError) throw t;
                                this.startupFailed = true;
                                this.startupThrowable = t;
                                throw t;
                            }
                        }
                        try {
                            reader.close();
                            return;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return;
                    }
                    this.scriptingService.releaseEngine(engine);
                }
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            this.scriptingService.releaseEngine(engine);
        }
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException e) {
            return;
        }
        finally {
            if (engine != null) {
                this.scriptingService.releaseEngine(engine);
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected boolean runServiceScript(RequestWrapper request, ResponseWrapper response) {
        if (this.startupFailed) {
            if (!this.disableDetailedErrorPage) {
                if (this.startupThrowable instanceof ScriptException) {
                    try {
                        this.responseHelper.sendScriptingErrorReply(response, 500, "Startup Failed", (ScriptException)this.startupThrowable, this.startupStackTraceInfo);
                    }
                    catch (IOException e) {}
                } else {
                    this.responseHelper.sendErrorReply(response, 500, "Startup Failed", this.startupThrowable);
                }
            } else {
                this.sendHardwiredErrorPage(response);
            }
            return true;
        }
        String scriptFilename = this.getServiceScript();
        if (!this.resourceService.isResourcePresent(scriptFilename)) {
            return false;
        }
        return this.runScript(scriptFilename, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void runBackgroundScript(String name, String arg) {
        String scriptFilename;
        HashMap<String, Object> requestContext;
        Reader reader;
        ScriptEngine engine;
        ScriptContext context;
        block45: {
            block44: {
                String extension;
                block43: {
                    if (this.startupFailed) {
                        return;
                    }
                    context = null;
                    engine = null;
                    reader = null;
                    requestContext = null;
                    scriptFilename = this.getBackgroundScript();
                    if (!this.resourceService.isResourcePresent(scriptFilename)) {
                        return;
                    }
                    extension = this.getExtension(scriptFilename);
                    if (extension != null && extension.length() != 0) break block43;
                    if (engine != null) {
                        this.scriptingService.releaseEngine(engine);
                    }
                    if (reader == null) return;
                    try {
                        reader.close();
                        return;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                engine = this.scriptingService.acquireEngine(extension);
                if (engine != null) break block44;
                if (engine != null) {
                    this.scriptingService.releaseEngine(engine);
                }
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            context = this.createScriptContext();
            if (this.resourceService.isResourcePresent(scriptFilename)) break block45;
            if (engine != null) {
                this.scriptingService.releaseEngine(engine);
            }
            if (reader == null) return;
            try {
                reader.close();
                return;
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        try {
            reader = new InputStreamReader(this.resourceService.getResourceAsStream(scriptFilename));
        }
        catch (IOException e) {
            if (engine != null) {
                this.scriptingService.releaseEngine(engine);
            }
            if (reader == null) return;
            try {
                reader.close();
                return;
            }
            catch (IOException e2) {
                // empty catch block
            }
            return;
        }
        Bindings engineBindings = context.getBindings(100);
        engineBindings.put("javax.script.filename", (Object)scriptFilename);
        engineBindings.put("context", (Object)context);
        requestContext = new HashMap<String, Object>();
        requestContext.put("engine", engine);
        requestContext.put("scriptName", scriptFilename);
        requestContext.put("backgroundScriptName", name);
        if (arg != null) {
            requestContext.put("backgroundScriptArgument", arg);
        }
        PhobosRuntime.setCurrentAdapter(this.adapter);
        PhobosRuntime.setCurrentEngineBindings(engineBindings);
        PhobosRuntime.setGlobalContext(this.globalContext);
        PhobosRuntime.setRequestContext(requestContext);
        try {
            Object result = engine.eval(reader, context);
        }
        finally {
            PhobosRuntime.clear();
        }
        if (engine != null) {
            this.scriptingService.releaseEngine(engine);
        }
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException e) {}
        return;
        catch (ScriptException e) {
            this.adapter.logScriptingStackTrace(requestContext);
            this.adapter.log(e);
            if (engine != null) {
                this.scriptingService.releaseEngine(engine);
            }
            if (reader == null) return;
            try {
                reader.close();
                return;
            }
            catch (IOException e3) {}
            return;
        }
        catch (Throwable t) {
            this.adapter.log(t);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                if (engine != null) {
                    this.scriptingService.releaseEngine(engine);
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    protected String getBootstrapScript() {
        return "/framework/bootstrap.js";
    }

    protected String getStartupScript() {
        return "/framework/startup.js";
    }

    protected String getShutdownScript() {
        return "/framework/shutdown.js";
    }

    protected String getServiceScript() {
        return "/framework/service.js";
    }

    protected String getBackgroundScript() {
        return "/framework/background.js";
    }

    protected ScriptContext createScriptContext() {
        return new SimpleScriptContext();
    }

    protected String getExtension(RequestWrapper request) {
        return this.getExtension(request.getRequestURI());
    }

    protected String getExtension(String name) {
        boolean len = false;
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        return name.substring(index + 1);
    }
}

