/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container;

import com.sun.phobos.container.FileResourceService;
import com.sun.phobos.container.Framework;
import com.sun.phobos.container.PhobosFramework;
import com.sun.phobos.container.RequestWrapper;
import com.sun.phobos.container.ResourceService;
import com.sun.phobos.container.ResponseHelper;
import com.sun.phobos.container.ResponseWrapper;
import com.sun.phobos.container.ScriptingService;
import com.sun.phobos.container.debug.DebuggerImpl;
import com.sun.phobos.container.debug.StackTraceInfo;
import com.sun.phobos.container.debug.StackTraceRecordingDebuggerListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhobosAdapter<RequestType, ResponseType> {
    protected Map<String, Object> globalContext;
    protected ScriptingService scriptingService;
    protected ResourceService resourceService;
    protected boolean bootstrapped = false;
    protected boolean initialized = false;
    protected String scratchDir;
    protected DebuggerImpl debugger;
    protected Properties properties;
    protected PrintWriter logWriter;
    protected Framework framework;
    protected ResponseHelper responseHelper;
    protected Lock logLock = new ReentrantLock();
    protected boolean enableStatusPage = false;
    protected boolean disableDetailedErrorPage = false;
    protected static final String SCRIPTING_STACK_TRACE_HEADER = "Scripting error: ";

    public PhobosAdapter() {
        this.responseHelper = this.createResponseHelper();
    }

    public void startup() {
        this.startup(this.getDefaultBaseDirectory());
    }

    public void startup(String baseDir) {
        if (this.logWriter == null) {
            this.logWriter = new PrintWriter(new OutputStreamWriter(System.err));
        }
        this.globalContext = new ConcurrentHashMap<String, Object>();
        this.scriptingService = this.createScriptingService();
        if (this.resourceService == null) {
            this.resourceService = this.createResourceService(baseDir);
        }
        this.scriptingService.setResourceService(this.resourceService);
        this.scriptingService.setProperties(this.properties);
        if ("true".equals(this.getProperty("com.sun.phobos.container.detailedStackTraces"))) {
            if (this.debugger == null) {
                this.debugger = this.createDebugger();
            }
            this.debugger.addDebuggerListener(new StackTraceRecordingDebuggerListener());
        }
        if ("true".equals(this.getProperty("com.sun.phobos.container.enableStatusPage"))) {
            this.enableStatusPage = true;
        }
        if ("true".equals(this.getProperty("com.sun.phobos.container.disableDetailedErrorPage"))) {
            this.disableDetailedErrorPage = true;
        }
        if (this.debugger != null) {
            this.debugger.setResourceService(this.resourceService);
            this.scriptingService.setDebugger(this.debugger);
        }
        this.scriptingService.initialize();
        if (this.scratchDir == null) {
            this.scratchDir = this.getDefaultScratchDirectory();
        }
        this.globalContext.put("adapterVersion", "0.5.13");
        this.globalContext.put("baseDir", baseDir);
        this.globalContext.put("scratchDir", this.scratchDir);
        this.globalContext.put("resource", this.resourceService);
        this.globalContext.put("scripting", this.scriptingService);
        this.globalContext.put("platform", this.getPlatform());
        this.globalContext.put("environment", this.getEnvironment());
        this.registerContextRoot();
        if (this.framework == null) {
            this.framework = this.createFramework();
        }
        this.beforeBootstrap();
        try {
            this.framework.onBootstrap();
            this.bootstrapped = true;
        }
        catch (Throwable t) {
            this.log(t);
        }
        this.afterBootstrap(this.bootstrapped);
        if (this.bootstrapped) {
            this.beforeStartup();
            try {
                this.framework.onStartup();
                this.initialized = true;
            }
            catch (Throwable t) {
                this.log(t);
            }
            this.afterStartup(this.initialized);
        }
    }

    public Map<String, Object> getGlobalContext() {
        return this.globalContext;
    }

    public void shutdown() {
        this.beforeShutdown();
        boolean succeeded = false;
        try {
            this.framework.onShutdown();
            succeeded = true;
        }
        catch (Throwable t) {
            this.log(t);
        }
        this.afterShutdown(succeeded);
        this.scriptingService.destroy();
        this.initialized = false;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter writer) {
        this.logWriter = writer;
    }

    public String getProperty(String key) {
        String value = null;
        if (this.properties != null) {
            value = this.properties.getProperty(key);
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    protected void registerContextRoot() {
        String s = this.getProperty("phobos.contextRoot");
        if (s != null && !s.startsWith("/")) {
            s = "/" + s;
        }
        if (s == null) {
            s = "";
        }
        this.globalContext.put("contextRoot", s);
    }

    protected String getProperty(String name, String defaultValue) {
        String s = this.getProperty(name);
        return s == null ? defaultValue : s;
    }

    protected String getDefaultBaseDirectory() {
        String baseDir = null;
        try {
            baseDir = new File("..").getCanonicalPath();
        }
        catch (IOException e) {
            baseDir = new File("..").getAbsolutePath();
        }
        return baseDir;
    }

    protected String getDefaultScratchDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    protected String getPlatform() {
        return this.getProperty("com.sun.phobos.platform", "undefined");
    }

    protected String getEnvironment() {
        return this.getProperty("com.sun.phobos.environment", "development");
    }

    protected ScriptingService createScriptingService() {
        return new ScriptingService();
    }

    public ScriptingService getScriptingService() {
        return this.scriptingService;
    }

    protected Framework createFramework() {
        return new PhobosFramework(this);
    }

    public void setFramework(Framework framework) {
        if (this.bootstrapped) {
            throw new IllegalStateException("framework cannot be set after bootstrap");
        }
        this.framework = framework;
    }

    protected ResponseHelper<RequestType, ResponseType> createResponseHelper() {
        return new ResponseHelper();
    }

    protected ResponseHelper<RequestType, ResponseType> getResponseHelper() {
        return this.responseHelper;
    }

    protected ResourceService createResourceService(String baseDir) {
        return new FileResourceService(baseDir);
    }

    protected DebuggerImpl createDebugger() {
        DebuggerImpl debugger = new DebuggerImpl();
        debugger.setDebugRequests(true);
        return debugger;
    }

    protected abstract RequestWrapper<RequestType> createRequestWrapper(RequestType var1);

    protected abstract ResponseWrapper<ResponseType> createResponseWrapper(ResponseType var1);

    public void setScratchDirectoryName(String s) {
        this.scratchDir = s;
    }

    public DebuggerImpl getDebugger() {
        return this.debugger;
    }

    public void setDebugger(DebuggerImpl debugger) {
        this.debugger = debugger;
    }

    public ResourceService getResourceService() {
        return this.resourceService;
    }

    public void setResourceService(ResourceService svc) {
        this.resourceService = svc;
    }

    protected void beforeBootstrap() {
    }

    protected void afterBootstrap(boolean succeeded) {
    }

    protected void beforeStartup() {
    }

    protected void afterStartup(boolean succeeded) {
    }

    protected void beforeShutdown() {
    }

    protected void afterShutdown(boolean succeeded) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(RequestType request, ResponseType response) {
        RequestWrapper<RequestType> requestWrapper = this.createRequestWrapper(request);
        ResponseWrapper<ResponseType> responseWrapper = this.createResponseWrapper(response);
        try {
            this.beforeService(requestWrapper, responseWrapper);
            if (!this.initialized && this.disableDetailedErrorPage) {
                this.responseHelper.sendErrorReply(responseWrapper, 404, "404 Not Found");
            } else if (this.enableStatusPage && requestWrapper.getRequestURI().equals("/__status__")) {
                this.responseHelper.writeStatusPage(requestWrapper, responseWrapper, this.globalContext);
            } else if (!this.framework.onService(requestWrapper, responseWrapper)) {
                this.responseHelper.sendErrorReply(responseWrapper, 404, "404 Not Found");
            }
            this.afterService(requestWrapper, responseWrapper);
        }
        catch (Throwable t) {
            this.log(t);
        }
        finally {
            this.finallyService(requestWrapper, responseWrapper);
        }
    }

    protected void beforeService(RequestWrapper<RequestType> request, ResponseWrapper<ResponseType> response) throws IOException {
    }

    protected void afterService(RequestWrapper<RequestType> request, ResponseWrapper<ResponseType> response) throws IOException {
    }

    protected void finallyService(RequestWrapper<RequestType> request, ResponseWrapper<ResponseType> response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Throwable t) {
        this.logLock.lock();
        try {
            t.printStackTrace(this.logWriter);
            this.logWriter.flush();
        }
        finally {
            this.logLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logScriptingStackTrace(Map<String, Object> requestContext) {
        StackTraceInfo info;
        StackTraceInfo stackTraceInfo = info = requestContext != null ? (StackTraceInfo)requestContext.get("stackTraceInfo") : null;
        if (info != null) {
            this.logLock.lock();
            try {
                this.logWriter.println(SCRIPTING_STACK_TRACE_HEADER + info.getCause());
                for (StackTraceInfo.Element element : info.getStackTrace()) {
                    this.logWriter.println("\tat " + element.getSourceFile() + ":" + element.getLineNumber());
                }
                this.logWriter.flush();
            }
            finally {
                this.logLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message) {
        this.logLock.lock();
        try {
            this.logWriter.println(message);
            this.logWriter.flush();
        }
        finally {
            this.logLock.unlock();
        }
    }

    void runBackgroundScript(String name) {
        this.framework.onBackground(name, null);
    }

    void runBackgroundScript(String name, String arg) {
        this.framework.onBackground(name, arg);
    }
}

