/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.mock;

import com.sun.phobos.container.AbstractMain;
import com.sun.phobos.container.mock.MockPhobosAdapter;
import com.sun.phobos.container.mock.MockRequest;
import com.sun.phobos.container.mock.MockResponse;
import java.util.Properties;

public class Main
extends AbstractMain {
    protected MockPhobosAdapter adapter;
    protected boolean running;

    public static void main(String[] args) {
        int statusCode;
        String requestURI;
        String string = requestURI = args.length > 0 ? args[0] : "/";
        if (requestURI.charAt(0) != '/') {
            requestURI = "/" + requestURI;
        }
        System.exit((statusCode = Main.runOne(requestURI)) >= 200 && statusCode < 300 ? 0 : statusCode);
    }

    public static int runOne(String requestURI) {
        int statusCode = -1;
        try {
            Main main = new Main();
            statusCode = main.run(requestURI);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return statusCode;
    }

    public Main() {
    }

    public Main(Properties properties) {
        super(properties);
    }

    public void start() {
        if (this.running) {
            throw new IllegalStateException("container already running");
        }
        String baseDir = this.getBaseDir();
        String scratchDir = this.getScratchDir();
        this.adapter = this.createAdapter();
        this.adapter.setScratchDirectoryName(scratchDir);
        this.adapter.setResourceService(this.getResourceService());
        this.adapter.setProperties(this.properties);
        this.adapter.setLogWriter(this.getLogWriter());
        this.maybeCreateDebugger();
        this.adapter.setDebugger(this.debugger);
        this.adapter.startup(baseDir);
        this.running = true;
    }

    public void stop(int delay) {
        if (!this.running) {
            throw new IllegalStateException("container is not running");
        }
        this.adapter.shutdown();
    }

    public boolean isRunning() {
        return this.running;
    }

    public MockResponse service(String requestURI) {
        return this.service(new MockRequest(requestURI));
    }

    public MockResponse service(MockRequest request) {
        if (!this.running) {
            throw new IllegalStateException("container is not running");
        }
        request.setLocalPort(this.getPortNumber());
        String contextRoot = this.getProperty("phobos.contextRoot");
        if (contextRoot == null) {
            contextRoot = "";
        }
        request.setContextPath(contextRoot);
        MockResponse response = new MockResponse();
        this.adapter.service(request, response);
        return response;
    }

    public int run(String requestURI) {
        return this.run(new MockRequest(requestURI));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(MockRequest request) {
        int result = -1;
        this.start();
        try {
            MockResponse response = this.service(request);
            result = response.getStatus();
        }
        finally {
            this.stop(0);
        }
        return result;
    }

    protected MockPhobosAdapter createAdapter() {
        return new MockPhobosAdapter();
    }
}

