/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.grizzly.impl;

import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.OutputBuffer;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.C2BConverter;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.phobos.container.grizzly.impl.ClientAbortException;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;

public class GrizzlyOutputBuffer
extends Writer
implements ByteChunk.ByteOutputChannel,
CharChunk.CharOutputChannel {
    private static Log log = LogFactory.getLog(OutputBuffer.class);
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    static final int debug = 0;
    public final int INITIAL_STATE = 0;
    public final int CHAR_STATE = 1;
    public final int BYTE_STATE = 2;
    private ByteChunk bb;
    private CharChunk cb;
    private int state = 0;
    private int bytesWritten = 0;
    private int charsWritten = 0;
    private boolean closed = false;
    private boolean doFlush = false;
    private ByteChunk outputChunk = new ByteChunk();
    private String enc;
    private boolean gotEnc = false;
    protected HashMap encoders = new HashMap();
    protected C2BConverter conv;
    private Response coyoteResponse;
    private boolean suspended = false;
    private ByteBuffer byteBuffer;
    private boolean enableCache = false;

    public GrizzlyOutputBuffer() {
        this(8192);
    }

    public GrizzlyOutputBuffer(boolean chunkingDisabled) {
        this(8192, chunkingDisabled);
    }

    public GrizzlyOutputBuffer(int size) {
        this(size, false);
    }

    public GrizzlyOutputBuffer(int size, boolean chunkingDisabled) {
        this.bb = new ByteChunk(size);
        if (!chunkingDisabled) {
            this.bb.setLimit(size);
        }
        this.bb.setByteOutputChannel((ByteChunk.ByteOutputChannel)this);
        this.cb = new CharChunk(size);
        this.cb.setCharOutputChannel((CharChunk.CharOutputChannel)this);
        if (!chunkingDisabled) {
            this.cb.setLimit(size);
        }
    }

    public void setResponse(Response coyoteResponse) {
        this.coyoteResponse = coyoteResponse;
    }

    public Response getResponse() {
        return this.coyoteResponse;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public void recycle() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"recycle()");
        }
        this.state = 0;
        this.bytesWritten = 0;
        this.charsWritten = 0;
        this.cb.recycle();
        this.bb.recycle();
        this.closed = false;
        this.suspended = false;
        if (this.conv != null) {
            this.conv.recycle();
        }
        this.gotEnc = false;
        this.enc = null;
        if (this.enableCache) {
            this.byteBuffer.clear();
        }
        this.enableCache = false;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.suspended) {
            return;
        }
        if (!this.coyoteResponse.isCommitted() && this.coyoteResponse.getContentLength() == -1) {
            if (this.state == 1) {
                this.cb.flushBuffer();
                this.state = 2;
            }
            if (!this.coyoteResponse.isCommitted()) {
                this.coyoteResponse.setContentLength(this.bb.getLength());
            }
        }
        this.doFlush(false);
        this.closed = true;
        this.coyoteResponse.finish();
    }

    public void flush() throws IOException {
        this.doFlush(true);
    }

    protected void doFlush(boolean realFlush) throws IOException {
        if (this.suspended) {
            return;
        }
        this.doFlush = true;
        if (this.state == 1) {
            this.cb.flushBuffer();
            this.bb.flushBuffer();
            this.state = 2;
        } else if (this.state == 2) {
            this.bb.flushBuffer();
        } else if (this.state == 0) {
            this.coyoteResponse.sendHeaders();
        }
        this.doFlush = false;
        if (realFlush) {
            this.coyoteResponse.action(ActionCode.ACTION_CLIENT_FLUSH, (Object)this.coyoteResponse);
            if (this.coyoteResponse.isExceptionPresent()) {
                throw new ClientAbortException(this.coyoteResponse.getErrorException());
            }
        }
    }

    public void realWriteBytes(byte[] buf, int off, int cnt) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("realWrite(b, " + off + ", " + cnt + ") " + this.coyoteResponse));
        }
        if (this.closed) {
            return;
        }
        if (this.coyoteResponse == null) {
            return;
        }
        if (cnt > 0) {
            this.outputChunk.setBytes(buf, off, cnt);
            try {
                this.coyoteResponse.doWrite(this.outputChunk);
            }
            catch (IOException e) {
                throw new ClientAbortException(e);
            }
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.state == 1) {
            this.cb.flushBuffer();
        }
        this.state = 2;
        this.writeBytes(b, off, len);
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"write(b,off,len)");
        }
        if (this.enableCache) {
            this.makeSpace(len);
            this.byteBuffer.put(b, off, len);
        }
        this.bb.append(b, off, len);
        this.bytesWritten += len;
        if (this.doFlush) {
            this.bb.flushBuffer();
        }
    }

    public void writeByte(int b) throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.state == 1) {
            this.cb.flushBuffer();
        }
        this.state = 2;
        if (log.isDebugEnabled()) {
            log.debug((Object)"write(b)");
        }
        if (this.enableCache) {
            this.makeSpace(1);
            this.byteBuffer.put((byte)b);
        }
        this.bb.append((byte)b);
        ++this.bytesWritten;
    }

    public void write(int c) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)"writeChar(b)");
        }
        if (this.enableCache) {
            this.makeSpace(1);
            this.byteBuffer.putChar((char)c);
        }
        this.cb.append((char)c);
        ++this.charsWritten;
    }

    public void write(char[] c) throws IOException {
        if (this.suspended) {
            return;
        }
        this.write(c, 0, c.length);
    }

    public void write(char[] c, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)("write(c,off,len)" + this.cb.getLength() + " " + this.cb.getLimit()));
        }
        if (this.enableCache) {
            this.makeSpace(len);
            this.byteBuffer.put(new String(c).getBytes(), off, len);
        }
        this.cb.append(c, off, len);
        this.charsWritten += len;
    }

    public void write(StringBuffer sb) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)"write(s,off,len)");
        }
        int len = sb.length();
        this.charsWritten += len;
        if (this.enableCache) {
            byte[] bytes = sb.toString().getBytes();
            this.makeSpace(bytes.length);
            this.byteBuffer.put(bytes);
        }
        this.cb.append(sb);
    }

    public void write(String s, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)"write(s,off,len)");
        }
        this.charsWritten += len;
        if (s == null) {
            s = "null";
        }
        if (this.enableCache) {
            this.makeSpace(len);
            this.byteBuffer.put(s.getBytes(), off, len);
        }
        this.cb.append(s, off, len);
    }

    public void write(String s) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        if (s == null) {
            s = "null";
        }
        this.write(s, 0, s.length());
    }

    public void flushChars() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("flushChars() " + this.cb.getLength()));
        }
        this.cb.flushBuffer();
        this.state = 2;
    }

    public boolean flushCharsNeeded() {
        return this.state == 1;
    }

    public void setEncoding(String s) {
        this.enc = s;
    }

    public void realWriteChars(char[] c, int off, int len) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("realWrite(c,o,l) " + this.cb.getOffset() + " " + len));
        }
        if (!this.gotEnc) {
            this.setConverter();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("encoder:  " + this.conv + " " + this.gotEnc));
        }
        this.conv.convert(c, off, len);
        this.conv.flushBuffer();
    }

    public void checkConverter() throws IOException {
        if (!this.gotEnc) {
            this.setConverter();
        }
    }

    protected void setConverter() throws IOException {
        if (this.coyoteResponse != null) {
            this.enc = this.coyoteResponse.getCharacterEncoding();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got encoding: " + this.enc));
        }
        this.gotEnc = true;
        if (this.enc == null) {
            this.enc = DEFAULT_ENCODING;
        }
        this.conv = (C2BConverter)this.encoders.get(this.enc);
        if (this.conv == null) {
            if (System.getSecurityManager() != null) {
                try {
                    this.conv = (C2BConverter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return new C2BConverter(GrizzlyOutputBuffer.this.bb, GrizzlyOutputBuffer.this.enc);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    Exception e = ex.getException();
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("setConverter: " + ex.getMessage()));
                    }
                }
            } else {
                this.conv = new C2BConverter(this.bb, this.enc);
            }
            this.encoders.put(this.enc, this.conv);
        }
    }

    public void flushBytes() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("flushBytes() " + this.bb.getLength()));
        }
        this.bb.flushBuffer();
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public int getCharsWritten() {
        return this.charsWritten;
    }

    public int getContentWritten() {
        return this.bytesWritten + this.charsWritten;
    }

    public boolean isNew() {
        return this.bytesWritten == 0 && this.charsWritten == 0;
    }

    public void setBufferSize(int size) {
        if (size > this.bb.getLimit()) {
            this.bb.setLimit(size);
        }
    }

    public void reset() {
        this.bb.recycle();
        this.bytesWritten = 0;
        this.cb.recycle();
        this.charsWritten = 0;
        this.gotEnc = false;
        this.enc = null;
        if (this.enableCache) {
            this.byteBuffer.clear();
        }
        this.enableCache = false;
    }

    public int getBufferSize() {
        return this.bb.getLimit();
    }

    public void enableCache(boolean enableCache) {
        this.enableCache = enableCache;
        if (enableCache && this.byteBuffer == null) {
            this.byteBuffer = ByteBuffer.allocate(this.bb.getLimit());
        }
    }

    public ByteBuffer getCachedByteBuffer() {
        ByteBuffer cache = ByteBuffer.allocate(this.byteBuffer.position());
        this.byteBuffer.flip();
        cache.put(this.byteBuffer);
        return cache;
    }

    private void makeSpace(int size) {
        int capacity = this.byteBuffer.capacity();
        if (this.byteBuffer.position() + size > capacity) {
            ByteBuffer tmp = ByteBuffer.allocate(capacity * 2);
            this.byteBuffer.flip();
            tmp.put(this.byteBuffer);
            this.byteBuffer = tmp;
        }
    }
}

