/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.debug;

import com.sun.phobos.container.PhobosRuntime;
import com.sun.phobos.container.debug.ExceptionThrownDebugEventImpl;
import com.sun.phobos.container.debug.StackTraceInfo;
import com.sun.phobos.debug.AttachedDebugEvent;
import com.sun.phobos.debug.DebugEvent;
import com.sun.phobos.debug.DebugEventVisitor;
import com.sun.phobos.debug.DebugFrame;
import com.sun.phobos.debug.DebuggerListener;
import com.sun.phobos.debug.DetachedDebugEvent;
import com.sun.phobos.debug.ExceptionThrownDebugEvent;
import com.sun.phobos.debug.FrameEnteredDebugEvent;
import com.sun.phobos.debug.FrameExitedDebugEvent;
import com.sun.phobos.debug.LineChangedDebugEvent;
import com.sun.phobos.script.util.ExtendedScriptException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.mozilla.javascript.WrappedException;

public class StackTraceRecordingDebuggerListener
implements DebuggerListener,
DebugEventVisitor {
    public void onEvent(DebugEvent event) {
        try {
            event.accept((DebugEventVisitor)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void visitAttached(AttachedDebugEvent event) {
    }

    public void visitDetached(DetachedDebugEvent event) {
    }

    public void visitFrameEntered(FrameEnteredDebugEvent event) {
    }

    public void visitFrameExited(FrameExitedDebugEvent event) {
    }

    public void visitLineChanged(LineChangedDebugEvent event) {
    }

    public void visitExceptionThrown(ExceptionThrownDebugEvent event) {
        if (!(event instanceof ExceptionThrownDebugEventImpl)) {
            return;
        }
        ExceptionThrownDebugEventImpl event2 = (ExceptionThrownDebugEventImpl)event;
        StackTraceInfo info = this.getStackTraceInfo();
        Throwable oldException = info != null ? info.getCause() : null;
        LinkedList callStack = event.getDebuggerContext().getCallStack();
        Throwable newException = event2.getExceptionObject();
        if (newException instanceof WrappedException) {
            Throwable cause = ((WrappedException)newException).getWrappedException();
            if (cause instanceof ExtendedScriptException) {
                cause = ((ExtendedScriptException)cause).getCause();
            }
            newException = cause;
        }
        if (newException == oldException) {
            return;
        }
        info = new StackTraceInfo(newException);
        ArrayList<StackTraceInfo.Element> stackTrace = new ArrayList<StackTraceInfo.Element>();
        for (DebugFrame frame : callStack) {
            StackTraceInfo.Element element = new StackTraceInfo.Element(frame.getSourceFile(), frame.getLineNumber());
            stackTrace.add(element);
        }
        info.setStackTrace(stackTrace);
        this.setStackTraceInfo(info);
    }

    private StackTraceInfo getStackTraceInfo() {
        return (StackTraceInfo)PhobosRuntime.getRequestContext().get("stackTraceInfo");
    }

    private void setStackTraceInfo(StackTraceInfo info) {
        PhobosRuntime.getRequestContext().put("stackTraceInfo", info);
    }
}

