/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.mock;

import com.sun.phobos.container.mock.Cookies;
import com.sun.phobos.container.util.Cookie;
import com.sun.phobos.container.util.Enumerator;
import com.sun.phobos.container.util.FastHttpDateFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockRequest {
    private boolean cookiesParsed;
    private boolean parametersParsed;
    private Cookie[] cookies;
    private Map<String, List<String>> parameters;
    private SimpleDateFormat[] formats;
    private String requestURI;
    private String queryString;
    private String charEncoding;
    private boolean gotReader;
    private boolean gotStream;
    private Reader reader;
    private InputStream inputStream;
    private Map attributes;
    private String scheme;
    private String protocol;
    private String contextPath;
    private Map<String, List<String>> headers;
    private boolean secure;
    private String localAddr;
    private String localName;
    private int localPort;
    private String method;
    private byte[] bodyAsBytes;
    private String bodyAsString;
    private static ThreadLocal staticDateFormats = new ThreadLocal(){

        protected Object initialValue() {
            SimpleDateFormat[] f = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
            return f;
        }
    };
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private static final String APPLICATION_X_WWW_FORM_URLENCODED_MEDIA_TYPE = "application/x-www-form-urlencoded";

    public MockRequest() {
        this("/");
    }

    public MockRequest(String requestURI) {
        this.requestURI = requestURI;
        this.cookiesParsed = false;
        this.formats = (SimpleDateFormat[])staticDateFormats.get();
        this.formats[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[1].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[2].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.scheme = "http";
        this.protocol = "HTTP/1.1";
        this.method = "GET";
        this.contextPath = "";
        this.headers = new HashMap<String, List<String>>();
        this.secure = false;
        this.localAddr = "127.0.0.1";
        this.localName = "localhost";
        this.localPort = 80;
        this.attributes = new HashMap();
        this.gotReader = false;
        this.gotStream = false;
        this.parseRequestURI();
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
        this.parseRequestURI();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public Enumeration getHeaderNames() {
        return new Enumerator<String>(this.headers.keySet());
    }

    public String getHeader(String name) {
        Enumeration values = this.getHeaders(name);
        return values.hasMoreElements() ? (String)values.nextElement() : null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public String getRemoteAddr() {
        return this.localAddr;
    }

    public String getRemoteHost() {
        return this.localName;
    }

    public int getRemotePort() {
        return this.localPort;
    }

    public String getServerName() {
        String host = this.getHeader("Host");
        if (host != null) {
            int i = host.indexOf(58);
            if (i == -1) {
                return host;
            }
            return host.substring(0, i);
        }
        return this.getLocalAddr();
    }

    public int getServerPort() {
        return this.localPort;
    }

    public void setBodyAsBytes(byte[] bodyAsBytes) {
        this.bodyAsBytes = bodyAsBytes;
    }

    public void setBodyAsString(String bodyAsString) {
        this.bodyAsString = bodyAsString;
    }

    public Reader getReader() throws IOException {
        if (this.gotStream) {
            throw new IllegalStateException("getReader called previously");
        }
        this.gotReader = true;
        if (this.bodyAsString != null) {
            return new StringReader(this.bodyAsString);
        }
        String enc = this.getCharacterEncoding();
        if (enc == null) {
            enc = DEFAULT_CHARACTER_ENCODING;
        }
        this.reader = new InputStreamReader((InputStream)new ByteArrayInputStream(this.bodyAsBytes == null ? new byte[]{} : this.bodyAsBytes), enc);
        return this.reader;
    }

    public InputStream getInputStream() {
        if (this.gotReader) {
            throw new IllegalStateException("getWriter called previously");
        }
        this.gotStream = true;
        if (this.bodyAsString != null) {
            String enc = this.getCharacterEncoding();
            if (enc == null) {
                enc = DEFAULT_CHARACTER_ENCODING;
            }
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            try {
                PrintStream ps = new PrintStream((OutputStream)bas, false, enc);
                ps.append(this.bodyAsString);
                ps.flush();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.inputStream = new ByteArrayInputStream(bas.toByteArray());
            return this.inputStream;
        }
        this.inputStream = new ByteArrayInputStream(this.bodyAsBytes == null ? new byte[]{} : this.bodyAsBytes);
        return this.inputStream;
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = FastHttpDateFormat.parseDate(value, this.formats);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    public Enumeration getHeaders(String name) {
        return new Enumerator((Iterable)this.headers.get(name));
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Cookie[] getCookies() {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        return this.cookies;
    }

    public String getParameter(String name) {
        List<String> values;
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        if ((values = this.parameters.get(name)) == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public String[] getParameterValues(String name) {
        List<String> values;
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        if ((values = this.parameters.get(name)) == null) {
            return null;
        }
        return values.toArray(EMPTY_STRING_ARRAY);
    }

    public Enumeration getParameterNames() {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return new Enumerator<String>(this.parameters.keySet());
    }

    public Map getParameterMap() {
        throw new UnsupportedOperationException();
    }

    public int getContentLength() {
        try {
            String value = this.getHeader("Content-length");
            if (value == null) {
                return -1;
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getContentType() {
        return this.getHeader("Content-type");
    }

    public String getCharacterEncoding() {
        if (this.charEncoding != null) {
            return this.charEncoding;
        }
        String type = this.getContentType();
        if (type == null) {
            return null;
        }
        int semicolonIndex = -1;
        boolean hasCharset = false;
        int len = type.length();
        int index = type.indexOf(59);
        while (index != -1) {
            semicolonIndex = index++;
            while (index < len && Character.isSpace(type.charAt(index))) {
                ++index;
            }
            if (index + 8 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                hasCharset = true;
                break;
            }
            index = type.indexOf(59, index);
        }
        if (!hasCharset) {
            return null;
        }
        String tail = type.substring(index + 8);
        int nextParam = tail.indexOf(59);
        String charsetValue = null;
        charsetValue = nextParam != -1 ? tail.substring(0, nextParam) : tail;
        if (charsetValue != null && charsetValue.length() > 0) {
            this.charEncoding = charsetValue.replace('\"', ' ').trim();
        }
        return this.charEncoding;
    }

    public void setCharacterEncoding(String enc) {
        this.charEncoding = enc;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Enumeration getAttributeNames() {
        return new Enumerator(this.attributes.keySet());
    }

    private void parseCookies() {
        this.cookiesParsed = true;
        Cookies serverCookies = new Cookies(this.headers);
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        this.cookies = new Cookie[count];
        int idx = 0;
        for (int i = 0; i < count; ++i) {
            Cookie scookie = serverCookies.getCookie(i);
            try {
                Cookie cookie = new Cookie(scookie.getName(), scookie.getValue());
                cookie.setPath(scookie.getPath());
                cookie.setVersion(scookie.getVersion());
                if (scookie.getDomain() != null) {
                    cookie.setDomain(scookie.getDomain());
                }
                this.cookies[idx++] = cookie;
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (idx < count) {
            Cookie[] ncookies = new Cookie[idx];
            System.arraycopy(this.cookies, 0, ncookies, 0, idx);
            this.cookies = ncookies;
        }
    }

    private void parseParameters() {
        this.parametersParsed = true;
        this.parameters = new HashMap<String, List<String>>();
        this.parseQueryParameters();
        this.parseBodyParameters();
    }

    private void parseQueryParameters() {
        this.parseAsParameters(this.getQueryString());
    }

    private void parseBodyParameters() {
        if (this.getMethod().equals("POST")) {
            String type = this.getContentType();
            int i = type.indexOf(";");
            if (i != -1) {
                type = type.substring(0, i);
            }
            if (type.equals(APPLICATION_X_WWW_FORM_URLENCODED_MEDIA_TYPE)) {
                String enc = this.getCharacterEncoding();
                if (enc == null) {
                    enc = DEFAULT_CHARACTER_ENCODING;
                }
                StringBuilder sb = new StringBuilder();
                char[] buffer = new char[1024];
                try {
                    int len;
                    Reader r = this.getReader();
                    while ((len = r.read(buffer)) != -1) {
                        sb.append(buffer, 0, len);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                String s = sb.toString();
                try {
                    this.parseAsParameters(URLDecoder.decode(s, enc));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    private void parseAsParameters(String str) {
        int nameStart;
        int nameEnd;
        if (str == null) {
            return;
        }
        int len = str.length();
        for (int i = 0; i < len && (nameEnd = str.indexOf(61, nameStart = i)) != -1; ++i) {
            String value;
            int valEnd;
            int nextAmpersand = str.indexOf(38, nameStart);
            if (nextAmpersand != (valEnd = str.indexOf(38, nameEnd))) {
                i = nextAmpersand + 1;
                continue;
            }
            String name = str.substring(nameStart, nameEnd);
            if (valEnd == -1) {
                value = str.substring(nameEnd + 1);
                i = len;
            } else {
                value = str.substring(nameEnd + 1, valEnd);
                i = valEnd++;
            }
            this.addParameter(name, value);
        }
    }

    private void addParameter(String name, String value) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.parameters.put(name, values);
        }
        values.add(value);
    }

    private void parseRequestURI() {
        try {
            URI uri = new URI(this.requestURI);
            this.requestURI = uri.getPath();
            this.queryString = uri.getQuery();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

