/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container;

import com.sun.phobos.container.FileResourceService;
import com.sun.phobos.container.MappableFileResourceService;
import com.sun.phobos.container.ResourceService;
import com.sun.phobos.container.debug.DebuggerImpl;
import com.sun.phobos.debug.Debugger;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Properties;

public abstract class AbstractMain {
    public static final int DEFAULT_PHOBOS_PORT = 8888;
    public static final String DEFAULT_PHOBOS_BASE_DIRECTORY = ".";
    protected Properties properties;
    protected DebuggerImpl debugger;
    protected PrintWriter logWriter;

    protected AbstractMain() {
    }

    protected AbstractMain(Properties properties) {
        this.properties = properties;
    }

    public abstract void start();

    public void stop() {
        this.stop(0);
    }

    public abstract void stop(int var1);

    public synchronized PrintWriter getLogWriter() {
        if (this.logWriter == null) {
            this.logWriter = new PrintWriter(new OutputStreamWriter(System.err));
        }
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter writer) {
        this.logWriter = writer;
    }

    protected String getBaseDir() {
        String dir = this.getProperty("phobos.home");
        if (dir == null) {
            dir = DEFAULT_PHOBOS_BASE_DIRECTORY;
        }
        return dir;
    }

    protected String getScratchDir() {
        String dir = this.getProperty("phobos.tmp");
        if (dir == null) {
            dir = this.getBaseDir() + File.separator + "tmp";
        }
        return dir;
    }

    protected int getPortNumber() {
        int port = 8888;
        try {
            int configuredPort = Integer.parseInt(this.getProperty("phobos.port"));
            if (configuredPort > 0) {
                port = configuredPort;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return port;
    }

    protected String getProperty(String key) {
        String value = null;
        if (this.properties != null) {
            value = this.properties.getProperty(key);
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    protected ResourceService getResourceService() {
        FileResourceService resourceService;
        String appDir = this.getProperty("phobos.applicationDir");
        String envDir = this.getProperty("phobos.environmentDir");
        String frameworkDir = this.getProperty("phobos.frameworkDir");
        String staticDir = this.getProperty("phobos.staticDir");
        if (appDir == null && envDir == null && frameworkDir == null && staticDir == null) {
            resourceService = new FileResourceService(this.getBaseDir());
        } else {
            HashMap<String, String> prefixMap = new HashMap<String, String>();
            if (appDir != null) {
                prefixMap.put("application", appDir);
            }
            if (envDir != null) {
                prefixMap.put("environment", envDir);
            }
            if (frameworkDir != null) {
                prefixMap.put("framework", frameworkDir);
            }
            if (staticDir != null) {
                prefixMap.put("static", staticDir);
            }
            resourceService = new MappableFileResourceService(this.getBaseDir(), prefixMap);
        }
        return resourceService;
    }

    public Debugger getDebugger() {
        this.maybeCreateDebugger();
        return this.debugger;
    }

    protected void maybeCreateDebugger() {
        if (this.debugger == null && "true".equals(this.getProperty("com.sun.phobos.container.useDebugger"))) {
            this.debugger = new DebuggerImpl();
        }
    }

    public synchronized void log(Throwable t) {
        PrintWriter writer = this.getLogWriter();
        t.printStackTrace(writer);
        writer.flush();
    }
}

