/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.simple;

import com.sun.net.httpserver.HttpExchange;
import com.sun.phobos.container.ResponseWrapper;
import com.sun.phobos.container.util.Cookie;
import com.sun.phobos.container.util.FastHttpDateFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleResponseWrapper
extends ResponseWrapper<HttpExchange> {
    protected SimpleDateFormat format = null;
    private int statusCode;
    private int contentLength;
    private Locale locale;
    private String contentType;
    private String characterEncoding;
    private String quotedCharsetValue;
    private boolean charsetSet;
    private boolean headersSent;
    private boolean exchangeTerminated;
    private boolean gotWriter;
    private boolean gotStream;
    private PrintWriter writer;
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";

    public SimpleResponseWrapper(HttpExchange response) {
        super(response);
        this.init();
    }

    protected void init() {
        this.statusCode = 200;
        this.contentLength = 0;
        this.quotedCharsetValue = this.characterEncoding = DEFAULT_CHARACTER_ENCODING;
        this.locale = DEFAULT_LOCALE;
        this.headersSent = false;
        this.exchangeTerminated = false;
        this.charsetSet = false;
        this.gotWriter = false;
        this.gotStream = false;
    }

    @Override
    public Object getResponseObject() {
        return this;
    }

    public void addCookie(Cookie cookie) {
        StringBuffer sb = new StringBuffer();
        Cookie.appendCookieValue(sb, cookie.getVersion(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure());
        this.addHeader("Set-Cookie", sb.toString());
    }

    public void addDateHeader(String name, long value) {
        if (this.format == null) {
            this.format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.addHeader(name, FastHttpDateFormat.formatDate(value, this.format));
    }

    public void addHeader(String name, String value) {
        ((HttpExchange)this.response).getResponseHeaders().add(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public boolean containsHeader(String name) {
        return ((HttpExchange)this.response).getResponseHeaders().containsKey(name);
    }

    public void sendError(int sc) throws IOException {
        if (this.headersSent) {
            throw new IllegalStateException("headers already sent");
        }
        this.statusCode = sc;
        this.contentLength = -1;
        this.sendHeaders();
        this.terminateExchange();
    }

    public void setDateHeader(String name, long date) {
        if (this.format == null) {
            this.format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.setHeader(name, FastHttpDateFormat.formatDate(date, this.format));
    }

    public void setHeader(String name, String value) {
        ((HttpExchange)this.response).getResponseHeaders().set(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    @Override
    public void setStatus(int code) {
        this.statusCode = code;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public String getContentType() {
        String ret = this.contentType;
        if (ret != null && this.quotedCharsetValue != null && this.charsetSet) {
            ret = ret + ";charset=" + this.quotedCharsetValue;
        }
        return ret;
    }

    @Override
    public void setContentType(String type) {
        int semicolonIndex = -1;
        if (type == null) {
            this.contentType = null;
            return;
        }
        boolean hasCharset = false;
        int len = type.length();
        int index = type.indexOf(59);
        while (index != -1) {
            semicolonIndex = index++;
            while (index < len && Character.isSpace(type.charAt(index))) {
                ++index;
            }
            if (index + 8 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                hasCharset = true;
                break;
            }
            index = type.indexOf(59, index);
        }
        if (!hasCharset) {
            this.contentType = type;
            return;
        }
        this.contentType = type.substring(0, semicolonIndex);
        String tail = type.substring(index + 8);
        int nextParam = tail.indexOf(59);
        String charsetValue = null;
        if (nextParam != -1) {
            this.contentType = this.contentType + tail.substring(nextParam);
            charsetValue = tail.substring(0, nextParam);
        } else {
            charsetValue = tail;
        }
        if (charsetValue != null && charsetValue.length() > 0) {
            this.charsetSet = true;
            this.quotedCharsetValue = charsetValue;
            this.characterEncoding = charsetValue.replace('\"', ' ').trim();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.gotWriter) {
            throw new IllegalStateException("getWriter called previously");
        }
        this.gotStream = true;
        this.sendHeaders();
        return ((HttpExchange)this.response).getResponseBody();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String charset) {
        if (charset == null) {
            return;
        }
        this.characterEncoding = charset;
        this.quotedCharsetValue = charset;
        this.charsetSet = true;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.gotStream) {
            throw new IllegalStateException("getStream called previously");
        }
        this.gotWriter = true;
        this.sendHeaders();
        this.writer = new PrintWriter(((HttpExchange)this.response).getResponseBody());
        return this.writer;
    }

    public void flushBuffer() {
    }

    public int getBufferSize() {
        return 0;
    }

    public void setBufferSize(int size) {
        if (this.headersSent) {
            throw new IllegalStateException("headers already sent");
        }
    }

    @Override
    public boolean isCommitted() {
        return this.headersSent;
    }

    @Override
    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("response already committed");
        }
        this.init();
        ((HttpExchange)this.response).getResponseHeaders().clear();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("response already committed");
        }
    }

    private void sendHeaders() throws IOException {
        if (!this.headersSent) {
            if (this.contentType != null) {
                ((HttpExchange)this.response).getResponseHeaders().add("Content-Type", this.contentType);
            }
            ((HttpExchange)this.response).sendResponseHeaders(this.statusCode, this.contentLength);
            this.headersSent = true;
        }
    }

    public void terminateExchange() {
        try {
            if (!this.exchangeTerminated) {
                this.sendHeaders();
                ((HttpExchange)this.response).close();
                this.exchangeTerminated = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

