/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.simple;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import com.sun.phobos.container.AbstractMain;
import com.sun.phobos.container.simple.SimplePhobosAdapter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Properties;

public class Main
extends AbstractMain {
    protected HttpServer server;
    protected HttpContext context;
    protected SimplePhobosAdapter adapter;

    public static void main(String[] args) {
        try {
            final Main main = new Main();
            Thread thread = new Thread(){

                public void run() {
                    try {
                        main.start();
                    }
                    catch (Exception e) {
                        main.log(e);
                    }
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                main.log(e);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Main() {
    }

    public Main(Properties properties) {
        super(properties);
    }

    public void start() {
        String baseDir = this.getBaseDir();
        String scratchDir = this.getScratchDir();
        int portNumber = this.getPortNumber();
        try {
            this.server = HttpServer.create(new InetSocketAddress(portNumber), 0);
        }
        catch (IOException e) {
            throw new RuntimeException("cannot create server", e);
        }
        this.context = this.server.createContext("/");
        this.adapter = this.createAdapter();
        this.adapter.setScratchDirectoryName(scratchDir);
        this.adapter.setResourceService(this.getResourceService());
        this.adapter.setProperties(this.properties);
        this.adapter.setLogWriter(this.getLogWriter());
        this.maybeCreateDebugger();
        this.adapter.setDebugger(this.debugger);
        this.adapter.startup(baseDir);
        this.context.setHandler(this.adapter);
        this.server.start();
    }

    public void stop(int delay) {
        this.server.stop(delay);
        this.adapter.shutdown();
    }

    protected SimplePhobosAdapter createAdapter() {
        return new SimplePhobosAdapter();
    }
}

