/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.debug;

import com.sun.phobos.container.PhobosAdapter;
import com.sun.phobos.container.PhobosRuntime;
import com.sun.phobos.container.debug.ComplexDebugObjectImpl;
import com.sun.phobos.container.debug.DebuggerImpl;
import com.sun.phobos.container.debug.SimpleDebugObjectImpl;
import com.sun.phobos.debug.ComplexDebugObject;
import com.sun.phobos.debug.DebugEvent;
import com.sun.phobos.debug.DebugFrame;
import com.sun.phobos.debug.DebugObject;
import com.sun.phobos.debug.Debugger;
import com.sun.phobos.debug.DebuggerContext;
import com.sun.phobos.debug.SimpleDebugObject;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import javax.script.Bindings;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggerContextImpl
implements DebuggerContext {
    private DebuggerImpl debugger;
    private Context cx;
    private LinkedList<DebugFrame> callStack;
    private DebuggerContext.Type type;
    private String requestURI;
    private Map<Object, DebugObject> debugObjectCache;
    private Map<String, Object> savedGlobalContext;
    private Map<String, Object> savedRequestContext;
    private PhobosAdapter savedAdapter;
    private Bindings savedBindings;
    private ThreadLocal<Boolean> attached;
    private boolean suppressEvents;
    static ThreadLocal<Boolean> suppressDebugAttach = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public DebuggerContextImpl(DebuggerImpl debugger, Context cx, DebuggerContext.Type type, String requestURI) {
        this.debugger = debugger;
        this.cx = cx;
        this.type = type;
        this.requestURI = requestURI;
        this.callStack = new LinkedList();
        this.debugObjectCache = new WeakHashMap<Object, DebugObject>();
        this.suppressEvents = false;
        this.savedGlobalContext = PhobosRuntime.getGlobalContext();
        this.savedRequestContext = PhobosRuntime.getRequestContext();
        this.savedAdapter = PhobosRuntime.getCurrentAdapter();
        this.savedBindings = PhobosRuntime.getCurrentEngineBindings();
        this.attached = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
    }

    public Context getContext() {
        return this.cx;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public DebuggerContext.Type getType() {
        return this.type;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public LinkedList<DebugFrame> getCallStack() {
        return this.callStack;
    }

    public DebugObject createDebugObject(Object obj) {
        if (obj == null) {
            return null;
        }
        Object result = null;
        DebugObject cachedObject = this.debugObjectCache.get(obj);
        if (obj instanceof Scriptable) {
            String digest;
            String oldDigest;
            ComplexDebugObjectImpl debugObject = new ComplexDebugObjectImpl(this, (Scriptable)obj);
            boolean useCached = false;
            if (cachedObject != null && cachedObject instanceof ComplexDebugObject && (oldDigest = ((ComplexDebugObject)cachedObject).getPropertyNamesDigest()).equals(digest = debugObject.getPropertyNamesDigest())) {
                useCached = true;
            }
            if (useCached) {
                result = cachedObject;
            } else {
                this.debugObjectCache.put(obj, (DebugObject)debugObject);
                result = debugObject;
            }
        } else if (cachedObject == null) {
            result = this.createSimpleDebugObject(obj);
            this.debugObjectCache.put(obj, (DebugObject)result);
        } else {
            result = cachedObject;
        }
        return result;
    }

    private SimpleDebugObject createSimpleDebugObject(Object obj) {
        return new SimpleDebugObjectImpl(obj);
    }

    public <T> T performInContext(Callable<T> callable) {
        return this.performInContext(callable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T performInContext(Callable<T> callable, boolean suppressEvents) {
        if (!this.attached.get().booleanValue()) {
            if (PhobosRuntime.getCurrentAdapter() == null) {
                PhobosRuntime.setGlobalContext(this.savedGlobalContext);
                PhobosRuntime.setRequestContext(this.savedRequestContext);
                PhobosRuntime.setCurrentEngineBindings(this.savedBindings);
                PhobosRuntime.setCurrentAdapter(this.savedAdapter);
            }
            this.attached.set(true);
        }
        boolean oldSuppressEvents = this.suppressEvents;
        this.suppressEvents = suppressEvents;
        try {
            Boolean oldSuppressDebugAttach = suppressDebugAttach.get();
            suppressDebugAttach.set(suppressEvents);
            try {
                DebuggerContextImpl debuggerContextImpl = this;
                debuggerContextImpl.cx.enter();
            }
            finally {
                suppressDebugAttach.set(oldSuppressDebugAttach);
            }
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DebuggerContextImpl debuggerContextImpl = this;
            debuggerContextImpl.cx.exit();
            this.suppressEvents = oldSuppressEvents;
        }
    }

    public void fireDebugEvent(DebugEvent event) {
        if (!this.suppressEvents) {
            this.debugger.fireDebugEvent(event);
        }
    }
}

