/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.debug;

import com.sun.phobos.container.debug.DebuggerContextImpl;
import com.sun.phobos.debug.ComplexDebugObject;
import com.sun.phobos.debug.DebugObject;
import com.sun.phobos.debug.SimpleDebugObject;
import java.util.concurrent.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebuggableObject;

public class ComplexDebugObjectImpl
implements ComplexDebugObject {
    private DebuggerContextImpl debuggerContext;
    private Scriptable scriptable;
    private String className;
    private Object[] propertyNames;
    private String propertyNamesDigest;
    private static final String PROTOTYPE_PROPERTY = "(prototype)";
    private static final String PARENT_SCOPE_PROPERTY = "(parent scope)";
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public ComplexDebugObjectImpl(DebuggerContextImpl debuggerContext, Scriptable scriptable) {
        this.debuggerContext = debuggerContext;
        this.scriptable = scriptable;
    }

    Scriptable getScriptable() {
        return this.scriptable;
    }

    public Object[] getPropertyNames() {
        if (this.propertyNames == null) {
            try {
                Object[] currentPropertyNames = this.debuggerContext.performInContext(new Callable<Object[]>(){

                    @Override
                    public Object[] call() {
                        return ComplexDebugObjectImpl.this.scriptable instanceof DebuggableObject ? ((DebuggableObject)ComplexDebugObjectImpl.this.scriptable).getAllIds() : ComplexDebugObjectImpl.this.scriptable.getIds();
                    }
                });
                boolean hasParentScope = this.debuggerContext.performInContext(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return ComplexDebugObjectImpl.this.scriptable.getParentScope() != null;
                    }
                });
                boolean hasPrototype = this.debuggerContext.performInContext(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return ComplexDebugObjectImpl.this.scriptable.getPrototype() != null;
                    }
                });
                int propertyCount = currentPropertyNames.length;
                Object[] extendedPropertyNames = new Object[currentPropertyNames.length + (hasPrototype ? 1 : 0) + (hasParentScope ? 1 : 0)];
                System.arraycopy(currentPropertyNames, 0, extendedPropertyNames, 0, propertyCount);
                if (hasParentScope) {
                    extendedPropertyNames[propertyCount++] = PARENT_SCOPE_PROPERTY;
                }
                if (hasPrototype) {
                    extendedPropertyNames[propertyCount++] = PROTOTYPE_PROPERTY;
                }
                this.propertyNames = extendedPropertyNames;
            }
            catch (Throwable t) {
                this.propertyNames = EMPTY_ARRAY;
            }
        }
        return this.propertyNames;
    }

    public String getPropertyNamesDigest() {
        if (this.propertyNamesDigest == null) {
            StringBuilder builder = new StringBuilder();
            for (Object propertyName : this.getPropertyNames()) {
                builder.append(propertyName.toString());
                builder.append("|");
            }
            this.propertyNamesDigest = builder.toString();
        }
        return this.propertyNamesDigest;
    }

    public DebugObject getPropertyValue(final Object key) {
        try {
            Object value = Scriptable.NOT_FOUND;
            if (key instanceof String) {
                value = key.equals(PARENT_SCOPE_PROPERTY) ? this.debuggerContext.performInContext(new Callable<Object>(){

                    @Override
                    public Object call() {
                        return ComplexDebugObjectImpl.this.scriptable.getParentScope();
                    }
                }) : (key.equals(PROTOTYPE_PROPERTY) ? this.debuggerContext.performInContext(new Callable<Object>(){

                    @Override
                    public Object call() {
                        return ComplexDebugObjectImpl.this.scriptable.getPrototype();
                    }
                }) : this.debuggerContext.performInContext(new Callable<Object>(){

                    @Override
                    public Object call() {
                        return ComplexDebugObjectImpl.this.scriptable.get((String)key, ComplexDebugObjectImpl.this.scriptable);
                    }
                }));
            } else if (key instanceof Integer) {
                value = this.debuggerContext.performInContext(new Callable<Object>(){

                    @Override
                    public Object call() {
                        return ComplexDebugObjectImpl.this.scriptable.get(((Integer)key).intValue(), ComplexDebugObjectImpl.this.scriptable);
                    }
                });
            }
            if (value == null || value == Scriptable.NOT_FOUND) {
                return null;
            }
            return this.debuggerContext.createDebugObject(value);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void setPropertyValue(final Object key, Object value) {
        try {
            if (value instanceof SimpleDebugObject) {
                value = ((SimpleDebugObject)value).getValue();
            } else if (value instanceof ComplexDebugObjectImpl) {
                value = ((ComplexDebugObjectImpl)value).getScriptable();
            }
            if (!(value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Scriptable)) {
                final Object currentValue = value;
                value = this.debuggerContext.performInContext(new Callable<Object>(){

                    @Override
                    public Object call() {
                        return Context.toObject((Object)currentValue, (Scriptable)ComplexDebugObjectImpl.this.scriptable);
                    }
                });
            }
            final Object assignedValue = value;
            if (key instanceof String) {
                if (!key.equals(PARENT_SCOPE_PROPERTY) && !key.equals(PROTOTYPE_PROPERTY)) {
                    this.debuggerContext.performInContext(new Callable<Object>(){

                        @Override
                        public Object call() {
                            ComplexDebugObjectImpl.this.scriptable.put((String)key, ComplexDebugObjectImpl.this.scriptable, assignedValue);
                            return null;
                        }
                    });
                }
            } else if (key instanceof Integer) {
                this.debuggerContext.performInContext(new Callable<Object>(){

                    @Override
                    public Object call() {
                        ComplexDebugObjectImpl.this.scriptable.put(((Integer)key).intValue(), ComplexDebugObjectImpl.this.scriptable, assignedValue);
                        return null;
                    }
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getClassName() {
        if (this.className == null) {
            Object obj;
            String computedClassName = this.debuggerContext.performInContext(new Callable<String>(){

                @Override
                public String call() {
                    return ComplexDebugObjectImpl.this.scriptable.getClassName();
                }
            });
            if (this.scriptable instanceof NativeJavaObject && (obj = ((NativeJavaObject)this.scriptable).unwrap()) != null) {
                computedClassName = computedClassName + "(";
                computedClassName = computedClassName + obj.getClass().getName();
                computedClassName = computedClassName + ")";
            }
            this.className = computedClassName;
        }
        return this.className;
    }

    public String toString() {
        return this.debuggerContext.performInContext(new Callable<String>(){

            @Override
            public String call() {
                Object obj = ComplexDebugObjectImpl.this.scriptable;
                if (ComplexDebugObjectImpl.this.scriptable instanceof NativeJavaObject) {
                    obj = ((NativeJavaObject)ComplexDebugObjectImpl.this.scriptable).unwrap();
                }
                return obj == null ? "(null)" : obj.toString();
            }
        });
    }
}

