/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.script.javascript.lang;

import com.sun.phobos.script.javascript.lang.Parser;
import com.sun.phobos.script.javascript.lang.Token;
import com.sun.phobos.script.javascript.lang.TokenObj;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;

public class TokenStream {
    private static final int EOF_CHAR = -1;
    private boolean dirtyLine;
    String regExpFlags;
    private String line;
    private boolean fromEval;
    private String string = "";
    private double number;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private final int[] ungetBuffer = new int[3];
    private int ungetCursor;
    private boolean hitEOF = false;
    private int lineStart = 0;
    private int currentLineNumber;
    private int lineEndChar = -1;
    private String sourceString;
    private int sourceEnd;
    private int sourceCursor;
    private int tokenStartCursor;
    private boolean xmlIsAttribute;
    private boolean xmlIsTagContent;
    private int xmlOpenTagsCount;
    private boolean gotBlockComment;
    private int blockCommentStartLineNumber;
    private int blockCommentStartSourceOffset;
    private int blockCommentStartColumnNumber;
    private Parser parser;
    private boolean preserveComments;
    private static final int COLUMN_START_OFFSET = 1;

    public TokenStream(Parser parser, String sourceString, int lineno, boolean preserveComments) {
        this.parser = parser;
        this.currentLineNumber = lineno;
        if (sourceString == null) {
            Kit.codeBug();
        }
        this.sourceString = sourceString;
        this.sourceEnd = sourceString.length();
        this.sourceCursor = 0;
        this.preserveComments = preserveComments;
    }

    public TokenStream(Parser parser, Reader sourceReader, int lineno, boolean preserveComments) throws IOException {
        this.parser = parser;
        this.currentLineNumber = lineno;
        this.sourceString = TokenStream.readIntoString(sourceReader);
        this.sourceEnd = this.sourceString.length();
        this.sourceCursor = 0;
        this.preserveComments = preserveComments;
    }

    private static String readIntoString(Reader reader) throws IOException {
        int len;
        StringWriter sw = new StringWriter();
        BufferedReader br = new BufferedReader(reader);
        char[] buffer = new char[4096];
        while ((len = br.read(buffer)) != -1) {
            sw.write(buffer, 0, len);
        }
        br.close();
        sw.flush();
        return sw.toString();
    }

    public String tokenToString(int token) {
        String name = Token.name(token);
        switch (token) {
            case 38: 
            case 40: 
            case 47: {
                return name + " `" + this.string + "'";
            }
            case 39: {
                return "NUMBER " + this.number;
            }
            case 176: {
                return "COMMENT `" + this.string + "'";
            }
        }
        return name;
    }

    boolean isKeyword(String s) {
        return 0 != this.stringToKeyword(s);
    }

    private int stringToKeyword(String name) {
        return this.parser.stringToKeyword(name);
    }

    public int getLineNumber() {
        return this.currentLineNumber;
    }

    public String getString() {
        return this.string;
    }

    public double getNumber() {
        return this.number;
    }

    public boolean eof() {
        return this.hitEOF;
    }

    public TokenObj getTokenObj() throws IOException {
        int token = this.getToken();
        String s = null;
        double d = 0.0;
        switch (token) {
            case 38: 
            case 40: 
            case 47: 
            case 176: {
                s = this.string;
                break;
            }
            case 39: {
                d = this.number;
            }
        }
        return new TokenObj(token, s, d, this.getTokenStartLine(), this.getTokenEndLine(), this.getTokenStartColumn(), this.getTokenEndColumn(), this.getTokenStartSourceOffset(), this.getTokenEndSourceOffset());
    }

    public int getToken() throws IOException {
        this.parser.checkForInterrupts();
        this.gotBlockComment = false;
        block39: while (true) {
            boolean identifierStart;
            int c;
            if ((c = this.getChar()) == -1) {
                return 0;
            }
            if (c == 10) {
                this.dirtyLine = false;
                this.tokenStartCursor = this.getSourceOffset() - 1;
                return 1;
            }
            if (TokenStream.isJSSpace(c)) continue;
            if (c != 45) {
                this.dirtyLine = true;
            }
            this.tokenStartCursor = this.getSourceOffset() - 1;
            if (c == 64) {
                return 143;
            }
            boolean isUnicodeEscapeStart = false;
            if (c == 92) {
                c = this.getChar();
                if (c == 117) {
                    identifierStart = true;
                    isUnicodeEscapeStart = true;
                    this.stringBufferTop = 0;
                } else {
                    identifierStart = false;
                    this.ungetChar(c);
                    c = 92;
                }
            } else {
                identifierStart = Character.isJavaIdentifierStart((char)c);
                if (identifierStart) {
                    this.stringBufferTop = 0;
                    this.addToString(c);
                }
            }
            if (identifierStart) {
                int result;
                boolean containsEscape = isUnicodeEscapeStart;
                while (true) {
                    if (isUnicodeEscapeStart) {
                        int escapeVal = 0;
                        for (int i = 0; i != 4 && (escapeVal = Kit.xDigitToInt((int)(c = this.getChar()), (int)escapeVal)) >= 0; ++i) {
                        }
                        if (escapeVal < 0) {
                            this.parser.addError("msg.invalid.escape");
                            return -1;
                        }
                        this.addToString(escapeVal);
                        isUnicodeEscapeStart = false;
                        continue;
                    }
                    c = this.getChar();
                    if (c == 92) {
                        c = this.getChar();
                        if (c == 117) {
                            isUnicodeEscapeStart = true;
                            containsEscape = true;
                            continue;
                        }
                        this.parser.addError("msg.illegal.character");
                        return -1;
                    }
                    if (c == -1 || !Character.isJavaIdentifierPart((char)c)) break;
                    this.addToString(c);
                }
                this.ungetChar(c);
                String str = this.getStringFromBuffer();
                if (!containsEscape && (result = this.stringToKeyword(str)) != 0) {
                    if (result != 123) {
                        return result;
                    }
                    if (!this.parser.isReservedKeywordAsIdentifier()) {
                        return result;
                    }
                    this.parser.addWarning("msg.reserved.keyword", str);
                }
                this.string = str;
                return 38;
            }
            if (TokenStream.isDigit(c) || c == 46 && TokenStream.isDigit(this.peekChar())) {
                double dval;
                this.stringBufferTop = 0;
                int base = 10;
                if (c == 48) {
                    c = this.getChar();
                    if (c == 120 || c == 88) {
                        base = 16;
                        c = this.getChar();
                    } else if (TokenStream.isDigit(c)) {
                        base = 8;
                    } else {
                        this.addToString(48);
                    }
                }
                if (base == 16) {
                    while (0 <= Kit.xDigitToInt((int)c, (int)0)) {
                        this.addToString(c);
                        c = this.getChar();
                    }
                } else {
                    while (48 <= c && c <= 57) {
                        if (base == 8 && c >= 56) {
                            this.parser.addWarning("msg.bad.octal.literal", c == 56 ? "8" : "9");
                            base = 10;
                        }
                        this.addToString(c);
                        c = this.getChar();
                    }
                }
                boolean isInteger = true;
                if (base == 10 && (c == 46 || c == 101 || c == 69)) {
                    isInteger = false;
                    if (c == 46) {
                        do {
                            this.addToString(c);
                        } while (TokenStream.isDigit(c = this.getChar()));
                    }
                    if (c == 101 || c == 69) {
                        this.addToString(c);
                        c = this.getChar();
                        if (c == 43 || c == 45) {
                            this.addToString(c);
                            c = this.getChar();
                        }
                        if (!TokenStream.isDigit(c)) {
                            this.parser.addError("msg.missing.exponent");
                            return -1;
                        }
                        do {
                            this.addToString(c);
                        } while (TokenStream.isDigit(c = this.getChar()));
                    }
                }
                this.ungetChar(c);
                String numString = this.getStringFromBuffer();
                if (base == 10 && !isInteger) {
                    try {
                        dval = Double.valueOf(numString);
                    }
                    catch (NumberFormatException ex) {
                        this.parser.addError("msg.caught.nfe");
                        return -1;
                    }
                } else {
                    dval = Parser.stringToNumber(numString, 0, base);
                }
                this.number = dval;
                return 39;
            }
            if (c == 34 || c == 39) {
                String str;
                int quoteChar = c;
                this.stringBufferTop = 0;
                c = this.getChar();
                block46: while (c != quoteChar) {
                    if (c == 10 || c == -1) {
                        this.ungetChar(c);
                        this.parser.addError("msg.unterminated.string.lit");
                        return -1;
                    }
                    if (c == 92) {
                        c = this.getChar();
                        switch (c) {
                            case 98: {
                                c = 8;
                                break;
                            }
                            case 102: {
                                c = 12;
                                break;
                            }
                            case 110: {
                                c = 10;
                                break;
                            }
                            case 114: {
                                c = 13;
                                break;
                            }
                            case 116: {
                                c = 9;
                                break;
                            }
                            case 118: {
                                c = 11;
                                break;
                            }
                            case 117: {
                                int escapeStart = this.stringBufferTop;
                                this.addToString(117);
                                int escapeVal = 0;
                                for (int i = 0; i != 4; ++i) {
                                    c = this.getChar();
                                    escapeVal = Kit.xDigitToInt((int)c, (int)escapeVal);
                                    if (escapeVal < 0) continue block46;
                                    this.addToString(c);
                                }
                                this.stringBufferTop = escapeStart;
                                c = escapeVal;
                                break;
                            }
                            case 120: {
                                c = this.getChar();
                                int escapeVal = Kit.xDigitToInt((int)c, (int)0);
                                if (escapeVal < 0) {
                                    this.addToString(120);
                                    continue block46;
                                }
                                int c1 = c;
                                c = this.getChar();
                                escapeVal = Kit.xDigitToInt((int)c, (int)escapeVal);
                                if (escapeVal < 0) {
                                    this.addToString(120);
                                    this.addToString(c1);
                                    continue block46;
                                }
                                c = escapeVal;
                                break;
                            }
                            case 10: {
                                c = this.getChar();
                                continue block46;
                            }
                            default: {
                                if (48 > c || c >= 56) break;
                                int val = c - 48;
                                c = this.getChar();
                                if (48 <= c && c < 56) {
                                    val = 8 * val + c - 48;
                                    c = this.getChar();
                                    if (48 <= c && c < 56 && val <= 31) {
                                        val = 8 * val + c - 48;
                                        c = this.getChar();
                                    }
                                }
                                this.ungetChar(c);
                                c = val;
                            }
                        }
                    }
                    this.addToString(c);
                    c = this.getChar();
                }
                this.string = str = this.getStringFromBuffer();
                return 40;
            }
            switch (c) {
                case 59: {
                    return 78;
                }
                case 91: {
                    return 79;
                }
                case 93: {
                    return 80;
                }
                case 123: {
                    return 81;
                }
                case 125: {
                    return 82;
                }
                case 40: {
                    return 83;
                }
                case 41: {
                    return 84;
                }
                case 44: {
                    return 85;
                }
                case 63: {
                    return 98;
                }
                case 58: {
                    if (this.matchChar(58)) {
                        return 140;
                    }
                    return 99;
                }
                case 46: {
                    if (this.matchChar(46)) {
                        return 139;
                    }
                    if (this.matchChar(40)) {
                        return 142;
                    }
                    return 104;
                }
                case 124: {
                    if (this.matchChar(124)) {
                        return 100;
                    }
                    if (this.matchChar(61)) {
                        return 87;
                    }
                    return 9;
                }
                case 94: {
                    if (this.matchChar(61)) {
                        return 88;
                    }
                    return 10;
                }
                case 38: {
                    if (this.matchChar(38)) {
                        return 101;
                    }
                    if (this.matchChar(61)) {
                        return 89;
                    }
                    return 11;
                }
                case 61: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 45;
                        }
                        return 12;
                    }
                    return 86;
                }
                case 33: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 46;
                        }
                        return 13;
                    }
                    return 26;
                }
                case 60: {
                    if (this.matchChar(33)) {
                        if (this.matchChar(45)) {
                            if (this.matchChar(45)) {
                                if (this.preserveComments) {
                                    this.stringBufferTop = 0;
                                    this.saveLine();
                                    this.string = this.getStringFromBuffer();
                                    return 176;
                                }
                                this.skipLine();
                                continue block39;
                            }
                            this.ungetChar(45);
                        }
                        this.ungetChar(33);
                    }
                    if (this.matchChar(60)) {
                        if (this.matchChar(61)) {
                            return 90;
                        }
                        return 18;
                    }
                    if (this.matchChar(61)) {
                        return 15;
                    }
                    return 14;
                }
                case 62: {
                    if (this.matchChar(62)) {
                        if (this.matchChar(62)) {
                            if (this.matchChar(61)) {
                                return 92;
                            }
                            return 20;
                        }
                        if (this.matchChar(61)) {
                            return 91;
                        }
                        return 19;
                    }
                    if (this.matchChar(61)) {
                        return 17;
                    }
                    return 16;
                }
                case 42: {
                    if (this.matchChar(61)) {
                        return 95;
                    }
                    return 23;
                }
                case 47: {
                    if (this.matchChar(47)) {
                        if (this.preserveComments) {
                            this.stringBufferTop = 0;
                            this.saveLine();
                            this.string = this.getStringFromBuffer();
                            return 176;
                        }
                        this.skipLine();
                        continue block39;
                    }
                    if (this.matchChar(42)) {
                        boolean lookForSlash = false;
                        if (this.preserveComments) {
                            this.stringBufferTop = 0;
                            this.blockCommentStartLineNumber = this.currentLineNumber;
                            this.blockCommentStartSourceOffset = this.getTokenStartSourceOffset();
                            this.blockCommentStartColumnNumber = this.getTokenStartColumn();
                        }
                        while (true) {
                            if ((c = this.getChar()) == -1) {
                                this.parser.addError("msg.unterminated.comment");
                                return -1;
                            }
                            if (c == 42) {
                                lookForSlash = true;
                                continue;
                            }
                            if (c == 47) {
                                if (lookForSlash) {
                                    if (!this.preserveComments) continue block39;
                                    this.string = this.getStringFromBuffer();
                                    this.gotBlockComment = true;
                                    return 176;
                                }
                                if (!this.preserveComments) continue;
                                this.addToString(c);
                                continue;
                            }
                            lookForSlash = false;
                            if (!this.preserveComments) continue;
                            this.addToString(c);
                        }
                    }
                    if (this.matchChar(61)) {
                        return 96;
                    }
                    return 24;
                }
                case 37: {
                    if (this.matchChar(61)) {
                        return 97;
                    }
                    return 25;
                }
                case 126: {
                    return 27;
                }
                case 43: {
                    if (this.matchChar(61)) {
                        return 93;
                    }
                    if (this.matchChar(43)) {
                        return 102;
                    }
                    return 21;
                }
                case 45: {
                    if (this.matchChar(61)) {
                        c = 94;
                    } else if (this.matchChar(45)) {
                        if (!this.dirtyLine && this.matchChar(62)) {
                            this.skipLine();
                            continue block39;
                        }
                        c = 103;
                    } else {
                        c = 22;
                    }
                    this.dirtyLine = true;
                    return c;
                }
            }
            break;
        }
        this.parser.addError("msg.illegal.character");
        return -1;
    }

    private static boolean isAlpha(int c) {
        if (c <= 90) {
            return 65 <= c;
        }
        return 97 <= c && c <= 122;
    }

    static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    static boolean isJSSpace(int c) {
        if (c <= 127) {
            return c == 32 || c == 9 || c == 12 || c == 11;
        }
        return c == 160 || Character.getType((char)c) == 12;
    }

    private static boolean isJSFormatChar(int c) {
        return c > 127 && Character.getType((char)c) == 16;
    }

    void readRegExp(int startToken) throws IOException {
        int c;
        this.stringBufferTop = 0;
        if (startToken == 96) {
            this.addToString(61);
        } else if (startToken != 24) {
            Kit.codeBug();
        }
        while ((c = this.getChar()) != 47) {
            if (c == 10 || c == -1) {
                this.ungetChar(c);
                throw this.parser.reportError("msg.unterminated.re.lit");
            }
            if (c == 92) {
                this.addToString(c);
                c = this.getChar();
            }
            this.addToString(c);
        }
        int reEnd = this.stringBufferTop;
        while (true) {
            if (this.matchChar(103)) {
                this.addToString(103);
                continue;
            }
            if (this.matchChar(105)) {
                this.addToString(105);
                continue;
            }
            if (!this.matchChar(109)) break;
            this.addToString(109);
        }
        if (TokenStream.isAlpha(this.peekChar())) {
            throw this.parser.reportError("msg.invalid.re.flag");
        }
        this.string = new String(this.stringBuffer, 0, reEnd);
        this.regExpFlags = new String(this.stringBuffer, reEnd, this.stringBufferTop - reEnd);
    }

    boolean isXMLAttribute() {
        return this.xmlIsAttribute;
    }

    int getFirstXMLToken() throws IOException {
        this.xmlOpenTagsCount = 0;
        this.xmlIsAttribute = false;
        this.xmlIsTagContent = false;
        this.ungetChar(60);
        return this.getNextXMLToken();
    }

    int getNextXMLToken() throws IOException {
        this.stringBufferTop = 0;
        int c = this.getChar();
        while (c != -1) {
            if (this.xmlIsTagContent) {
                switch (c) {
                    case 62: {
                        this.addToString(c);
                        this.xmlIsTagContent = false;
                        this.xmlIsAttribute = false;
                        break;
                    }
                    case 47: {
                        this.addToString(c);
                        if (this.peekChar() != 62) break;
                        c = this.getChar();
                        this.addToString(c);
                        this.xmlIsTagContent = false;
                        --this.xmlOpenTagsCount;
                        break;
                    }
                    case 123: {
                        this.ungetChar(c);
                        this.string = this.getStringFromBuffer();
                        return 141;
                    }
                    case 34: 
                    case 39: {
                        this.addToString(c);
                        if (this.readQuotedString(c)) break;
                        return -1;
                    }
                    case 61: {
                        this.addToString(c);
                        this.xmlIsAttribute = true;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.addToString(c);
                        break;
                    }
                    default: {
                        this.addToString(c);
                        this.xmlIsAttribute = false;
                    }
                }
                if (!this.xmlIsTagContent && this.xmlOpenTagsCount == 0) {
                    this.string = this.getStringFromBuffer();
                    return 144;
                }
            } else {
                block8 : switch (c) {
                    case 60: {
                        this.addToString(c);
                        c = this.peekChar();
                        switch (c) {
                            case 33: {
                                c = this.getChar();
                                this.addToString(c);
                                c = this.peekChar();
                                switch (c) {
                                    case 45: {
                                        c = this.getChar();
                                        this.addToString(c);
                                        c = this.getChar();
                                        if (c == 45) {
                                            this.addToString(c);
                                            if (this.readXmlComment()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    case 91: {
                                        c = this.getChar();
                                        this.addToString(c);
                                        if (this.getChar() == 67 && this.getChar() == 68 && this.getChar() == 65 && this.getChar() == 84 && this.getChar() == 65 && this.getChar() == 91) {
                                            this.addToString(67);
                                            this.addToString(68);
                                            this.addToString(65);
                                            this.addToString(84);
                                            this.addToString(65);
                                            this.addToString(91);
                                            if (this.readCDATA()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    default: {
                                        if (this.readEntity()) break block8;
                                        return -1;
                                    }
                                }
                            }
                            case 63: {
                                c = this.getChar();
                                this.addToString(c);
                                if (this.readPI()) break block8;
                                return -1;
                            }
                            case 47: {
                                c = this.getChar();
                                this.addToString(c);
                                if (this.xmlOpenTagsCount == 0) {
                                    this.stringBufferTop = 0;
                                    this.string = null;
                                    this.parser.addError("msg.XML.bad.form");
                                    return -1;
                                }
                                this.xmlIsTagContent = true;
                                --this.xmlOpenTagsCount;
                                break;
                            }
                            default: {
                                this.xmlIsTagContent = true;
                                ++this.xmlOpenTagsCount;
                                break;
                            }
                        }
                        break;
                    }
                    case 123: {
                        this.ungetChar(c);
                        this.string = this.getStringFromBuffer();
                        return 141;
                    }
                    default: {
                        this.addToString(c);
                    }
                }
            }
            c = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return -1;
    }

    private boolean readQuotedString(int quote) throws IOException {
        int c = this.getChar();
        while (c != -1) {
            this.addToString(c);
            if (c == quote) {
                return true;
            }
            c = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readXmlComment() throws IOException {
        int c = this.getChar();
        while (c != -1) {
            this.addToString(c);
            if (c == 45 && this.peekChar() == 45) {
                c = this.getChar();
                this.addToString(c);
                if (this.peekChar() != 62) continue;
                c = this.getChar();
                this.addToString(c);
                return true;
            }
            c = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readCDATA() throws IOException {
        int c = this.getChar();
        while (c != -1) {
            this.addToString(c);
            if (c == 93 && this.peekChar() == 93) {
                c = this.getChar();
                this.addToString(c);
                if (this.peekChar() != 62) continue;
                c = this.getChar();
                this.addToString(c);
                return true;
            }
            c = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readEntity() throws IOException {
        int declTags = 1;
        int c = this.getChar();
        while (c != -1) {
            this.addToString(c);
            switch (c) {
                case 60: {
                    ++declTags;
                    break;
                }
                case 62: {
                    if (--declTags != 0) break;
                    return true;
                }
            }
            c = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readPI() throws IOException {
        int c = this.getChar();
        while (c != -1) {
            this.addToString(c);
            if (c == 63 && this.peekChar() == 62) {
                c = this.getChar();
                this.addToString(c);
                return true;
            }
            c = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private String getStringFromBuffer() {
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int c) {
        int N = this.stringBufferTop;
        if (N == this.stringBuffer.length) {
            char[] tmp = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, tmp, 0, N);
            this.stringBuffer = tmp;
        }
        this.stringBuffer[N] = (char)c;
        this.stringBufferTop = N + 1;
    }

    private void ungetChar(int c) {
        if (this.ungetCursor != 0 && this.ungetBuffer[this.ungetCursor - 1] == 10) {
            Kit.codeBug();
        }
        this.ungetBuffer[this.ungetCursor++] = c;
    }

    private boolean matchChar(int test) throws IOException {
        int c = this.getChar();
        if (c == test) {
            return true;
        }
        this.ungetChar(c);
        return false;
    }

    private int peekChar() throws IOException {
        int c = this.getChar();
        this.ungetChar(c);
        return c;
    }

    private int getChar() throws IOException {
        int c;
        block8: {
            if (this.ungetCursor != 0) {
                return this.ungetBuffer[--this.ungetCursor];
            }
            while (true) {
                if (this.sourceCursor == this.sourceEnd) {
                    this.hitEOF = true;
                    return -1;
                }
                c = this.sourceString.charAt(this.sourceCursor++);
                if (this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && c == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    this.lineStart = this.sourceCursor - 1;
                    ++this.currentLineNumber;
                }
                if (c <= 127) {
                    if (c == 10 || c == 13) {
                        this.lineEndChar = c;
                        c = 10;
                    }
                    break block8;
                }
                if (!TokenStream.isJSFormatChar(c)) break;
            }
            if (ScriptRuntime.isJSLineTerminator((int)c)) {
                this.lineEndChar = c;
                c = 10;
            }
        }
        return c;
    }

    private void skipLine() throws IOException {
        int c;
        while ((c = this.getChar()) != -1 && c != 10) {
        }
        this.ungetChar(c);
    }

    private void saveLine() throws IOException {
        int c;
        while ((c = this.getChar()) != -1 && c != 10) {
            this.addToString(c);
        }
        this.ungetChar(c);
    }

    private int getOffset() {
        int n = this.getSourceOffset() - this.lineStart;
        return n;
    }

    public String getLine() {
        int lineEnd;
        if (this.lineEndChar >= 0) {
            --lineEnd;
        } else {
            char c;
            for (lineEnd = this.sourceCursor; lineEnd != this.sourceEnd && !ScriptRuntime.isJSLineTerminator((int)(c = this.sourceString.charAt(lineEnd))); ++lineEnd) {
            }
        }
        return this.sourceString.substring(this.lineStart, lineEnd);
    }

    private int getSourceOffset() {
        return this.sourceCursor - this.ungetCursor;
    }

    public int getTokenStartSourceOffset() {
        return this.tokenStartCursor;
    }

    public int getTokenEndSourceOffset() {
        return this.getSourceOffset();
    }

    public int getTokenStartLine() {
        return this.gotBlockComment ? this.blockCommentStartLineNumber : this.getLineNumber();
    }

    public int getTokenEndLine() {
        return this.getLineNumber();
    }

    public int getTokenStartColumn() {
        if (this.gotBlockComment) {
            return this.blockCommentStartColumnNumber;
        }
        int n = this.getTokenStartSourceOffset() - this.lineStart;
        return n + 1;
    }

    public int getTokenEndColumn() {
        return this.getOffset() + 1;
    }

    public int getBlockCommentStartColumnNumber() {
        return this.blockCommentStartColumnNumber;
    }
}

