/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.script.javascript.lang.ast;

import com.sun.phobos.script.javascript.lang.ast.BlockNode;
import com.sun.phobos.script.javascript.lang.ast.FunctionNode;
import com.sun.phobos.script.javascript.lang.ast.Node;
import com.sun.phobos.script.javascript.lang.ast.TreeWalker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScopeNode
extends Node {
    private BlockNode body = new BlockNode();
    private String sourceName;
    private int baseLineno = -1;
    private int endLineno = -1;
    private List<String> parameters;
    private List<FunctionNode> functions;
    private List<String> variables;
    private Map<String, Integer> variableMap;
    private int varStart = 0;
    private int varEnd;
    private List<RegexpEntry> regexps;

    public final String getSourceName() {
        return this.sourceName;
    }

    public final void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public final int getBaseLineno() {
        return this.baseLineno;
    }

    public final void setBaseLineno(int lineno) {
        this.baseLineno = lineno;
    }

    public final int getEndLineno() {
        return this.baseLineno;
    }

    public final void setEndLineno(int lineno) {
        this.endLineno = lineno;
    }

    public BlockNode getBody() {
        return this.body;
    }

    public void setBody(BlockNode body) {
        this.body = body;
    }

    public List<String> getParameters() {
        return this.parameters == null ? Collections.EMPTY_LIST : this.parameters;
    }

    public List<String> getVariables() {
        return this.variables == null ? Collections.EMPTY_LIST : this.variables;
    }

    public List<FunctionNode> getFunctions() {
        return this.functions == null ? Collections.EMPTY_LIST : this.functions;
    }

    public int addFunction(FunctionNode fnNode) {
        assert (fnNode != null);
        if (this.functions == null) {
            this.functions = new ArrayList<FunctionNode>();
        }
        this.functions.add(fnNode);
        return this.functions.size() - 1;
    }

    public void addParam(String name) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<String>();
        }
        this.parameters.add(name);
        if (this.variables == null) {
            this.variables = new ArrayList<String>();
        }
        this.variables.add(name);
        int index = this.varStart++;
        if (this.variableMap == null) {
            this.variableMap = new HashMap<String, Integer>();
        }
        this.variableMap.put(name, index);
        ++this.varEnd;
    }

    public void addVar(String name) {
        if (this.variableMap == null) {
            this.variableMap = new HashMap<String, Integer>();
        } else {
            Integer index = this.variableMap.get(name);
            if (index != null) {
                return;
            }
        }
        this.variableMap.put(name, this.varEnd++);
        if (this.variables == null) {
            this.variables = new ArrayList<String>();
        }
        this.variables.add(name);
    }

    public boolean hasParamOrVar(String name) {
        return this.variableMap == null ? false : this.variableMap.containsKey(name);
    }

    public int addRegexp(String re, String flags) {
        if (this.regexps == null) {
            this.regexps = new ArrayList<RegexpEntry>();
        }
        this.regexps.add(new RegexpEntry(re, flags));
        return this.regexps.size() - 1;
    }

    @Override
    public void walk(TreeWalker walker) {
        walker.preWalk(this);
        walker.walk(this.body);
        walker.postWalk(this);
    }

    private static class RegexpEntry {
        private String string;
        private String flags;

        public RegexpEntry(String string, String flags) {
            this.string = string;
            this.flags = flags;
        }

        public String getString() {
            return this.string;
        }

        public String getFlags() {
            return this.flags;
        }
    }
}

