/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.script.javascript.lang;

import com.sun.phobos.script.javascript.lang.Position;
import com.sun.phobos.script.javascript.lang.Token;

public class TokenObj {
    private int token;
    private String stringValue;
    private double numberValue;
    private Position startPosition;
    private Position endPosition;

    public TokenObj(int token) {
        this(token, -1, -1, -1, -1, -1, -1);
    }

    public TokenObj(int token, int startLine, int endLine, int startColumn, int endColumn, int startSourceOffset, int endSourceOffset) {
        this(token, null, 0.0, startLine, endLine, startColumn, endColumn, startSourceOffset, endSourceOffset);
    }

    public TokenObj(int token, double d, int startLine, int endLine, int startColumn, int endColumn, int startSourceOffset, int endSourceOffset) {
        this(token, null, d, startLine, endLine, startColumn, endColumn, startSourceOffset, endSourceOffset);
    }

    public TokenObj(int token, String s, int startLine, int endLine, int startColumn, int endColumn, int startSourceOffset, int endSourceOffset) {
        this(token, s, 0.0, startLine, endLine, startColumn, endColumn, startSourceOffset, endSourceOffset);
    }

    public TokenObj(int token, String s, double d, int startLine, int endLine, int startColumn, int endColumn, int startSourceOffset, int endSourceOffset) {
        this.token = token;
        this.stringValue = s;
        this.numberValue = d;
        this.startPosition = new Position(startLine, startColumn, startSourceOffset);
        this.endPosition = new Position(endLine, endColumn, endSourceOffset);
    }

    public int getToken() {
        return this.token;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public double getNumberValue() {
        return this.numberValue;
    }

    public Position getStartPosition() {
        return this.startPosition;
    }

    public Position getEndPosition() {
        return this.endPosition;
    }

    public String toString() {
        String name = Token.name(this.token);
        switch (this.token) {
            case 38: 
            case 40: 
            case 47: {
                return name + " `" + this.stringValue + "'";
            }
            case 39: {
                return "NUMBER " + this.numberValue;
            }
            case 176: {
                return "COMMENT `" + this.stringValue + "'";
            }
        }
        return name;
    }
}

