/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.script.javascript.lang;

import com.sun.phobos.script.javascript.lang.IndentingWriter;
import com.sun.phobos.script.javascript.lang.Parser;
import com.sun.phobos.script.javascript.lang.ast.ArrayLiteralNode;
import com.sun.phobos.script.javascript.lang.ast.AssignmentNode;
import com.sun.phobos.script.javascript.lang.ast.BinaryExprNode;
import com.sun.phobos.script.javascript.lang.ast.BlockNode;
import com.sun.phobos.script.javascript.lang.ast.BreakNode;
import com.sun.phobos.script.javascript.lang.ast.CallNode;
import com.sun.phobos.script.javascript.lang.ast.CaseNode;
import com.sun.phobos.script.javascript.lang.ast.CatchNode;
import com.sun.phobos.script.javascript.lang.ast.CommaNode;
import com.sun.phobos.script.javascript.lang.ast.ConditionalExprNode;
import com.sun.phobos.script.javascript.lang.ast.ContinueNode;
import com.sun.phobos.script.javascript.lang.ast.DeclarationNode;
import com.sun.phobos.script.javascript.lang.ast.DeleteNode;
import com.sun.phobos.script.javascript.lang.ast.DoWhileNode;
import com.sun.phobos.script.javascript.lang.ast.EmptyExprNode;
import com.sun.phobos.script.javascript.lang.ast.EmptyNode;
import com.sun.phobos.script.javascript.lang.ast.ErrorExprNode;
import com.sun.phobos.script.javascript.lang.ast.ErrorNode;
import com.sun.phobos.script.javascript.lang.ast.ExprStatementNode;
import com.sun.phobos.script.javascript.lang.ast.ForEachNode;
import com.sun.phobos.script.javascript.lang.ast.ForInNode;
import com.sun.phobos.script.javascript.lang.ast.ForNode;
import com.sun.phobos.script.javascript.lang.ast.FunctionExprNode;
import com.sun.phobos.script.javascript.lang.ast.FunctionNode;
import com.sun.phobos.script.javascript.lang.ast.IfNode;
import com.sun.phobos.script.javascript.lang.ast.IndexedPropertyGetNode;
import com.sun.phobos.script.javascript.lang.ast.LabelNode;
import com.sun.phobos.script.javascript.lang.ast.LabeledStatementNode;
import com.sun.phobos.script.javascript.lang.ast.LiteralNode;
import com.sun.phobos.script.javascript.lang.ast.NameNode;
import com.sun.phobos.script.javascript.lang.ast.NewNode;
import com.sun.phobos.script.javascript.lang.ast.Node;
import com.sun.phobos.script.javascript.lang.ast.NodeVisitor;
import com.sun.phobos.script.javascript.lang.ast.NumberNode;
import com.sun.phobos.script.javascript.lang.ast.ObjectLiteralNode;
import com.sun.phobos.script.javascript.lang.ast.PropertyGetNode;
import com.sun.phobos.script.javascript.lang.ast.RegExpNode;
import com.sun.phobos.script.javascript.lang.ast.ReturnNode;
import com.sun.phobos.script.javascript.lang.ast.ScriptNode;
import com.sun.phobos.script.javascript.lang.ast.StatementNode;
import com.sun.phobos.script.javascript.lang.ast.StringNode;
import com.sun.phobos.script.javascript.lang.ast.SwitchNode;
import com.sun.phobos.script.javascript.lang.ast.ThisNode;
import com.sun.phobos.script.javascript.lang.ast.ThrowNode;
import com.sun.phobos.script.javascript.lang.ast.TryNode;
import com.sun.phobos.script.javascript.lang.ast.UnaryExprNode;
import com.sun.phobos.script.javascript.lang.ast.VariableNode;
import com.sun.phobos.script.javascript.lang.ast.WhileNode;
import com.sun.phobos.script.javascript.lang.ast.WithNode;
import com.sun.phobos.script.javascript.lang.ast.XMLDefaultNamespaceNode;
import com.sun.phobos.script.javascript.lang.ast.XMLDotQueryNode;
import com.sun.phobos.script.javascript.lang.ast.XMLIndexedPropertyGetNode;
import com.sun.phobos.script.javascript.lang.ast.XMLPropertyGetNode;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.mozilla.javascript.ScriptRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyWriter
implements NodeVisitor {
    private IndentingWriter writer;
    private Parser parser;
    private boolean init;

    public PrettyWriter(Parser parser, Writer writer) {
        this.parser = parser;
        this.writer = new IndentingWriter(writer);
    }

    public void dump(Node node) {
        node.accept(this);
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void visitList(List<? extends Node> list) {
        try {
            boolean first = true;
            for (Node node : list) {
                if (first) {
                    first = false;
                } else {
                    this.writer.p(", ");
                }
                node.accept(this);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitArrayLiteral(ArrayLiteralNode node) {
        try {
            this.writer.p("[");
            this.visitList(node.getElements());
            this.writer.p("]");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitAssignment(AssignmentNode node) {
        try {
            node.getTarget().accept(this);
            this.writer.p(Character.valueOf(' '));
            String s = null;
            switch (node.getType()) {
                case SIMPLE: {
                    s = "=";
                    break;
                }
                case ADD: {
                    s = "+=";
                    break;
                }
                case SUBTRACT: {
                    s = "-=";
                    break;
                }
                case MULTIPLY: {
                    s = "*=";
                    break;
                }
                case DIVIDE: {
                    s = "/=";
                    break;
                }
                case MODULO: {
                    s = "%=";
                    break;
                }
                case LEFT_SHIFT: {
                    s = "<<=";
                    break;
                }
                case RIGHT_SHIFT: {
                    s = ">>=";
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT: {
                    s = ">>>=";
                    break;
                }
                case BITWISE_XOR: {
                    s = "^=";
                    break;
                }
                case BITWISE_AND: {
                    s = "&=";
                    break;
                }
                case BITWISE_OR: {
                    s = "|=";
                }
            }
            this.writer.p(s);
            this.writer.p(Character.valueOf(' '));
            node.getValue().accept(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitBinaryExpr(BinaryExprNode node) {
        try {
            node.getFirst().accept(this);
            this.writer.p(Character.valueOf(' '));
            String s = null;
            switch (node.getType()) {
                case ADD: {
                    s = "+";
                    break;
                }
                case SUBTRACT: {
                    s = "-";
                    break;
                }
                case MULTIPLY: {
                    s = "*";
                    break;
                }
                case DIVIDE: {
                    s = "/";
                    break;
                }
                case MODULO: {
                    s = "%";
                    break;
                }
                case EQUALS: {
                    s = "==";
                    break;
                }
                case NOT_EQUALS: {
                    s = "!=";
                    break;
                }
                case LESS_THAN: {
                    s = "<";
                    break;
                }
                case LESS_THAN_OR_EQUALS: {
                    s = "<=";
                    break;
                }
                case GREATER_THAN: {
                    s = ">";
                    break;
                }
                case GREATER_THAN_OR_EQUALS: {
                    s = ">=";
                    break;
                }
                case SHALLOW_NOT_EQUALS: {
                    s = "!==";
                    break;
                }
                case SHALLOW_EQUALS: {
                    s = "===";
                    break;
                }
                case LOGICAL_AND: {
                    s = "&&";
                    break;
                }
                case LOGICAL_OR: {
                    s = "||";
                    break;
                }
                case BITWISE_AND: {
                    s = "&";
                    break;
                }
                case BITWISE_OR: {
                    s = "|";
                    break;
                }
                case BITWISE_XOR: {
                    s = "^";
                    break;
                }
                case LEFT_SHIFT: {
                    s = "<<";
                    break;
                }
                case RIGHT_SHIFT: {
                    s = ">>";
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT: {
                    s = ">>>";
                    break;
                }
                case INSTANCE_OF: {
                    s = "instanceof";
                }
            }
            this.writer.p(s);
            this.writer.p(Character.valueOf(' '));
            node.getSecond().accept(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitBlock(BlockNode node) {
        try {
            this.writer.plnI("{");
            for (StatementNode st : node.getContents()) {
                st.accept(this);
            }
            this.writer.pO("}");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitBreak(BreakNode node) {
        try {
            if (node.getLabel() != null) {
                this.writer.p("break ");
                this.writer.p(node.getLabel().getName());
                this.writer.pln(";");
            } else {
                this.writer.pln("break;");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitCall(CallNode node) {
        try {
            node.getTarget().accept(this);
            this.writer.p("(");
            this.visitList(node.getArguments());
            this.writer.p(")");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitCase(CaseNode node) {
        try {
            this.writer.p("case ");
            node.getExpression().accept(this);
            node.getStatement().accept(this);
            this.writer.pln();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitCatch(CatchNode node) {
        try {
            this.writer.p("catch (");
            this.writer.p(node.getVariableName());
            if (node.getCondition() != null) {
                this.writer.p(" if ");
                node.getCondition().accept(this);
            }
            this.writer.p(") ");
            node.getBody().accept(this);
            this.writer.pln();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitComma(CommaNode node) {
        try {
            node.getFirst().accept(this);
            this.writer.p(", ");
            node.getSecond().accept(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitConditionalExpr(ConditionalExprNode node) {
        try {
            this.writer.p("(");
            node.getCondition().accept(this);
            this.writer.p("? ");
            node.getThenExpression().accept(this);
            this.writer.p(": ");
            node.getElseExpression().accept(this);
            this.writer.p(")");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitContinue(ContinueNode node) {
        try {
            if (node.getLabel() != null) {
                this.writer.p("break ");
                this.writer.p(node.getLabel().getName());
                this.writer.pln(";");
            } else {
                this.writer.pln("break;");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitDeclaration(DeclarationNode node) {
        try {
            this.writer.p("var ");
            this.visitList(node.getVariables());
            if (!this.init) {
                this.writer.pln(";");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitDelete(DeleteNode node) {
        try {
            this.writer.p("delete ");
            node.getExpression().accept(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitDoWhile(DoWhileNode node) {
        try {
            this.writer.p("do ");
            node.getBody().accept(this);
            this.writer.pln();
            this.writer.p("while (");
            node.getCondition().accept(this);
            this.writer.pln(");");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitEmpty(EmptyNode node) {
        try {
            this.writer.pln(";");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitEmptyExpr(EmptyExprNode node) {
        try {
            this.writer.p("EMPTY");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitError(ErrorNode node) {
        try {
            this.writer.pln("ERROR;");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitErrorExpr(ErrorExprNode node) {
        try {
            this.writer.p("ERROR");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitExprStatement(ExprStatementNode node) {
        try {
            node.getExpression().accept(this);
            if (!this.init) {
                this.writer.pln(";");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitFor(ForNode node) {
        try {
            this.writer.p("for (");
            this.init = true;
            node.getInitializer().accept(this);
            this.init = false;
            this.writer.p("; ");
            node.getCondition().accept(this);
            this.writer.p("; ");
            node.getIncrement().accept(this);
            this.writer.p(") ");
            node.getBody().accept(this);
            this.writer.pln();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitForEach(ForEachNode node) {
        try {
            this.writer.p("for each (");
            this.init = true;
            node.getInitializer().accept(this);
            this.init = false;
            this.writer.p(" in ");
            node.getCondition().accept(this);
            this.writer.p(") ");
            node.getBody().accept(this);
            this.writer.pln();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitForIn(ForInNode node) {
        try {
            this.writer.p("for (");
            this.init = true;
            node.getInitializer().accept(this);
            this.init = false;
            this.writer.p(" in ");
            node.getCondition().accept(this);
            this.writer.p(") ");
            node.getBody().accept(this);
            this.writer.pln();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitFunction(FunctionNode node) {
        try {
            this.writer.p("function ");
            if (node.getName() != null) {
                this.writer.p(node.getName());
            }
            this.writer.p("(");
            boolean first = true;
            for (String name : node.getParameters()) {
                if (first) {
                    first = false;
                } else {
                    this.writer.p(", ");
                }
                this.writer.p(name);
            }
            this.writer.p(") ");
            node.getBody().accept(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitFunctionExpr(FunctionExprNode node) {
        node.getFunction().accept(this);
    }

    @Override
    public void visitIf(IfNode node) {
        try {
            this.writer.p("if (");
            node.getCondition().accept(this);
            this.writer.p(") ");
            node.getThen().accept(this);
            this.writer.pln();
            if (node.getElse() != null) {
                this.writer.p("else ");
                node.getElse().accept(this);
                this.writer.pln();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitIndexedPropertyGet(IndexedPropertyGetNode node) {
        try {
            node.getExpression().accept(this);
            this.writer.p("[");
            node.getIndex().accept(this);
            this.writer.p("]");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitLabel(LabelNode node) {
        try {
            this.writer.p(node.getName() + ":");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitLabeledStatement(LabeledStatementNode node) {
        try {
            node.getLabel().accept(this);
            this.writer.pln();
            node.getStatement().accept(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitLiteral(LiteralNode node) {
        try {
            switch (node.getType()) {
                case TRUE: {
                    this.writer.p("true");
                    break;
                }
                case FALSE: {
                    this.writer.p("false");
                    break;
                }
                case NULL: {
                    this.writer.p("null");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitName(NameNode node) {
        try {
            this.writer.p(node.getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitNew(NewNode node) {
        try {
            this.writer.p("new ");
            node.getExpression().accept(this);
            this.writer.p("(");
            if (node.getArguments() != null) {
                this.visitList(node.getArguments());
            }
            if (node.getExtension() != null) {
                if (node.getArguments() != null && node.getArguments().size() > 0) {
                    this.writer.p(", ");
                }
                this.writer.p(node.getExtension());
            }
            this.writer.p(")");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitNumber(NumberNode node) {
        try {
            double dvalue = node.getValue();
            long lvalue = (long)dvalue;
            if ((double)lvalue == dvalue) {
                this.writer.p(lvalue);
            } else {
                this.writer.p(dvalue);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitObjectLiteral(ObjectLiteralNode node) {
        try {
            this.writer.p("{");
            boolean first = true;
            for (Object name : node.getPropertyNames()) {
                if (first) {
                    first = false;
                } else {
                    this.writer.p(", ");
                }
                String s = name.toString();
                if (name instanceof String && this.mustQuotePropertyName(s)) {
                    this.writer.p(Character.valueOf('\"'));
                    this.writer.p(s);
                    this.writer.p(Character.valueOf('\"'));
                } else {
                    this.writer.p(s);
                }
                this.writer.p(": ");
                node.getPropertyValue(name).accept(this);
            }
            this.writer.p("}");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitPropertyGet(PropertyGetNode node) {
        try {
            String name;
            if (node.getExpression() != null) {
                node.getExpression().accept(this);
                this.writer.p(".");
            }
            if (this.mustQuotePropertyName(name = node.getName())) {
                this.writer.p(Character.valueOf('['));
                this.writer.p(Character.valueOf('\"'));
                this.writer.p(name);
                this.writer.p(Character.valueOf('\"'));
                this.writer.p(Character.valueOf(']'));
            } else {
                this.writer.p(name);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitRegExp(RegExpNode node) {
        try {
            this.writer.p(Character.valueOf('/'));
            this.writer.p(node.getRegexp());
            this.writer.p(Character.valueOf('/'));
            this.writer.p(node.getFlags());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitReturn(ReturnNode node) {
        try {
            if (node.getExpression() != null) {
                this.writer.p("return ");
                node.getExpression().accept(this);
                this.writer.pln(";");
            } else {
                this.writer.pln("return;");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitScript(ScriptNode node) {
        for (StatementNode st : node.getBody().getContents()) {
            st.accept(this);
        }
    }

    @Override
    public void visitString(StringNode node) {
        try {
            this.writer.p(Character.valueOf('\"'));
            this.writer.p(ScriptRuntime.escapeString((String)node.getValue()));
            this.writer.p(Character.valueOf('\"'));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitSwitch(SwitchNode node) {
        try {
            this.writer.p("switch (");
            node.getExpression().accept(this);
            this.writer.plnI(") {");
            for (CaseNode caseNode : node.getCases()) {
                caseNode.accept(this);
            }
            this.writer.pO();
            this.writer.pln();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitThis(ThisNode node) {
        try {
            this.writer.p("this");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitThrow(ThrowNode node) {
        try {
            this.writer.p("throw ");
            node.getExpression().accept(this);
            this.writer.pln(";");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitTry(TryNode node) {
        try {
            this.writer.p("try ");
            node.getBody().accept(this);
            this.writer.pln();
            for (CatchNode catchNode : node.getCatch()) {
                catchNode.accept(this);
            }
            if (node.getFinally() != null) {
                this.writer.p("finally ");
                node.getFinally().accept(this);
                this.writer.pln();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitUnaryExpr(UnaryExprNode node) {
        try {
            String s = null;
            boolean post = false;
            boolean paren = false;
            switch (node.getType()) {
                case VOID: {
                    s = "void";
                    paren = true;
                    break;
                }
                case LOGICAL_NOT: {
                    s = "!";
                    break;
                }
                case BITWISE_NOT: {
                    s = "~";
                    break;
                }
                case UNARY_MINUS: {
                    s = "-";
                    break;
                }
                case UNARY_PLUS: {
                    s = "+";
                    break;
                }
                case PRE_INCREMENT: {
                    s = "++";
                    break;
                }
                case PRE_DECREMENT: {
                    s = "--";
                    break;
                }
                case POST_INCREMENT: {
                    s = "++";
                    post = true;
                    break;
                }
                case POST_DECREMENT: {
                    s = "--";
                    post = true;
                    break;
                }
                case XML_ESCAPE_ATTRIBUTE: {
                    s = "XML_ESCAPE_ATTRIBUTE";
                    paren = true;
                    break;
                }
                case XML_ESCAPE_TEXT: {
                    s = "XML_ESCAPE_TEXT";
                    paren = true;
                    break;
                }
                case TYPEOF: {
                    s = "typeof";
                    paren = true;
                }
            }
            if (!post) {
                this.writer.p(s);
            }
            if (paren) {
                this.writer.p("(");
            }
            node.getExpression().accept(this);
            if (paren) {
                this.writer.p(")");
            }
            if (post) {
                this.writer.p(s);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitVariable(VariableNode node) {
        try {
            this.writer.p(node.getName());
            if (node.getValue() != null) {
                this.writer.p(" = ");
                node.getValue().accept(this);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitWhile(WhileNode node) {
        try {
            this.writer.p("while (");
            node.getCondition().accept(this);
            this.writer.p(") ");
            node.getBody().accept(this);
            this.writer.pln();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitWith(WithNode node) {
        try {
            this.writer.p("with (");
            node.getExpression().accept(this);
            this.writer.p(") ");
            node.getBody().accept(this);
            this.writer.pln();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitXMLDefaultNamespace(XMLDefaultNamespaceNode node) {
        try {
            this.writer.p("default namespace ");
            node.getExpression().accept(this);
            this.writer.pln();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitXMLDotQuery(XMLDotQueryNode node) {
        try {
            node.getExpression().accept(this);
            this.writer.p(".(");
            node.getQuery().accept(this);
            this.writer.p(")");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitXMLIndexedPropertyGet(XMLIndexedPropertyGetNode node) {
        try {
            node.getExpression().accept(this);
            if (node.isDescendants()) {
                this.writer.p("..");
            } else {
                this.writer.p(".");
            }
            if (node.isAttribute()) {
                this.writer.p("@");
            }
            if (node.getNamespace() != null) {
                this.writer.p(node.getNamespace());
                this.writer.p("::");
            }
            this.writer.p("[");
            node.getIndex().accept(this);
            this.writer.p("]");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visitXMLPropertyGet(XMLPropertyGetNode node) {
        try {
            node.getExpression().accept(this);
            if (node.isDescendants()) {
                this.writer.p("..");
            } else {
                this.writer.p(".");
            }
            if (node.isAttribute()) {
                this.writer.p("@");
            }
            if (node.getNamespace() != null) {
                this.writer.p(node.getNamespace());
                this.writer.p("::");
            }
            this.writer.p(node.getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean mustQuotePropertyName(String s) {
        if (this.parser.isKeywordOrIdentifier(s)) {
            return this.parser.isKeyword(s);
        }
        return true;
    }
}

