/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.script.javascript.lang.ast;

import com.sun.phobos.script.javascript.lang.ast.CatchNode;
import com.sun.phobos.script.javascript.lang.ast.NodeVisitor;
import com.sun.phobos.script.javascript.lang.ast.StatementNode;
import com.sun.phobos.script.javascript.lang.ast.TreeWalker;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TryNode
extends StatementNode {
    protected StatementNode body;
    protected List<CatchNode> catchBlocks;
    protected StatementNode finallyStatement;

    public TryNode() {
        this.catchBlocks = new ArrayList<CatchNode>();
    }

    public TryNode(StatementNode body, StatementNode finallyStatement) {
        this.body = body;
        this.catchBlocks = new ArrayList<CatchNode>();
        this.finallyStatement = finallyStatement;
    }

    public TryNode(StatementNode body, List<CatchNode> catchBlocks, StatementNode finallyStatement) {
        this.body = body;
        this.catchBlocks = catchBlocks;
        this.finallyStatement = finallyStatement;
    }

    public StatementNode getBody() {
        return this.body;
    }

    public void setBody(StatementNode body) {
        this.body = body;
    }

    public List<CatchNode> getCatch() {
        return this.catchBlocks;
    }

    public void addCatch(CatchNode catchBlock) {
        this.catchBlocks.add(catchBlock);
    }

    public StatementNode getFinally() {
        return this.finallyStatement;
    }

    public void setFinally(StatementNode finallyStatement) {
        this.finallyStatement = finallyStatement;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visitTry(this);
    }

    @Override
    public void walk(TreeWalker walker) {
        walker.preWalk(this);
        walker.walk(this.body);
        for (CatchNode catchBlock : this.catchBlocks) {
            walker.walk(catchBlock);
        }
        walker.walk(this.finallyStatement);
        walker.postWalk(this);
    }
}

