/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.script.javascript.lang;

import com.sun.phobos.script.javascript.lang.ParserException;
import com.sun.phobos.script.javascript.lang.ParserInterruptedException;
import com.sun.phobos.script.javascript.lang.TokenStream;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.ScriptRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Parser<T> {
    protected ErrorReporter errorReporter;
    protected TokenStream ts;
    protected String sourceURI;
    protected int syntaxErrorCount;
    protected boolean preserveComments;
    protected boolean reservedKeywordAsIdentifier;
    protected Map<String, Integer> keywordMap;
    protected static Map<String, Integer> defaultKeywordMap;
    public static final double NaN;

    public Parser() {
        this.createKeywordMap();
    }

    public Parser(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.createKeywordMap();
    }

    public boolean isPreserveComments() {
        return this.preserveComments;
    }

    public void setPreserveComments(boolean b) {
        this.preserveComments = b;
    }

    public boolean isReservedKeywordAsIdentifier() {
        return this.reservedKeywordAsIdentifier;
    }

    public void setReservedKeywordAsIdentifier(boolean b) {
        this.reservedKeywordAsIdentifier = b;
    }

    public T parse(String sourceString, String sourceURI) {
        return this.parse(sourceString, sourceURI, 1);
    }

    public T parse(String sourceString, String sourceURI, int lineno) {
        this.sourceURI = sourceURI;
        this.ts = new TokenStream(this, sourceString, lineno, this.preserveComments);
        try {
            return this.parse();
        }
        catch (IOException ex) {
            throw new IllegalStateException();
        }
    }

    public T parse(Reader sourceReader, String sourceURI) throws IOException {
        return this.parse(sourceReader, sourceURI, 1);
    }

    public T parse(Reader sourceReader, String sourceURI, int lineno) throws IOException {
        this.sourceURI = sourceURI;
        this.ts = new TokenStream(this, sourceReader, lineno, this.preserveComments);
        return this.parse();
    }

    protected T parse() throws IOException {
        try {
            return this.internalParse();
        }
        catch (ParserInterruptedException e) {
            return null;
        }
    }

    protected abstract T internalParse() throws IOException;

    protected void createKeywordMap() {
        this.keywordMap = new HashMap<String, Integer>();
    }

    public void addWarning(String messageId, String messageArg) {
        if (this.errorReporter != null) {
            String message = ScriptRuntime.getMessage1((String)messageId, (Object)messageArg);
            this.errorReporter.warning(message, this.sourceURI, this.ts.getLineNumber(), this.ts.getLine(), this.ts.getTokenStartSourceOffset());
        }
    }

    public void addError(String messageId) {
        ++this.syntaxErrorCount;
        if (this.errorReporter != null) {
            String message = ScriptRuntime.getMessage0((String)messageId);
            this.errorReporter.error(message, this.sourceURI, this.ts.getLineNumber(), this.ts.getLine(), this.ts.getTokenStartSourceOffset());
        }
    }

    public RuntimeException reportError(String messageId) {
        this.addError(messageId);
        throw new ParserException();
    }

    public int getSyntaxErrorCount() {
        return this.syntaxErrorCount;
    }

    public void checkForInterrupts() {
    }

    public int stringToKeyword(String name) {
        Integer i = this.keywordMap.get(name);
        if (i == null) {
            i = defaultKeywordMap.get(name);
        }
        if (this.reservedKeywordAsIdentifier && i != null && i == 123) {
            i = 0;
        }
        return i == null ? 0 : i;
    }

    public boolean isKeyword(String name) {
        return this.stringToKeyword(name) != 0;
    }

    public boolean isKeywordOrIdentifier(String name) {
        if (name.length() == 0) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!(i == 0 ? !Character.isUnicodeIdentifierStart(ch) && ch != '$' && ch != '_' : !Character.isUnicodeIdentifierPart(ch) && ch != '$' && ch != '_')) continue;
            return false;
        }
        return true;
    }

    public static double stringToNumber(String s, int start, int radix) {
        int end;
        char digitMax = '9';
        char lowerCaseBound = 'a';
        char upperCaseBound = 'A';
        int len = s.length();
        if (radix < 10) {
            digitMax = (char)(48 + radix - 1);
        }
        if (radix > 10) {
            lowerCaseBound = (char)(97 + radix - 10);
            upperCaseBound = (char)(65 + radix - 10);
        }
        double sum = 0.0;
        for (end = start; end < len; ++end) {
            int newDigit;
            char c = s.charAt(end);
            if ('0' <= c && c <= digitMax) {
                newDigit = c - 48;
            } else if ('a' <= c && c < lowerCaseBound) {
                newDigit = c - 97 + 10;
            } else {
                if ('A' > c || c >= upperCaseBound) break;
                newDigit = c - 65 + 10;
            }
            sum = sum * (double)radix + (double)newDigit;
        }
        if (start == end) {
            return NaN;
        }
        if (sum >= 9.007199254740992E15) {
            if (radix == 10) {
                try {
                    return Double.valueOf(s.substring(start, end));
                }
                catch (NumberFormatException nfe) {
                    return NaN;
                }
            }
            if (radix == 2 || radix == 4 || radix == 8 || radix == 16 || radix == 32) {
                int bitShiftInChar = 1;
                int digit = 0;
                boolean SKIP_LEADING_ZEROS = false;
                boolean FIRST_EXACT_53_BITS = true;
                int AFTER_BIT_53 = 2;
                int ZEROS_AFTER_54 = 3;
                int MIXED_AFTER_54 = 4;
                int state = 0;
                int exactBitsLimit = 53;
                double factor = 0.0;
                boolean bit53 = false;
                boolean bit54 = false;
                while (true) {
                    if (bitShiftInChar == 1) {
                        if (start == end) break;
                        digit = 48 <= (digit = (int)s.charAt(start++)) && digit <= 57 ? (digit -= 48) : (97 <= digit && digit <= 122 ? (digit -= 87) : (digit -= 55));
                        bitShiftInChar = radix;
                    }
                    boolean bit = (digit & (bitShiftInChar >>= 1)) != 0;
                    switch (state) {
                        case 0: {
                            if (!bit) break;
                            --exactBitsLimit;
                            sum = 1.0;
                            state = 1;
                            break;
                        }
                        case 1: {
                            sum *= 2.0;
                            if (bit) {
                                sum += 1.0;
                            }
                            if (--exactBitsLimit != 0) break;
                            bit53 = bit;
                            state = 2;
                            break;
                        }
                        case 2: {
                            bit54 = bit;
                            factor = 2.0;
                            state = 3;
                            break;
                        }
                        case 3: {
                            if (bit) {
                                state = 4;
                            }
                        }
                        case 4: {
                            factor *= 2.0;
                        }
                    }
                }
                switch (state) {
                    case 0: {
                        sum = 0.0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (bit54 & bit53) {
                            sum += 1.0;
                        }
                        sum *= factor;
                        break;
                    }
                    case 4: {
                        if (bit54) {
                            sum += 1.0;
                        }
                        sum *= factor;
                    }
                }
            }
        }
        return sum;
    }

    public static long indexFromString(String str) {
        int MAX_VALUE_LENGTH = 10;
        int len = str.length();
        if (len > 0) {
            int i = 0;
            boolean negate = false;
            int c = str.charAt(0);
            if (c == 45 && len > 1) {
                c = str.charAt(1);
                i = 1;
                negate = true;
            }
            if (0 <= (c -= 48) && c <= 9 && len <= (negate ? 11 : 10)) {
                int index = -c;
                int oldIndex = 0;
                ++i;
                if (index != 0) {
                    while (i != len && 0 <= (c = str.charAt(i) - 48) && c <= 9) {
                        oldIndex = index;
                        index = 10 * index - c;
                        ++i;
                    }
                }
                if (i == len && (oldIndex > -214748364 || oldIndex == -214748364 && c <= (negate ? 8 : 7))) {
                    return 0xFFFFFFFFL & (long)(negate ? index : -index);
                }
            }
        }
        return -1L;
    }

    static {
        NaN = Double.longBitsToDouble(9221120237041090560L);
        defaultKeywordMap = new HashMap<String, Integer>();
        defaultKeywordMap.put("break", 116);
        defaultKeywordMap.put("case", 111);
        defaultKeywordMap.put("catch", 120);
        defaultKeywordMap.put("continue", 117);
        defaultKeywordMap.put("default", 112);
        defaultKeywordMap.put("delete", 31);
        defaultKeywordMap.put("do", 114);
        defaultKeywordMap.put("else", 109);
        defaultKeywordMap.put("false", 43);
        defaultKeywordMap.put("finally", 121);
        defaultKeywordMap.put("for", 115);
        defaultKeywordMap.put("function", 105);
        defaultKeywordMap.put("if", 108);
        defaultKeywordMap.put("in", 51);
        defaultKeywordMap.put("instanceof", 52);
        defaultKeywordMap.put("new", 30);
        defaultKeywordMap.put("null", 41);
        defaultKeywordMap.put("return", 4);
        defaultKeywordMap.put("switch", 110);
        defaultKeywordMap.put("this", 42);
        defaultKeywordMap.put("throw", 49);
        defaultKeywordMap.put("try", 77);
        defaultKeywordMap.put("true", 44);
        defaultKeywordMap.put("typeof", 32);
        defaultKeywordMap.put("var", 118);
        defaultKeywordMap.put("void", 122);
        defaultKeywordMap.put("while", 113);
        defaultKeywordMap.put("with", 119);
        defaultKeywordMap.put("abstract", 123);
        defaultKeywordMap.put("boolean", 123);
        defaultKeywordMap.put("byte", 123);
        defaultKeywordMap.put("char", 123);
        defaultKeywordMap.put("class", 123);
        defaultKeywordMap.put("const", 123);
        defaultKeywordMap.put("debugger", 123);
        defaultKeywordMap.put("double", 123);
        defaultKeywordMap.put("enum", 123);
        defaultKeywordMap.put("export", 123);
        defaultKeywordMap.put("extends", 123);
        defaultKeywordMap.put("final", 123);
        defaultKeywordMap.put("float", 123);
        defaultKeywordMap.put("goto", 123);
        defaultKeywordMap.put("implements", 123);
        defaultKeywordMap.put("import", 123);
        defaultKeywordMap.put("int", 123);
        defaultKeywordMap.put("interface", 123);
        defaultKeywordMap.put("long", 123);
        defaultKeywordMap.put("native", 123);
        defaultKeywordMap.put("package", 123);
        defaultKeywordMap.put("private", 123);
        defaultKeywordMap.put("protected", 123);
        defaultKeywordMap.put("public", 123);
        defaultKeywordMap.put("short", 123);
        defaultKeywordMap.put("static", 123);
        defaultKeywordMap.put("super", 123);
        defaultKeywordMap.put("synchronized", 123);
        defaultKeywordMap.put("throws", 123);
        defaultKeywordMap.put("transient", 123);
        defaultKeywordMap.put("volatile", 123);
    }
}

