/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.debug;

import com.sun.phobos.container.PhobosAdapter;
import com.sun.phobos.container.PhobosRuntime;
import com.sun.phobos.container.ResourceService;
import com.sun.phobos.container.debug.AttachedDebugEventImpl;
import com.sun.phobos.container.debug.DebugFrameImpl;
import com.sun.phobos.container.debug.DebuggerContextImpl;
import com.sun.phobos.container.debug.DetachedDebugEventImpl;
import com.sun.phobos.debug.DebugEvent;
import com.sun.phobos.debug.DebuggerContext;
import com.sun.phobos.debug.DebuggerListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggerImpl
implements Debugger,
com.sun.phobos.debug.Debugger {
    protected Pattern requestURIPattern;
    protected boolean debugStartupScripts;
    protected boolean debugRequests;
    protected boolean debugBackgroundScripts;
    protected ResourceService resourceService;
    protected ArrayList<DebuggerListener> listeners;
    protected Set<String> ignoredBackgroundScripts = Collections.EMPTY_SET;

    public DebuggerImpl() {
        this.listeners = new ArrayList();
    }

    public synchronized void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void maybeAttach(Context cx) {
        if (this.shouldAttach(cx)) {
            DebuggerContextImpl contextData = new DebuggerContextImpl(this, cx, this.getType(), this.getRequestURI());
            cx.setDebugger((Debugger)this, (Object)contextData);
            this.fireDebugEvent(new AttachedDebugEventImpl(contextData));
        }
    }

    public void detach(Context cx) {
        DebuggerContextImpl contextData = (DebuggerContextImpl)cx.getDebuggerContextData();
        this.fireDebugEvent(new DetachedDebugEventImpl(contextData));
        cx.setDebugger(null, null);
    }

    public synchronized Pattern getRequestURIPattern() {
        return this.requestURIPattern;
    }

    public synchronized void setRequestURIPattern(Pattern p) {
        this.requestURIPattern = p;
    }

    public synchronized void setRequestURIPattern(String s) {
        this.requestURIPattern = Pattern.compile(s);
    }

    public boolean isDebugStartupScripts() {
        return this.debugStartupScripts;
    }

    public synchronized void setDebugStartupScripts(boolean b) {
        this.debugStartupScripts = b;
    }

    public boolean isDebugRequests() {
        return this.debugRequests;
    }

    public synchronized void setDebugRequests(boolean b) {
        this.debugRequests = b;
    }

    public boolean isDebugBackgroundScripts() {
        return this.debugBackgroundScripts;
    }

    public synchronized void setDebugBackgroundScripts(boolean b) {
        this.debugBackgroundScripts = b;
    }

    public Set<String> getIgnoredBackgroundScripts() {
        return this.ignoredBackgroundScripts;
    }

    public void setIgnoredBackgroundScripts(Set<String> s) {
        this.ignoredBackgroundScripts = s;
    }

    public ContextFactory.Listener getContextFactoryListener() {
        return new ContextFactory.Listener(){

            public void contextCreated(Context cx) {
                if (cx.getOptimizationLevel() == -1 && !DebuggerContextImpl.suppressDebugAttach.get().booleanValue()) {
                    DebuggerImpl.this.maybeAttach(cx);
                }
            }

            public void contextReleased(Context cx) {
                if (cx.getDebugger() == DebuggerImpl.this) {
                    DebuggerImpl.this.detach(cx);
                }
            }
        };
    }

    public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, String source) {
    }

    public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
        return new DebugFrameImpl(fnOrScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDebuggerListener(DebuggerListener listener) {
        if (listener == null) {
            return;
        }
        ArrayList<DebuggerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebuggerListener(DebuggerListener listener) {
        if (listener == null) {
            return;
        }
        ArrayList<DebuggerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    public void fireDebugEvent(DebugEvent event) {
        for (DebuggerListener listener : this.cloneListeners()) {
            listener.onEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DebuggerListener> cloneListeners() {
        ArrayList<DebuggerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return (List)this.listeners.clone();
        }
    }

    protected synchronized boolean shouldAttach(Context cx) {
        boolean result = false;
        if (this.isPhobosActive()) {
            if (this.debugRequests && this.isRequestScript()) {
                if (this.requestURIPattern != null) {
                    Matcher m = this.requestURIPattern.matcher(this.getRequestURI());
                    result = m.matches();
                } else {
                    result = true;
                }
            } else if (this.debugStartupScripts && this.isStartupScript()) {
                result = true;
            } else if (this.debugBackgroundScripts && this.isBackgroundScript() && this.ignoredBackgroundScripts != null && !this.ignoredBackgroundScripts.contains(this.getBackgroundScriptName())) {
                result = true;
            }
        }
        return result;
    }

    private DebuggerContext.Type getType() {
        if (this.isStartupScript()) {
            return DebuggerContext.Type.UNKNOWN;
        }
        if (this.isRequestScript()) {
            return DebuggerContext.Type.STARTUP;
        }
        if (this.isBackgroundScript()) {
            return DebuggerContext.Type.REQUEST;
        }
        return DebuggerContext.Type.BACKGROUND;
    }

    protected boolean isPhobosActive() {
        return PhobosRuntime.getRequestContext() != null;
    }

    protected PhobosAdapter getPhobosAdapter() {
        return PhobosRuntime.getCurrentAdapter();
    }

    protected boolean isStartupScript() {
        return !this.isRequestScript() && !this.isBackgroundScript();
    }

    protected boolean isRequestScript() {
        return PhobosRuntime.getRequestContext().get("request") != null;
    }

    protected String getBackgroundScriptName() {
        Object value = PhobosRuntime.getRequestContext().get("backgroundScriptName");
        return value instanceof String ? (String)value : null;
    }

    protected boolean isBackgroundScript() {
        return this.getBackgroundScriptName() != null;
    }

    protected String getRequestURI() {
        return (String)PhobosRuntime.getRequestContext().get("requestURI");
    }
}

